/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.nature.decorators;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class ProjectDecorator
implements ILightweightLabelDecorator {
    private final Optional<ImageDescriptor> NATURE_DECORATOR = ResourceLocator.imageDescriptorFromBundle(this.getClass(), (String)"icons/sample_decorator.gif");

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IProject) {
            try {
                String[] prevNatures;
                IProjectDescription desc = ((IProject)element).getDescription();
                if (desc != null && Arrays.asList(prevNatures = desc.getNatureIds()).contains("amlt.no.load.nature")) {
                    decoration.addSuffix(" - Amalthea-no-load-activated");
                    this.NATURE_DECORATOR.ifPresent(d -> decoration.addOverlay(d, 0));
                }
            }
            catch (CoreException e) {
                Platform.getLog(this.getClass()).log((IStatus)new Status(4, "org.eclipse.app4mc.amalthea.nature", "Error on AmaltheaNoLoadNature decoration", (Throwable)e));
            }
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

