/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.ta.constraints;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.RepetitionConstraint;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="TA-Constraints-RepetitionConstraint", checks={"Upper bound must not be smaller than lower bound"})
public class TAConstraintsRepetitionConstraint
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getRepetitionConstraint();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        if (eObject instanceof RepetitionConstraint) {
            RepetitionConstraint rc = (RepetitionConstraint)eObject;
            Time lower = rc.getLower();
            Time upper = rc.getUpper();
            if (upper != null && lower != null && lower.compareTo(upper) > 0) {
                this.addIssue(results, (EObject)rc, (EStructuralFeature)ePackage.getRepetitionConstraint_Lower(), "The lower bound is greater than the upper (" + lower + " > " + upper + ", in " + this.objectInfo((EObject)rc) + ")");
            }
        }
    }
}

