/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.workflow.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.sphinx.AmaltheaResourceFactory;
import org.eclipse.app4mc.amalthea.workflow.core.Context;
import org.eclipse.app4mc.amalthea.workflow.core.WorkflowComponent;
import org.eclipse.app4mc.amalthea.workflow.core.exception.ConfigurationException;
import org.eclipse.app4mc.amalthea.workflow.core.exception.WorkflowException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.sphinx.emf.resource.ExtendedResourceSetImpl;

public class ModelWriter
extends WorkflowComponent {
    private boolean singleFile = true;
    private String outputDir;
    private String fileName;
    private static final String fileType = "amxmi";
    private final Map<String, EObject> intrinsicIDToEObjectCache = new HashMap<String, EObject>();
    private final Map<URI, Resource> uRIResourceCache = new HashMap<URI, Resource>();

    public ModelWriter() {
    }

    public ModelWriter(Logger log) {
        super(log);
    }

    @Override
    protected void runInternal(Context ctx) throws WorkflowException {
        try {
            if (this.isSingleFile()) {
                ArrayList<EObject> tmp = new ArrayList<EObject>();
                tmp.add((EObject)this.getAmaltheaModelCopy(ctx));
                this.saveModelFile(null, tmp);
            } else {
                ArrayList<EObject> tmp = new ArrayList<EObject>();
                Amalthea model = this.getAmaltheaModelCopy(ctx);
                if (model.getCommonElements() != null) {
                    tmp.add((EObject)model.getCommonElements());
                    this.saveModelFile("-common", tmp);
                }
                if (model.getHwModel() != null) {
                    tmp.clear();
                    tmp.add((EObject)model.getHwModel());
                    this.saveModelFile("-hw", tmp);
                }
                if (model.getOsModel() != null) {
                    tmp.clear();
                    tmp.add((EObject)model.getOsModel());
                    this.saveModelFile("-os", tmp);
                }
                if (model.getStimuliModel() != null) {
                    tmp.clear();
                    tmp.add((EObject)model.getStimuliModel());
                    this.saveModelFile("-stimuli", tmp);
                }
                if (model.getSwModel() != null) {
                    tmp.clear();
                    tmp.add((EObject)model.getSwModel());
                    this.saveModelFile("-sw", tmp);
                }
                if (model.getEventModel() != null) {
                    tmp.clear();
                    tmp.add((EObject)model.getEventModel());
                    this.saveModelFile("-events", tmp);
                }
                if (model.getPropertyConstraintsModel() != null) {
                    tmp.clear();
                    tmp.add((EObject)model.getPropertyConstraintsModel());
                    this.saveModelFile("-pc", tmp);
                }
                if (model.getConstraintsModel() != null) {
                    tmp.clear();
                    tmp.add((EObject)model.getConstraintsModel());
                    this.saveModelFile("-constraints", tmp);
                }
                if (model.getMappingModel() != null) {
                    tmp.clear();
                    tmp.add((EObject)model.getMappingModel());
                    this.saveModelFile("-mapping", tmp);
                }
                tmp.clear();
            }
        }
        catch (IOException e) {
            throw new WorkflowException("An error occured by writing the model!", e);
        }
    }

    @Override
    protected void checkInternal() throws ConfigurationException {
        if (this.getOutputDir() == null || this.getOutputDir().isEmpty()) {
            throw new ConfigurationException("No output directory defined!");
        }
        if (this.getFileName() == null || this.getFileName().isEmpty()) {
            throw new ConfigurationException("No filename defined!");
        }
    }

    private void saveModelFile(String filenameType, List<EObject> content) throws IOException {
        if (content != null && !content.isEmpty()) {
            String outputFilePath = this.getOutputDir();
            if (!outputFilePath.endsWith("/")) {
                outputFilePath = outputFilePath.concat("/");
            }
            outputFilePath = filenameType == null ? outputFilePath.concat(this.getFileName()).concat(".").concat(this.getFileType()) : outputFilePath.concat(this.getFileName()).concat(filenameType).concat(".").concat(this.getFileType());
            this.log.info((Object)("Writing file " + outputFilePath));
            URI tmpUri = URI.createURI((String)outputFilePath);
            ExtendedResourceSetImpl resourceSet = new ExtendedResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileType, new AmaltheaResourceFactory(true));
            resourceSet.setURIResourceMap(this.uRIResourceCache);
            Resource outResource = resourceSet.createResource(tmpUri);
            ((ResourceImpl)outResource).setIntrinsicIDToEObjectMap(this.intrinsicIDToEObjectCache);
            outResource.getContents().addAll(content);
            outResource.save(null);
        }
    }

    public boolean isSingleFile() {
        return this.singleFile;
    }

    public void setSingleFile(boolean singleFile) {
        this.singleFile = singleFile;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileType() {
        return fileType;
    }
}

