/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual;

import java.util.HashSet;
import java.util.Iterator;
import prefuse.Visualization;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.util.Index;
import prefuse.util.collections.IntIterator;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTable;
import prefuse.visual.tuple.TableAggregateItem;

public class AggregateTable
extends VisualTable {
    protected Table m_aggregated = AGGREGATED_SCHEMA.instantiate();
    protected static final String AGGREGATE = "aggregate";
    protected static final String MEMBER_HASH = "hash";
    protected static final String MEMBER = "member";
    protected static final Schema AGGREGATED_SCHEMA = new Schema();

    static {
        AGGREGATED_SCHEMA.addColumn(AGGREGATE, Integer.TYPE);
        AGGREGATED_SCHEMA.addColumn(MEMBER_HASH, Integer.TYPE);
        AGGREGATED_SCHEMA.addColumn(MEMBER, Tuple.class);
    }

    public AggregateTable(Visualization vis, String group) {
        this(vis, group, VisualItem.SCHEMA);
    }

    public AggregateTable(Visualization vis, String group, Schema schema) {
        super(vis, group, schema, TableAggregateItem.class);
        this.m_aggregated.index(AGGREGATE);
        this.m_aggregated.index(MEMBER_HASH);
    }

    public int getAggregateSize(int row) {
        int size = 0;
        AggregatedIterator ati = new AggregatedIterator(row);
        while (ati.hasNext()) {
            ++size;
            ati.next();
        }
        return size;
    }

    public void addToAggregate(int row, VisualItem member) {
        this.validRowCheck(row, true);
        if (!this.aggregateContains(row, member)) {
            int ar = this.m_aggregated.addRow();
            this.m_aggregated.setInt(ar, AGGREGATE, row);
            this.m_aggregated.setInt(ar, MEMBER_HASH, this.getHashCode(member));
            this.m_aggregated.set(ar, MEMBER, (Object)member);
            this.fireTableEvent(row, row, -1, 0);
        }
    }

    public void removeFromAggregate(int row, VisualItem member) {
        this.validRowCheck(row, true);
        int ar = this.getAggregatedRow(row, member);
        if (ar >= 0) {
            this.m_aggregated.removeRow(ar);
            this.fireTableEvent(row, row, -1, 0);
        }
    }

    public void removeAllFromAggregate(int row) {
        this.clearAggregateMappings(row, true);
    }

    protected void clearAggregateMappings(int row, boolean update) {
        Index index = this.m_aggregated.index(AGGREGATE);
        boolean fire = false;
        IntIterator rows = index.rows(row);
        while (rows.hasNext()) {
            int r = rows.nextInt();
            rows.remove();
            this.m_aggregated.removeRow(r);
            fire = true;
        }
        if (update && fire) {
            this.fireTableEvent(row, row, -1, 0);
        }
    }

    public boolean aggregateContains(int row, VisualItem member) {
        return this.getAggregatedRow(row, member) >= 0;
    }

    protected int getAggregatedRow(int row, VisualItem member) {
        int hash;
        Index index = this.m_aggregated.index(MEMBER_HASH);
        int ar = index.get(hash = this.getHashCode(member));
        if (ar < 0) {
            return -1;
        }
        if (this.m_aggregated.getInt(ar, AGGREGATE) == row) {
            return ar;
        }
        IntIterator rows = index.rows(hash);
        while (rows.hasNext()) {
            ar = rows.nextInt();
            if (this.m_aggregated.getInt(ar, AGGREGATE) != row) continue;
            return ar;
        }
        return -1;
    }

    public Iterator aggregatedTuples(int row) {
        return new AggregatedIterator(row);
    }

    public Iterator getAggregates(Tuple t) {
        int hash = this.getHashCode(t);
        IntIterator iit = this.m_aggregated.getIndex(MEMBER_HASH).rows(hash);
        HashSet<Tuple> set = new HashSet<Tuple>();
        while (iit.hasNext()) {
            int r = iit.nextInt();
            set.add(this.getTuple(this.m_aggregated.getInt(r, AGGREGATE)));
        }
        return set.iterator();
    }

    protected int getHashCode(Tuple t) {
        return t.hashCode();
    }

    protected boolean validRowCheck(int row, boolean throwException) {
        if (this.isValidRow(row)) {
            return true;
        }
        if (throwException) {
            throw new IllegalArgumentException("Invalid row value: " + row);
        }
        return false;
    }

    protected void fireTableEvent(int row0, int row1, int col, int type) {
        if (col == -1 && type == -1) {
            int r = row0;
            while (r <= row1) {
                this.clearAggregateMappings(r, false);
                ++r;
            }
        }
        super.fireTableEvent(row0, row1, col, type);
    }

    protected class AggregatedIterator
    implements Iterator {
        private IntIterator m_rows;
        private Tuple m_next = null;

        public AggregatedIterator(int row) {
            Index index = AggregateTable.this.m_aggregated.index(AggregateTable.AGGREGATE);
            this.m_rows = index.rows(row);
            this.advance();
        }

        public boolean hasNext() {
            return this.m_next != null;
        }

        public Object next() {
            Tuple retval = this.m_next;
            this.advance();
            return retval;
        }

        private void advance() {
            while (this.m_rows.hasNext()) {
                int ar = this.m_rows.nextInt();
                Tuple t = (Tuple)AggregateTable.this.m_aggregated.get(ar, AggregateTable.MEMBER);
                if (t.isValid()) {
                    this.m_next = t;
                    return;
                }
                AggregateTable.this.m_aggregated.removeRow(ar);
            }
            this.m_next = null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

