/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.jee.actions;

import java.io.File;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.jee.actions.AbstractDeploymentDescriptorDiscoverer;

public abstract class AbstractProjectDeploymentDescriptorDiscoverer
extends AbstractModelDiscoverer<Object> {
    public static final int FLUSH_LIMIT = 10000;
    private final ArrayList<Resource> resources = new ArrayList();
    private static final String XMI_EXTENSION = "xmi";

    public abstract AbstractDeploymentDescriptorDiscoverer<File> getSingleFileDiscoverer();

    public abstract Resource.Factory getDiscovererFactory();

    public boolean isApplicableTo(Object source) {
        IProject project;
        if (source instanceof IFolder) {
            return true;
        }
        if (source instanceof IPackageFragment) {
            return true;
        }
        if (source instanceof IJavaProject) {
            return ((IJavaProject)source).getProject().isAccessible();
        }
        return source instanceof IProject && (project = (IProject)source).isAccessible();
    }

    public void listXmlFiles(String path, ArrayList<File> paths) {
        File[] files;
        File projectFile = new File(path);
        File[] fileArray = files = projectFile.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.listXmlFiles(file.getPath(), paths);
            } else if ("xml".equalsIgnoreCase(new Path(file.getPath()).getFileExtension())) {
                paths.add(file);
            }
            ++n2;
        }
    }

    public static IProject getSourceProject(Object source) {
        IProject project = null;
        if (source instanceof IProject) {
            project = (IProject)source;
        } else if (source instanceof IJavaProject) {
            project = ((IJavaProject)source).getProject();
        } else if (source instanceof IFolder) {
            project = ((IFolder)source).getProject();
        } else if (source instanceof IPackageFragment) {
            project = ((IPackageFragment)source).getResource().getProject();
        }
        return project;
    }

    public static String getSourcePath(Object source) {
        String path = null;
        if (source instanceof IProject) {
            path = ((IProject)source).getLocation().toOSString();
        } else if (source instanceof IJavaProject) {
            path = ((IJavaProject)source).getPath().toOSString();
        } else if (source instanceof IFolder) {
            path = ((IFolder)source).getLocation().toOSString();
        } else if (source instanceof IPackageFragment) {
            path = ((IPackageFragment)source).getPath().toOSString();
        }
        return path;
    }

    public static Resource createResource(String resourceName) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        return resourceSet.createResource(URI.createURI((String)resourceName));
    }

    protected void basicDiscoverElement(Object source, IProgressMonitor monitor) throws DiscoveryException {
        IProject project = AbstractProjectDeploymentDescriptorDiscoverer.getSourceProject(source);
        try {
            Resource resource = AbstractProjectDeploymentDescriptorDiscoverer.createResource("platform:/resource/" + project.getProject().getName() + "/" + project.getProject().getName() + ".xmi");
            ArrayList<File> files = new ArrayList<File>();
            this.listXmlFiles(AbstractProjectDeploymentDescriptorDiscoverer.getSourcePath(source), files);
            ArrayList<Resource> resourceList = new ArrayList<Resource>();
            for (File file : files) {
                this.getSingleFileDiscoverer().discoverElement(file, monitor);
                Resource targetModel = this.getSingleFileDiscoverer().getTargetModel();
                if (targetModel == null) continue;
                resourceList.add(targetModel);
            }
            for (Resource r : resourceList) {
                resource.getContents().addAll((Collection)r.getContents());
            }
        }
        catch (Exception e) {
            throw new DiscoveryException((Throwable)e);
        }
    }

    protected void saveTargetModel() throws IOException {
        if (this.getTargetModel() != null) {
            if (this.getTargetURI() != null) {
                this.getTargetModel().setURI(this.getTargetURI());
            }
            HashMap<String, Constable> options = new HashMap<String, Constable>();
            options.put("FLUSH_THRESHOLD", Integer.valueOf(10000));
            options.put("USE_FILE_BUFFER", new Boolean(true));
            this.getTargetModel().save(options);
        }
    }

    protected ArrayList<Resource> getResources() {
        return this.resources;
    }
}

