/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.util.ui.internal.exported.util.widget;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.modisco.facet.util.ui.internal.exported.widget.IAbstractWidget;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractWidget
extends Composite
implements IAbstractWidget {
    protected static final int VERTICAL_SPACING = 2;
    protected static final int WIDTH_HINT = 110;
    private final Composite widgetParent;
    private final List<IAbstractWidget> subWidgets;
    private final List<IAbstractWidget> listeners;

    public AbstractWidget(Composite parent) {
        super(parent, 0);
        this.widgetParent = parent;
        this.subWidgets = new LinkedList<IAbstractWidget>();
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(768));
        this.listeners = new LinkedList<IAbstractWidget>();
    }

    protected void addSubWidget(IAbstractWidget widget) {
        this.subWidgets.add(widget);
    }

    protected abstract void addSubWidgets();

    protected Composite getWidgetParent() {
        return this.widgetParent;
    }

    @Override
    public abstract String getError();

    @Override
    public void createWidgetContent() {
        this.addSubWidgets();
        for (IAbstractWidget widget : this.subWidgets) {
            widget.createWidgetContent();
            widget.addListener(this);
        }
    }

    @Override
    public void addListener(AbstractWidget abstractWidget) {
        this.listeners.add(abstractWidget);
    }

    protected void fireChanged() {
        for (IAbstractWidget listener : this.listeners) {
            listener.notifyChanged();
        }
    }

    @Override
    public abstract void notifyChanged();

    public List<IAbstractWidget> getSubWidgets() {
        return this.subWidgets;
    }
}

