/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.util.emf.ui.internal.exported.util.composite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.modisco.facet.util.emf.ui.internal.Messages;
import org.eclipse.modisco.facet.util.ui.internal.exported.util.composite.FilteredElementSelectionComposite;
import org.eclipse.swt.widgets.Composite;

public class EClassifierSelectionControl<T extends EClassifier>
extends FilteredElementSelectionComposite {
    private final Map<String, T> stringToEClass = new HashMap<String, T>();
    private final Class<? extends EClassifier> eTypeSel;
    private String metamodelNsUri;

    public EClassifierSelectionControl(Composite parent, String metamodelNsUri, Class<? extends T> eTypeSel) {
        super(parent, true, false);
        this.eTypeSel = eTypeSel;
        this.metamodelNsUri = metamodelNsUri;
    }

    public void updateList(String metamodelNsUri2) {
        this.metamodelNsUri = metamodelNsUri2;
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(this.metamodelNsUri);
        if (ePackage != null) {
            ArrayList<String> eClasses = new ArrayList<String>();
            EList eClassifiers = ePackage.getEClassifiers();
            this.addElements(eClasses, (EList<EClassifier>)eClassifiers);
            if (eClasses.isEmpty()) {
                eClasses.add(Messages.No_result_found);
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            this.setElements(eClasses.toArray());
        }
    }

    private void addElements(List<String> eClasses, EList<? extends EClassifier> eClassifiers) {
        for (EClassifier eClassifier : eClassifiers) {
            if (!this.eTypeSel.isInstance(eClassifier)) continue;
            eClasses.add(eClassifier.getName());
            EClassifier eClassifier2 = eClassifier;
            this.stringToEClass.put(eClassifier.getName(), eClassifier2);
        }
    }

    public T getSelectedEClassifier() {
        EClassifier result = null;
        Object[] selectElements = this.getSelectedElements();
        if (selectElements != null && selectElements.length > 0 && this.stringToEClass.containsKey(selectElements[0])) {
            result = (EClassifier)this.stringToEClass.get(selectElements[0]);
        }
        return (T)result;
    }
}

