/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import prefuse.Display;
import prefuse.action.layout.Layout;
import prefuse.controls.ControlAdapter;
import prefuse.visual.VisualItem;

public class AnchorUpdateControl
extends ControlAdapter {
    private boolean m_anchorOverItem;
    private Layout[] m_layouts;
    private String m_action;
    private Point2D m_tmp = new Point2D.Double();

    public AnchorUpdateControl(Layout layout) {
        this(layout, null);
    }

    public AnchorUpdateControl(Layout layout, String action) {
        this(new Layout[]{layout}, action);
    }

    public AnchorUpdateControl(Layout layout, String action, boolean overItem) {
        this(new Layout[]{layout}, action, overItem);
    }

    public AnchorUpdateControl(Layout[] layout, String action) {
        this(layout, action, true);
    }

    public AnchorUpdateControl(Layout[] layout, String action, boolean overItem) {
        this.m_layouts = (Layout[])layout.clone();
        this.m_action = action;
        this.m_anchorOverItem = overItem;
    }

    public void mouseExited(MouseEvent e) {
        int i = 0;
        while (i < this.m_layouts.length) {
            this.m_layouts[i].setLayoutAnchor(null);
            ++i;
        }
        this.runAction(e);
    }

    public void mouseMoved(MouseEvent e) {
        this.moveEvent(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.moveEvent(e);
    }

    public void itemDragged(VisualItem item, MouseEvent e) {
        if (this.m_anchorOverItem) {
            this.moveEvent(e);
        }
    }

    public void itemMoved(VisualItem item, MouseEvent e) {
        if (this.m_anchorOverItem) {
            this.moveEvent(e);
        }
    }

    public void moveEvent(MouseEvent e) {
        Display d = (Display)e.getSource();
        d.getAbsoluteCoordinate(e.getPoint(), this.m_tmp);
        int i = 0;
        while (i < this.m_layouts.length) {
            this.m_layouts[i].setLayoutAnchor(this.m_tmp);
            ++i;
        }
        this.runAction(e);
    }

    private void runAction(MouseEvent e) {
        if (this.m_action != null) {
            Display d = (Display)e.getSource();
            d.getVisualization().run(this.m_action);
        }
    }
}

