/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.custom.ui.internal.query;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProvider;
import org.eclipse.modisco.facet.efacet.core.IFacetManager;
import org.eclipse.modisco.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.modisco.facet.query.java.core.IJavaQuery2;
import org.eclipse.modisco.facet.query.java.core.IParameterValueList2;
import org.eclipse.modisco.facet.util.emf.core.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelQuery
implements IJavaQuery2<EObject, String> {
    private static final String NAME = "name";

    public String evaluate(EObject source, IParameterValueList2 parameterValues, IFacetManager facetManager) throws DerivedTypedElementException {
        ETypedElement sfParam = null;
        if (parameterValues != null) {
            sfParam = (ETypedElement)parameterValues.getParameterValueByName("eStructuralFeature").getValue();
        }
        String result = null;
        if (sfParam == null) {
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)source, IItemLabelProvider.class);
            result = itemLabelProvider instanceof ReflectiveItemProvider ? LabelQuery.getDefaultName(source) : (itemLabelProvider == null ? ModelUtils.getDefaultName((EObject)source) : itemLabelProvider.getText((Object)source));
        } else {
            try {
                if (sfParam instanceof EAttribute && sfParam.getUpperBound() == 1) {
                    Object object = facetManager.getOrInvoke(source, sfParam, Object.class);
                    String objectLabel = this.getObjectLabel(object, facetManager);
                    result = String.valueOf(sfParam.getName()) + " = " + objectLabel;
                } else {
                    result = sfParam.getName();
                }
            }
            catch (Exception e) {
                throw new DerivedTypedElementException((Throwable)e);
            }
        }
        return result;
    }

    private String getObjectLabel(Object object, IFacetManager facetManager) throws DerivedTypedElementException {
        String result;
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            result = this.evaluate(eObject, null, facetManager);
        } else {
            result = String.valueOf(object);
        }
        return result;
    }

    public static String getDefaultName(EObject eObject) {
        String result = "";
        EStructuralFeature feature = LabelQuery.getLabelFeature(eObject.eClass());
        if (feature != null) {
            result = (String)eObject.eGet(feature);
        }
        return result;
    }

    private static EStructuralFeature getLabelFeature(EClass eClass) {
        EAttribute result = null;
        for (EAttribute eAttribute : eClass.getEAllAttributes()) {
            if (eAttribute.isMany() || eAttribute.getEType().getInstanceClass() == FeatureMap.Entry.class) continue;
            if (NAME.equalsIgnoreCase(eAttribute.getName())) {
                result = eAttribute;
                break;
            }
            if (result == null) {
                result = eAttribute;
                continue;
            }
            if (eAttribute.getEAttributeType().getInstanceClass() != String.class || result.getEAttributeType().getInstanceClass() == String.class) continue;
            result = eAttribute;
        }
        return result;
    }
}

