/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.custom.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.modisco.facet.custom.core.ICustomizationPropertiesCatalogManager;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.modisco.facet.util.emf.core.catalog.ICatalogManager;
import org.eclipse.modisco.facet.util.emf.core.catalog.ICatalogManagerConfiguration;
import org.eclipse.modisco.facet.util.emf.core.catalog.ICatalogManagerFactory;

public class CustomizationPropertiesCatalogManager
implements ICustomizationPropertiesCatalogManager {
    private static final String CUSTOM_SUFIX = "customproperties";
    private final ICatalogManager catalogMgr;

    public CustomizationPropertiesCatalogManager(ResourceSet resourceSet) {
        CatalogManagerConfiguration catalogMgrConfig = new CatalogManagerConfiguration();
        this.catalogMgr = ICatalogManagerFactory.DEFAULT.getOrCreateCatalogManager((ICatalogManagerConfiguration)catalogMgrConfig, resourceSet, this.getClass().getName());
    }

    @Override
    public List<FacetSet> getAllRegisteredCustomizationPropertySet() {
        ArrayList<FacetSet> result = new ArrayList<FacetSet>();
        for (EObject eObject : this.catalogMgr.getInstalledEntries(EObject.class)) {
            if (eObject instanceof FacetSet) {
                FacetSet facetSet = (FacetSet)eObject;
                result.add(facetSet);
                continue;
            }
            throw new RuntimeException("Only facetSets must be stored in the customization properties catalog");
        }
        return result;
    }

    @Override
    public List<FacetOperation> getCustomizationPropertiesByName(String customPropName) {
        ArrayList<FacetOperation> result = new ArrayList<FacetOperation>();
        for (EObject facetSet : this.catalogMgr.getInstalledEntries(EObject.class)) {
            TreeIterator iterator = facetSet.eAllContents();
            while (iterator.hasNext()) {
                FacetOperation customProperty;
                EObject eObject = (EObject)iterator.next();
                if (!(eObject instanceof FacetOperation) || !customPropName.equals((customProperty = (FacetOperation)eObject).getName())) continue;
                result.add(customProperty);
            }
        }
        return result;
    }

    public class CatalogManagerConfiguration
    implements ICatalogManagerConfiguration {
        public boolean canBeManaged(EObject root) {
            return root instanceof FacetSet;
        }

        public boolean isValid(EObject root) {
            boolean result = false;
            if (root instanceof FacetSet) {
                FacetSet customProperties = (FacetSet)root;
                result = customProperties.getName().endsWith(CustomizationPropertiesCatalogManager.CUSTOM_SUFIX);
            }
            return result;
        }
    }
}

