/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.tests.filters;

import junit.textui.TestRunner;
import org.eclipse.ocl.examples.eventmanager.EventFilter;
import org.eclipse.ocl.examples.eventmanager.EventManagerFactory;
import org.eclipse.ocl.examples.eventmanager.tests.filters.LogicalEventFilterTest;

public class AndFilterTest
extends LogicalEventFilterTest {
    public static void main(String[] args) {
        TestRunner.run(AndFilterTest.class);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setFixture(EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{this.trueFilter, this.trueFilter}));
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.setFixture(null);
        this.falseFilter = null;
        this.trueFilter = null;
    }

    public void testMatchesFor__NotificationTwoTrue() {
        EventFilter andFilter = EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{this.trueFilter, this.trueFilter});
        AndFilterTest.assertTrue((String)"Two true is true", (boolean)andFilter.matchesFor(null));
    }

    public void testMatchesFor__NotificationTwoFalse() {
        EventFilter andFilter = EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{this.falseFilter, this.falseFilter});
        AndFilterTest.assertFalse((String)"Two false is false", (boolean)andFilter.matchesFor(null));
    }

    @Override
    public void testMatchesFor__Notification() {
        EventFilter andFilter = EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{this.falseFilter, this.trueFilter});
        AndFilterTest.assertFalse((String)"Two true/false is false", (boolean)andFilter.matchesFor(null));
    }

    @Override
    Object getFilterCriterion1() {
        return 1;
    }

    @Override
    Object getFilterCriterion2() {
        return 2;
    }

    @Override
    EventFilter getFilterFor(Object f) {
        if (f == null) {
            return EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{this.trueFilter, this.trueFilter});
        }
        if ((Integer)f == 1) {
            return EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{this.falseFilter, this.trueFilter});
        }
        return EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{this.falseFilter, this.falseFilter});
    }
}

