/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.opposites.DefaultOppositeEndFinder;
import org.eclipse.ocl.ecore.opposites.EcoreEnvironmentFactoryWithHiddenOpposites;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.ecore.tests.extlibrary.Book;
import org.eclipse.ocl.ecore.tests.extlibrary.EXTLibraryFactory;
import org.eclipse.ocl.ecore.tests.extlibrary.EXTLibraryPackage;
import org.eclipse.ocl.ecore.tests.extlibrary.Library;
import org.eclipse.ocl.expressions.OCLExpression;

public class DocumentationExamples
extends AbstractTestSuite {
    public InputStream getInputStream(String fileName) throws MalformedURLException, IOException {
        URI uri = this.getTestModelURI(fileName);
        return resourceSet.getURIConverter().createInputStream(uri);
    }

    private List<Library> getLibraries() {
        return Collections.emptyList();
    }

    public Library getLibrary() {
        Library library = EXTLibraryFactory.eINSTANCE.createLibrary();
        Book aBook = EXTLibraryFactory.eINSTANCE.createBook();
        aBook.setTitle("Bleak House");
        library.getBooks().add((Object)aBook);
        return library;
    }

    public void test_parsingConstraintsExample() throws IOException, ParserException {
        OCL ocl = OCL.newInstance((EnvironmentFactory)EcoreEnvironmentFactory.INSTANCE);
        OCL.Helper helper = ocl.createOCLHelper();
        helper.setContext((Object)EXTLibraryPackage.Literals.LIBRARY);
        Constraint invariant = (Constraint)helper.createInvariant("books->forAll(b1, b2 | b1 <> b2 implies b1.title <> b2.title)");
        OCLExpression query = helper.createQuery("books->collect(b : Book | b.category)->asSet()");
        EOperation oper = null;
        for (EOperation next : EcorePackage.Literals.EMODEL_ELEMENT.getEOperations()) {
            if (!"getEAnnotation".equals(next.getName())) continue;
            oper = next;
            break;
        }
        helper.setOperationContext((Object)EcorePackage.Literals.ECLASS, oper);
        Constraint body = (Constraint)helper.createPostcondition("result = self.eAnnotations->any(ann | ann.source = source)");
        helper.setAttributeContext((Object)EcorePackage.Literals.EREFERENCE, (Object)EcorePackage.Literals.EREFERENCE__EREFERENCE_TYPE);
        Constraint derive = (Constraint)helper.createDerivedValueExpression("self.eType->any(true).oclAsType(EClass)");
        if (body == derive) {
            // empty if block
        }
    }

    public void test_evaluatingConstraintsExample() throws IOException, ParserException {
        OCL ocl = OCL.newInstance((EnvironmentFactory)EcoreEnvironmentFactory.INSTANCE);
        OCL.Helper helper = ocl.createOCLHelper();
        helper.setContext((Object)EXTLibraryPackage.Literals.LIBRARY);
        Constraint invariant = (Constraint)helper.createInvariant("books->forAll(b1, b2 | b1 <> b2 implies b1.title <> b2.title)");
        OCLExpression query = helper.createQuery("books->collect(b : Book | b.category)->asSet()");
        OCL.Query queryEval = ocl.createQuery(query);
        OCL.Query constraintEval = ocl.createQuery(invariant);
        List<Library> libraries = this.getLibraries();
        for (Library next : libraries) {
            if (!constraintEval.check((Object)next)) continue;
            Set categories = (Set)queryEval.evaluate((Object)next);
            if (noDebug) continue;
            System.out.printf("%s: %s\n", next.getName(), categories);
        }
        Library lib = this.getLibrary();
        if (!noDebug) {
            System.out.printf("%s valid: %b\n", lib.getName(), ocl.check((Object)lib, (Object)invariant));
        }
        for (Library next : constraintEval.select(libraries)) {
            Set categories = (Set)queryEval.evaluate((Object)next);
            if (noDebug) continue;
            System.out.printf("%s: %s%n", next.getName(), categories);
        }
    }

    public void test_parsingDocumentsExample() throws IOException, ParserException {
        EPackageRegistryImpl registry = new EPackageRegistryImpl();
        registry.put((Object)"http:///org/eclipse/ocl/examples/tests/extlibrary.ecore/1.0.0", (Object)EXTLibraryPackage.eINSTANCE);
        EcoreEnvironmentFactory environmentFactory = new EcoreEnvironmentFactory((EPackage.Registry)registry);
        OCL ocl = OCL.newInstance((EnvironmentFactory)environmentFactory);
        HashMap<String, Constraint> constraintMap = new HashMap<String, Constraint>();
        try (InputStream in = this.getInputStream("/model/parsingDocumentsExample.ocl");){
            OCLInput document = new OCLInput(in);
            List constraints = ocl.parse(document);
            for (Constraint next : constraints) {
                constraintMap.put(next.getName(), next);
                OCLExpression body = next.getSpecification().getBodyExpression();
                if (noDebug) continue;
                System.out.printf("%s: %s%n", next.getName(), body);
            }
        }
        Library library = this.getLibrary();
        OCL.Helper helper = ocl.createOCLHelper();
        helper.setContext((Object)EXTLibraryPackage.Literals.LIBRARY);
        OCLExpression query = helper.createQuery("getBooks('Bleak House')->asSequence()->first()");
        Book book = (Book)ocl.evaluate((Object)library, query);
        if (!noDebug) {
            System.out.printf("Got book: %s%n", book);
        }
        if (!noDebug) {
            System.out.printf("Validate book: %b%n", ocl.check((Object)book, (Object)((Constraint)constraintMap.get("unique_title"))));
        }
    }

    public void testCustomizingOppositeEndFinder() {
        MyOppositeEndFinder oef = new MyOppositeEndFinder();
        OCL ocl = OCL.newInstance((EnvironmentFactory)new EcoreEnvironmentFactoryWithHiddenOpposites(EPackage.Registry.INSTANCE, (OppositeEndFinder)oef));
        DocumentationExamples.assertSame((Object)((Object)oef), (Object)((EcoreEnvironment)ocl.getEnvironment()).getOppositeEndFinder());
    }

    private class MyOppositeEndFinder
    extends DefaultOppositeEndFinder {
        public MyOppositeEndFinder() {
            super(EPackage.Registry.INSTANCE);
        }
    }
}

