/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import modelmanagement.Package;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.model.ModelReference;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.model.ResourceTraversalHelper;

public class PackageDependencyGraph {
    private Map<Package, Collection<EObject>> aggregatedElements;
    private Map<Package, List<Package>> dependencies;
    private Collection<EObject> modelElementList;

    public PackageDependencyGraph(Resource resource) {
        this.buildDependencyGraph(resource);
    }

    public int getNumberOfPackages() {
        assert (this.aggregatedElements.size() == this.dependencies.size());
        return this.dependencies.size();
    }

    public Map<Package, List<Package>> getDependencies() {
        return this.dependencies;
    }

    public Collection<Package> getAllPackages() {
        return this.dependencies.keySet();
    }

    public void removePackage(Package packageToRemove) {
        this.modelElementList.removeAll(this.aggregatedElements.get(packageToRemove));
        this.aggregatedElements.remove(packageToRemove);
        for (Package pack : this.dependencies.keySet()) {
            boolean packageWasRemoved = false;
            while (packageWasRemoved = this.dependencies.get(pack).remove(packageToRemove)) {
            }
        }
        this.dependencies.remove(packageToRemove);
    }

    private void buildDependencyGraph(Resource resourceToShrink) {
        this.aggregateElementsInPackages(resourceToShrink);
        Collection<ModelReference> modelReferenceList = ResourceTraversalHelper.getModelReferencesForModelElements(this.modelElementList);
        for (Package key : this.aggregatedElements.keySet()) {
            Collection<EObject> elementInPackageList = this.aggregatedElements.get(key);
            for (EObject elementInPackage : elementInPackageList) {
                for (ModelReference modelReference : modelReferenceList) {
                    if (!elementInPackage.equals(modelReference.getFrom())) continue;
                    Package referencedPackage = this.navigateToPackage(modelReference.getTo());
                    List<Package> contents = this.dependencies.get(referencedPackage);
                    if (contents == null) {
                        contents = new ArrayList<Package>();
                    }
                    if (referencedPackage == null || !referencedPackage.equals(key)) {
                        contents.add(key);
                    }
                    this.dependencies.put(referencedPackage, contents);
                }
            }
        }
    }

    private void aggregateElementsInPackages(Resource resourceToShrink) {
        this.dependencies = new HashMap<Package, List<Package>>();
        this.modelElementList = ResourceTraversalHelper.getModelElementsInResource(resourceToShrink);
        this.aggregatedElements = this.aggregateElementsInPackages(this.modelElementList);
    }

    private HashMap<Package, Collection<EObject>> aggregateElementsInPackages(Collection<EObject> modelElementList) {
        HashMap<Package, Collection<EObject>> result = new HashMap<Package, Collection<EObject>>();
        for (EObject object : modelElementList) {
            Package pack = this.navigateToPackage(object);
            Collection<EObject> aggregatedElements = result.get(pack);
            if (aggregatedElements == null) {
                aggregatedElements = new ArrayList<EObject>();
            }
            aggregatedElements.add(object);
            result.put(pack, aggregatedElements);
        }
        return result;
    }

    private Package navigateToPackage(EObject containedElement) {
        EObject container = containedElement;
        while (container.eContainer() != null && !(container instanceof Package)) {
            container = container.eContainer();
        }
        if (container.equals(containedElement)) {
            return null;
        }
        if (container instanceof Package) {
            return (Package)container;
        }
        return null;
    }
}

