/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.tests;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.tests.GenericTestSuite;

public abstract class GenericKeywordsTest<E extends EObject, PK extends E, T extends E, C extends T, CLS extends C, DT extends C, PT extends C, ET extends DT, O extends E, PM extends E, P extends E, PA extends P, PR extends P, EL, S, COA, SSA, CT>
extends GenericTestSuite<E, PK, T, C, CLS, DT, PT, ET, O, PM, P, PA, PR, EL, S, COA, SSA, CT> {
    PK smalltalk;
    CLS collection;
    CLS block;
    protected CLS elseClass;
    CLS clazz;
    CLS property;
    CLS constraint;

    @Override
    protected void setUp() {
        super.setUp();
        this.smalltalk = (EObject)this.reflection.createPackage("Smalltalk");
        this.registerPackage(this.smalltalk, "st", "foo://smalltalk");
        EObject object = (EObject)this.reflection.createOwnedClass(this.smalltalk, "Object", false);
        this.collection = (EObject)this.reflection.createOwnedClass(this.smalltalk, "Collection", false);
        this.block = (EObject)this.reflection.createOwnedClass(this.smalltalk, "Block", false);
        this.clazz = (EObject)this.reflection.createOwnedClass(this.smalltalk, "Class", false);
        this.property = (EObject)this.reflection.createOwnedClass(this.smalltalk, "Property", false);
        this.constraint = (EObject)this.reflection.createOwnedClass(this.smalltalk, "Constraint", false);
        this.reflection.addSupertype(this.constraint, object);
        this.reflection.addSupertype(this.property, object);
        this.reflection.addSupertype(this.clazz, object);
        this.reflection.addSupertype(this.block, object);
        this.reflection.addSupertype(this.collection, object);
        EObject visibilityKind = (EObject)this.reflection.createOwnedEnumeration(this.smalltalk, "VisibilityKind");
        this.reflection.createOwnedLiteral(visibilityKind, "public");
        this.reflection.createOwnedLiteral(visibilityKind, "protected");
        this.reflection.createOwnedLiteral(visibilityKind, "package");
        this.reflection.createOwnedLiteral(visibilityKind, "private");
        this.reflection.createOwnedAttribute(this.clazz, "name", (EObject)this.reflection.getUMLString());
        this.reflection.createOwnedAttribute(this.clazz, "visibility", visibilityKind);
        this.reflection.createOwnedReference(this.clazz, "package", object);
        this.reflection.createOwnedAttribute(this.property, "isUnique", (EObject)this.reflection.getUMLBoolean());
        this.reflection.createOwnedAttribute(this.property, "upper", (EObject)this.reflection.getUMLInteger());
        this.reflection.createOwnedReference(this.constraint, "context", this.clazz);
        BasicEList names = new BasicEList(1);
        BasicEList types = new BasicEList(1);
        names.add((Object)"object");
        types.add((Object)object);
        this.reflection.createOwnedOperation(this.block, "context", (EList<String>)names, types, this.clazz, true);
        names.set(0, (Object)"block");
        types.set(0, this.block);
        this.reflection.createOwnedOperation(this.collection, "isUnique", (EList<String>)names, types, (EObject)this.reflection.getUMLBoolean(), true);
        this.reflection.createOwnedOperation(this.collection, "select", (EList<String>)names, types, this.collection, true);
        names.clear();
        types.clear();
        this.reflection.createOwnedOperation(this.collection, "isEmpty", (EList<String>)names, types, (EObject)this.reflection.getUMLBoolean(), true);
        EObject nested = (EObject)this.reflection.createNestedPackage(this.smalltalk, "runtime");
        EObject contextPackage = this.reflection.createNestedPackage(nested, "context");
        this.reflection.createOwnedClass(contextPackage, "language", false);
        this.elseClass = (EObject)this.reflection.createOwnedClass(contextPackage, "else", false);
        this.reflection.createOwnedOperation(this.elseClass, "doIt", null, null, null, false);
    }

    public void test_isUnique_162300() {
        this.assertInvariant(this.property, "self.isUnique implies self.upper > 1");
        this.assertInvariant(this.property, "isUnique implies self.upper > 1");
    }

    public void test_package_162300() {
        this.assertInvariant(this.clazz, "self._package.oclIsUndefined() implies Set{VisibilityKind::protected, VisibilityKind::_package}->excludes(self.visibility)");
        this.assertInvariant(this.clazz, "_package.oclIsUndefined() implies Set{VisibilityKind::protected, VisibilityKind::_package}->excludes(self.visibility)");
        this.assertInvariant(this.clazz, "_'package'.oclIsUndefined() implies Set{VisibilityKind::protected, VisibilityKind::_package}->excludes(self.visibility)");
    }

    public void test_context_162300() {
        this.assertInvariant(this.constraint, "self._context <> null implies _context.oclIsKindOf(Class)");
        this.assertInvariant(this.constraint, "_context <> null implies self._context.oclIsKindOf(Class)");
        this.assertInvariant(this.constraint, "_'con''te' 'x'\n't' <> null implies self._context.oclIsKindOf(Class)");
    }

    public void test_isUniqueOperation_162300() {
        this.createVariableInEnvironment("aBlock", this.block);
        this.assertInvariant(this.collection, "self.isUnique(aBlock)");
        this.assertInvariant(this.collection, "isUnique(aBlock)");
    }

    public void test_selectOperation_162300() {
        this.createVariableInEnvironment("aBlock", this.block);
        this.assertInvariant(this.collection, "self.select(aBlock).isEmpty()");
        this.assertInvariant(this.collection, "select(aBlock).isEmpty()");
    }

    public void test_contextOperation_162300() {
        this.assertInvariant(this.block, "self._context(self).name = 'Block'");
        this.assertInvariant(this.block, "_context(self).name = 'Block'");
        this.assertInvariant(this.block, "_'context'(self).name = 'Block'");
    }

    public void test_reservedPackageName_183362() {
        this.assertInvariant(this.block, "Smalltalk::runtime::_context::language.allInstances()->notEmpty()");
    }

    public void test_reservedPackageName_packageContext_183362() {
        this.createDocument("package Smalltalk::runtime::_context context language inv: true endpackage");
    }

    public void test_reservedClassName_183362() {
        this.assertInvariant(this.elseClass, "let e : _else = self in _else.allInstances()->forAll(oclIsKindOf(_else))");
        this.assertInvariant(this.elseClass, "self.oclIsKindOf(_context::_else)");
    }

    public void test_reservedClassName_operationContext_183362() {
        this.createDocument("package Smalltalk context runtime::_context::_else::doIt() : pre: true endpackage");
        this.createDocument("package Smalltalk::runtime::_context context _else::doIt() : pre: true endpackage");
    }

    public void test_unexpectedCharacter_283509() {
        this.helper.setContext(this.property);
        try {
            this.helper.createInvariant("self = #self");
            GenericKeywordsTest.fail((String)"Missing exception");
        }
        catch (Exception e) {
            GenericKeywordsTest.assertEquals((String)"2:6 \"#\" unexpected character ignored", (String)e.getLocalizedMessage());
        }
    }
}

