/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.helper.tests;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.helper.tests.AbstractTestSuite;
import org.eclipse.ocl.ecore.tests.MessagesTest;
import org.eclipse.ocl.ecore.tests.StatesTest;
import org.eclipse.ocl.helper.Choice;
import org.eclipse.ocl.helper.ChoiceKind;
import org.eclipse.ocl.helper.ConstraintKind;

public class SyntaxHelpTest
extends AbstractTestSuite {
    public void testMetaModelCompletionsForOppositePropertyCallExp() {
        this.helper.setContext((Object)this.apple);
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "droppedUnderTree");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "tree");
        choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.tree.");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "fruits");
        this.helper.setContext((Object)this.stem);
        choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "stemOfApple");
    }

    public void testMetaModelCompletions() {
        this.helper.setContext((Object)EcorePackage.eINSTANCE.getEClass());
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "eAttributes");
        choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.name.");
        this.assertChoice(choices, ChoiceKind.OPERATION, "toLower");
    }

    public void test_completeInvariant_enumLiteral() {
        this.helper.setContext((Object)this.fruit);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "color <> Color::");
            SyntaxHelpTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.ENUMERATION_LITERAL, "red");
            this.assertChoice(choices, ChoiceKind.ENUMERATION_LITERAL, "brown");
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_completeInvariant_attribute() {
        this.helper.setContext((Object)this.fruit);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            SyntaxHelpTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.PROPERTY, "color");
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_completeInvariant_reference() {
        this.helper.setContext((Object)this.apple);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            SyntaxHelpTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.PROPERTY, "stem");
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_completeInvariant_operation() {
        this.helper.setContext((Object)this.fruit);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            SyntaxHelpTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.OPERATION, "preferredColor");
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_completePrecondition_enumLiteral() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_ripen);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.PRECONDITION, "color <> Color::");
            SyntaxHelpTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.ENUMERATION_LITERAL, "red");
            this.assertChoice(choices, ChoiceKind.ENUMERATION_LITERAL, "brown");
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_completeBodyCondition_attribute() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_preferredColor);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.BODYCONDITION, "self.");
            SyntaxHelpTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.PROPERTY, "color");
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_completePrecondition_reference() {
        this.helper.setOperationContext((Object)this.apple, (Object)this.apple_labelOper);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.PRECONDITION, "self.");
            SyntaxHelpTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.PROPERTY, "stem");
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_completePostcondition_operation() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_ripen);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.POSTCONDITION, "self.");
            SyntaxHelpTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.OPERATION, "preferredColor");
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_completePrecondition_parameter() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.apple_labelOper);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.PRECONDITION, "text.");
            SyntaxHelpTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.OPERATION, "toLower");
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_completePostcondition_result() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_preferredColor);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.POSTCONDITION, "result.");
            SyntaxHelpTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.OPERATION, "oclIsUndefined");
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_allInstances() {
        this.helper.setContext((Object)this.apple);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            SyntaxHelpTest.assertNotNull((Object)choices);
            this.assertNotChoice(choices, ChoiceKind.OPERATION, "allInstances");
            choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "Apple.");
            SyntaxHelpTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.OPERATION, "allInstances");
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_anyChoices() {
        this.helper.setContext((Object)this.apple);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.oclAsType(OclAny).");
            this.dumpChoices(choices);
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_eclassChoices() {
        this.helper.setContext((Object)this.apple);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            this.dumpChoices(choices);
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_tupleChoices() {
        this.helper.setContext((Object)this.apple);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "Tuple{s : String = null, a : Apple = null}.");
            this.dumpChoices(choices);
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_typeChoices() {
        this.helper.setContext((Object)this.apple);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "Apple.");
            this.dumpChoices(choices);
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_integerChoices() {
        this.helper.setContext((Object)this.apple);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "1.");
            this.dumpChoices(choices);
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_realChoices() {
        this.helper.setContext((Object)this.apple);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "1.0.");
            this.dumpChoices(choices);
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_stringChoices() {
        this.helper.setContext((Object)this.apple);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "'foo'.");
            this.dumpChoices(choices);
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_setChoices() {
        this.helper.setContext((Object)this.apple);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "Set{self}->");
            SyntaxHelpTest.assertNotNull((Object)choices);
            this.dumpChoices(choices);
            this.assertChoice(choices, ChoiceKind.OPERATION, "union");
            this.assertChoice(choices, ChoiceKind.OPERATION, "forAll");
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_orderedSetChoices() {
        this.helper.setContext((Object)this.apple);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "OrderedSet{self}->");
            SyntaxHelpTest.assertNotNull((Object)choices);
            this.dumpChoices(choices);
            this.assertChoice(choices, ChoiceKind.OPERATION, "subOrderedSet");
            this.assertChoice(choices, ChoiceKind.OPERATION, "forAll");
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_sequenceChoices() {
        this.helper.setContext((Object)this.apple);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "Sequence{self}->");
            SyntaxHelpTest.assertNotNull((Object)choices);
            this.dumpChoices(choices);
            this.assertChoice(choices, ChoiceKind.OPERATION, "subSequence");
            this.assertChoice(choices, ChoiceKind.OPERATION, "forAll");
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_bagChoices() {
        this.helper.setContext((Object)this.apple);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "Bag{self}->");
            SyntaxHelpTest.assertNotNull((Object)choices);
            this.dumpChoices(choices);
            this.assertChoice(choices, ChoiceKind.OPERATION, "intersection");
            this.assertChoice(choices, ChoiceKind.OPERATION, "forAll");
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_nestedCollectionChoices() {
        this.helper.setContext((Object)this.apple);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "Set{Sequence{self}}->");
            this.dumpChoices(choices);
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_stateChoices() {
        this.ocl.dispose();
        this.ocl = OCL.newInstance((EnvironmentFactory)new StatesTest.StatefulFruitEnvironmentFactory(this));
        this.helper = this.ocl.createOCLHelper();
        this.helper.setContext((Object)this.apple);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.oclIsInState(");
            this.dumpChoices(choices);
            SyntaxHelpTest.debugPrintln((String)"----");
            choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.oclIsInState(Bad::");
            this.dumpChoices(choices);
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_messageChoices() {
        this.expectModified = true;
        this.ocl.dispose();
        this.ocl = OCL.newInstance((EnvironmentFactory)new MessagesTest.MessagingFruitEnvironmentFactory(this));
        this.helper = this.ocl.createOCLHelper();
        this.helper.setOperationContext((Object)this.apple, (Object)this.fruit_ripen);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.POSTCONDITION, "self^^");
            this.dumpChoices(choices);
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_completeOperationCallFollowedByArrow() {
        this.helper.setContext((Object)this.apple);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "true and false implies preferredLabel(label)->");
            this.assertChoice(choices, ChoiceKind.OPERATION, "forAll");
            this.assertChoice(choices, ChoiceKind.OPERATION, "size");
            this.assertNotChoice(choices, ChoiceKind.PROPERTY, "label");
            this.assertNotChoice(choices, ChoiceKind.OPERATION, "preferredLabel");
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_completeAfterOpeningParenthesis() {
        this.helper.setContext((Object)this.apple);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "preferredLabel((label).");
            this.assertChoice(choices, ChoiceKind.OPERATION, "concat");
            this.assertChoice(choices, ChoiceKind.OPERATION, "toUpper");
            this.assertNotChoice(choices, ChoiceKind.PROPERTY, "label");
            this.assertNotChoice(choices, ChoiceKind.OPERATION, "preferredLabel");
            choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "Set{label.");
            this.assertChoice(choices, ChoiceKind.OPERATION, "concat");
            this.assertChoice(choices, ChoiceKind.OPERATION, "toUpper");
            this.assertNotChoice(choices, ChoiceKind.PROPERTY, "label");
            this.assertNotChoice(choices, ChoiceKind.OPERATION, "preferredLabel");
            choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "preferredLabel(Set{label}->");
            this.assertChoice(choices, ChoiceKind.OPERATION, "union");
            this.assertChoice(choices, ChoiceKind.OPERATION, "size");
            this.assertNotChoice(choices, ChoiceKind.PROPERTY, "concat");
            this.assertNotChoice(choices, ChoiceKind.PROPERTY, "label");
            this.assertNotChoice(choices, ChoiceKind.OPERATION, "preferredLabel");
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_completeAfterInfixOperation() {
        this.helper.setContext((Object)this.apple);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "true and 3 * label.");
            this.assertChoice(choices, ChoiceKind.OPERATION, "concat");
            this.assertChoice(choices, ChoiceKind.OPERATION, "size");
            this.assertNotChoice(choices, ChoiceKind.PROPERTY, "abs");
            this.assertNotChoice(choices, ChoiceKind.PROPERTY, "label");
            this.assertNotChoice(choices, ChoiceKind.OPERATION, "preferredLabel");
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_completeAfterThen() {
        this.helper.setContext((Object)this.apple);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "if foo then label.");
            this.assertChoice(choices, ChoiceKind.OPERATION, "concat");
            this.assertChoice(choices, ChoiceKind.OPERATION, "size");
            this.assertNotChoice(choices, ChoiceKind.PROPERTY, "label");
            this.assertNotChoice(choices, ChoiceKind.OPERATION, "preferredLabel");
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_parentheseEscapeLeftBoundaries() {
        this.helper.setContext((Object)this.apple);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "and (if true then (label) else '' endif).");
            this.assertChoice(choices, ChoiceKind.OPERATION, "concat");
            this.assertChoice(choices, ChoiceKind.OPERATION, "size");
            this.assertNotChoice(choices, ChoiceKind.PROPERTY, "label");
            this.assertNotChoice(choices, ChoiceKind.OPERATION, "preferredLabel");
        }
        catch (Exception e) {
            SyntaxHelpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    private void dumpChoices(Collection<Choice> choices) {
        SyntaxHelpTest.assertNotNull(choices);
        for (Choice next : choices) {
            SyntaxHelpTest.debugPrintln((String)("    " + next));
        }
    }
}

