/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.standalone;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.export.HTMLExporter;
import org.eclipse.ocl.examples.emf.validation.validity.export.TextExporter;
import org.eclipse.ocl.examples.standalone.HelpCommand;
import org.eclipse.ocl.examples.standalone.StandaloneApplication;
import org.eclipse.ocl.examples.standalone.StandaloneCommand;
import org.eclipse.ocl.examples.standalone.StandaloneCommandAnalyzer;
import org.eclipse.ocl.examples.standalone.validity.ValidateCommand;
import org.eclipse.ocl.examples.test.standalone.StandaloneTestCase;
import org.eclipse.ocl.examples.xtext.tests.TestCaseLogger;
import org.eclipse.ocl.pivot.utilities.AbstractEnvironmentFactory;
import org.junit.Test;

public class StandaloneParserTests
extends StandaloneTestCase {
    protected static void assertCommandInvalid(@NonNull StandaloneCommand command, @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull StandaloneCommand.CommandToken, @NonNull List<@NonNull String>> token2strings) {
        boolean status = command.analyze(token2strings);
        StandaloneParserTests.assertFalse((boolean)status);
    }

    protected static void assertCommandValid(@NonNull StandaloneCommand command, @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull StandaloneCommand.CommandToken, @NonNull List<@NonNull String>> token2strings) {
        boolean status = command.analyze(token2strings);
        StandaloneParserTests.assertTrue((boolean)status);
    }

    protected List<String> normalize(List<String> strings) throws IOException {
        ArrayList<String> normalized = new ArrayList<String>(strings.size());
        for (String string : strings) {
            normalized.add(this.normalize(string));
        }
        return normalized;
    }

    protected String normalize(String string) throws IOException {
        try {
            return new File(string).getCanonicalPath();
        }
        catch (Exception e) {
            return string;
        }
    }

    protected <T extends StandaloneCommand> @NonNull T parseCommand(@NonNull StandaloneApplication standaloneApplication, @NonNull Class<@NonNull T> commandClass, @NonNull String @NonNull [] arguments) {
        StandaloneCommandAnalyzer commandAnalyzer = new StandaloneCommandAnalyzer(standaloneApplication);
        StandaloneCommand command = commandAnalyzer.parse(arguments);
        assert (command != null);
        StandaloneParserTests.assertEquals(commandClass, command.getClass());
        return (T)command;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void parseInvalidArguments(@NonNull StandaloneCommand command, @NonNull String @NonNull [] arguments) {
        @NonNull @NonNull @NonNull Map token2strings = command.parse(arguments);
        StandaloneParserTests.assertFalse((boolean)command.parseCheck(token2strings));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull StandaloneCommand.CommandToken, @NonNull List<@NonNull String>> parseValidArguments(@NonNull StandaloneCommand command, @NonNull String @NonNull [] arguments) {
        @NonNull @NonNull @NonNull Map token2strings = command.parse(arguments);
        StandaloneParserTests.assertTrue((boolean)command.parseCheck(token2strings));
        assert (token2strings != null);
        return token2strings;
    }

    @Test
    public void testStandaloneParser_help() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"help"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        HelpCommand command = this.parseCommand(standaloneApplication, HelpCommand.class, arguments);
        Map<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull StandaloneCommand.CommandToken, @NonNull List<@NonNull String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertEquals((int)0, (int)token2strings.size());
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneParser_help_extraText() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            @NonNull String @NonNull [] arguments = new String[]{"help", "yy"};
            StandaloneApplication standaloneApplication = new StandaloneApplication();
            HelpCommand command = this.parseCommand(standaloneApplication, HelpCommand.class, arguments);
            this.parseInvalidArguments((StandaloneCommand)command, arguments);
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("Bad 'help' command"));
            standaloneApplication.stop();
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void testStandaloneParser_mandatoryArguments() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI)};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        ValidateCommand command = this.parseCommand(standaloneApplication, ValidateCommand.class, arguments);
        Map<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull StandaloneCommand.CommandToken, @NonNull List<@NonNull String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals(null, (Object)command.exporterToken.getExporter());
        StandaloneParserTests.assertEquals((String)String.valueOf(this.inputModelURI), (String)command.modelToken.getModelFileName());
        StandaloneParserTests.assertEquals(null, (Object)command.outputToken.getOutputFile());
        StandaloneParserTests.assertEquals(this.normalize(Lists.newArrayList((Object[])new String[]{String.valueOf(this.inputOCLURI)})), this.normalize(command.rulesToken.getOCLFileNames()));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints());
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints());
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints());
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneParser_missingOutputArgument() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output"};
            StandaloneApplication standaloneApplication = new StandaloneApplication();
            ValidateCommand command = this.parseCommand(standaloneApplication, ValidateCommand.class, arguments);
            this.parseInvalidArguments((StandaloneCommand)command, arguments);
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("Missing argument for"));
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("-output"));
            standaloneApplication.stop();
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void testStandaloneParser_missingExporterArgument() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-exporter"};
            StandaloneApplication standaloneApplication = new StandaloneApplication();
            ValidateCommand command = this.parseCommand(standaloneApplication, ValidateCommand.class, arguments);
            this.parseInvalidArguments((StandaloneCommand)command, arguments);
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("Missing argument for"));
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("-exporter"));
            standaloneApplication.stop();
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void testStandaloneParser_missingUsingArgument() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-using"};
            StandaloneApplication standaloneApplication = new StandaloneApplication();
            ValidateCommand command = this.parseCommand(standaloneApplication, ValidateCommand.class, arguments);
            this.parseInvalidArguments((StandaloneCommand)command, arguments);
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("Missing argument for"));
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("-using"));
            standaloneApplication.stop();
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void testStandaloneParser_textExportedFile() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        ValidateCommand command = this.parseCommand(standaloneApplication, ValidateCommand.class, arguments);
        Map<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull StandaloneCommand.CommandToken, @NonNull List<@NonNull String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertTrue((boolean)(command.exporterToken.getExporter() instanceof TextExporter));
        StandaloneParserTests.assertEquals((String)String.valueOf(this.inputModelURI), (String)command.modelToken.getModelFileName());
        StandaloneParserTests.assertEquals((String)this.normalize(this.getTextLogFileName()), (String)this.normalize(command.outputToken.getOutputFile().toString()));
        StandaloneParserTests.assertEquals(this.normalize(Lists.newArrayList((Object[])new String[]{String.valueOf(this.inputOCLURI)})), (Object)Lists.newArrayList((Object[])new String[]{this.normalize((String)command.rulesToken.getOCLFileNames().get(0))}));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints());
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints());
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints());
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneParser_htmlExportedFile() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getHTMLLogFileName(), "-exporter", "html"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        ValidateCommand command = this.parseCommand(standaloneApplication, ValidateCommand.class, arguments);
        Map<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull StandaloneCommand.CommandToken, @NonNull List<@NonNull String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertTrue((boolean)(command.exporterToken.getExporter() instanceof HTMLExporter));
        StandaloneParserTests.assertEquals((String)String.valueOf(this.inputModelURI), (String)command.modelToken.getModelFileName());
        StandaloneParserTests.assertEquals((String)this.normalize(this.getHTMLLogFileName()), (String)this.normalize(command.outputToken.getOutputFile().toString()));
        StandaloneParserTests.assertEquals(this.normalize(Lists.newArrayList((Object[])new String[]{String.valueOf(this.inputOCLURI)})), this.normalize(command.rulesToken.getOCLFileNames()));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints());
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints());
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints());
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneParser_unknownExporter() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "anotherExporterAttribute"};
            StandaloneApplication standaloneApplication = new StandaloneApplication();
            ValidateCommand command = this.parseCommand(standaloneApplication, ValidateCommand.class, arguments);
            this.parseInvalidArguments((StandaloneCommand)command, arguments);
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("Unrecognized 'exporter' anotherExporterAttribute"));
            standaloneApplication.stop();
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void testStandaloneParser_nonExistentModel() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(StandaloneParserTests.getTestModelURI("models/nonExistent.ecore")), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text"};
            StandaloneApplication standaloneApplication = new StandaloneApplication();
            ValidateCommand command = this.parseCommand(standaloneApplication, ValidateCommand.class, arguments);
            Map<// Could not load outer class - annotation placement on inner may be incorrect
            @NonNull StandaloneCommand.CommandToken, @NonNull List<@NonNull String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
            StandaloneParserTests.assertCommandInvalid((StandaloneCommand)command, token2strings);
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("does not exist"));
            standaloneApplication.stop();
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void testStandaloneParser_nonExistentOclFile() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(StandaloneParserTests.getTestModelURI("models/nonExistent.ocl")), "-output", this.getTextLogFileName(), "-exporter", "text"};
            StandaloneApplication standaloneApplication = new StandaloneApplication();
            ValidateCommand command = this.parseCommand(standaloneApplication, ValidateCommand.class, arguments);
            Map<// Could not load outer class - annotation placement on inner may be incorrect
            @NonNull StandaloneCommand.CommandToken, @NonNull List<@NonNull String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
            StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("does not exist"));
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("ignored"));
            standaloneApplication.stop();
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void testStandaloneParser_nonExistentOutputFolder() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", "nonExistentFolder/log.file", "-exporter", "text"};
            StandaloneApplication standaloneApplication = new StandaloneApplication();
            ValidateCommand command = this.parseCommand(standaloneApplication, ValidateCommand.class, arguments);
            Map<// Could not load outer class - annotation placement on inner may be incorrect
            @NonNull StandaloneCommand.CommandToken, @NonNull List<@NonNull String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
            StandaloneParserTests.assertCommandInvalid((StandaloneCommand)command, token2strings);
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("does not exist"));
            standaloneApplication.stop();
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void testStandaloneParser_textOCLFiles() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.textInputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        ValidateCommand command = this.parseCommand(standaloneApplication, ValidateCommand.class, arguments);
        Map<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull StandaloneCommand.CommandToken, @NonNull List<@NonNull String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertTrue((boolean)(command.exporterToken.getExporter() instanceof TextExporter));
        StandaloneParserTests.assertEquals((String)String.valueOf(this.inputModelURI), (String)command.modelToken.getModelFileName());
        StandaloneParserTests.assertEquals((String)this.normalize(this.getTextLogFileName()), (String)this.normalize(command.outputToken.getOutputFile().toString()));
        StandaloneParserTests.assertEquals(this.normalize(Lists.newArrayList((Object[])new String[]{String.valueOf(this.inputOCLURI), String.valueOf(this.inputOCLURI2)})), this.normalize(command.rulesToken.getOCLFileNames()));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints());
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints());
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints());
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneParser_usingAllLocators() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "all"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        ValidateCommand command = this.parseCommand(standaloneApplication, ValidateCommand.class, arguments);
        Map<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull StandaloneCommand.CommandToken, @NonNull List<@NonNull String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints());
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints());
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints());
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneParser_usingOCLLocator() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "ocl"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        ValidateCommand command = this.parseCommand(standaloneApplication, ValidateCommand.class, arguments);
        Map<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull StandaloneCommand.CommandToken, @NonNull List<@NonNull String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunJavaConstraints());
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints());
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunUMLConstraints());
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneParser_usingJavaLocator() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "java"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        ValidateCommand command = this.parseCommand(standaloneApplication, ValidateCommand.class, arguments);
        Map<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull StandaloneCommand.CommandToken, @NonNull List<@NonNull String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints());
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunOCLConstraints());
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunUMLConstraints());
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneParser_usingUMLLocator() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "uml"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        ValidateCommand command = this.parseCommand(standaloneApplication, ValidateCommand.class, arguments);
        Map<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull StandaloneCommand.CommandToken, @NonNull List<@NonNull String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunJavaConstraints());
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunOCLConstraints());
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints());
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneParser_usingOCLUMLLocators() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "ocl,uml"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        ValidateCommand command = this.parseCommand(standaloneApplication, ValidateCommand.class, arguments);
        Map<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull StandaloneCommand.CommandToken, @NonNull List<@NonNull String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunJavaConstraints());
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints());
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints());
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneParser_usingOCLJavaLocators() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "ocl,java"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        ValidateCommand command = this.parseCommand(standaloneApplication, ValidateCommand.class, arguments);
        Map<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull StandaloneCommand.CommandToken, @NonNull List<@NonNull String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints());
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints());
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunUMLConstraints());
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneParser_usingJavaUmlLocators() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "uml,java"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        ValidateCommand command = this.parseCommand(standaloneApplication, ValidateCommand.class, arguments);
        Map<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull StandaloneCommand.CommandToken, @NonNull List<@NonNull String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints());
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunOCLConstraints());
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints());
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneParser_usingOCLJavaUmlLocators() throws Exception {
        AbstractEnvironmentFactory.ENVIRONMENT_FACTORY_ATTACH.setState(true);
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "ocl,uml,java"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        ValidateCommand command = this.parseCommand(standaloneApplication, ValidateCommand.class, arguments);
        Map<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull StandaloneCommand.CommandToken, @NonNull List<@NonNull String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints());
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints());
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints());
        standaloneApplication.stop();
    }
}

