/*
 * Decompiled with CFR 0.152.
 */
package behavioral.actions.util;

import behavioral.actions.ActionsPackage;
import behavioral.actions.AddLink;
import behavioral.actions.Assignment;
import behavioral.actions.Block;
import behavioral.actions.ConditionalStatement;
import behavioral.actions.Constant;
import behavioral.actions.ExpressionStatement;
import behavioral.actions.Foreach;
import behavioral.actions.IfElse;
import behavioral.actions.Iterator;
import behavioral.actions.LinkManipulationStatement;
import behavioral.actions.NamedValueDeclaration;
import behavioral.actions.NamedValueWithOptionalInitExpression;
import behavioral.actions.QueryInvocation;
import behavioral.actions.RemoveLink;
import behavioral.actions.Return;
import behavioral.actions.SingleBlockStatement;
import behavioral.actions.Sort;
import behavioral.actions.Statement;
import behavioral.actions.StatementWithArgument;
import behavioral.actions.StatementWithNestedBlocks;
import behavioral.actions.Variable;
import behavioral.actions.WhileLoop;
import dataaccess.expressions.util.ExpressionsValidator;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class ActionsValidator
extends EObjectValidator {
    public static final ActionsValidator INSTANCE = new ActionsValidator();
    public static final String DIAGNOSTIC_SOURCE = "behavioral.actions";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected ExpressionsValidator expressionsValidator = ExpressionsValidator.INSTANCE;
    protected static final String ASSIGNMENT__ASSIGNMENT_COMPATIBILITY__EEXPRESSION = "self.argument.getType().conformsTo(self.assignTo.getType())";
    protected static final String ASSIGNMENT__MUST_HAVE_ARGUMENT__EEXPRESSION = "self.argument->notEmpty()";
    protected static final String BLOCK__DOES_NOT_OWN_ITERATORS__EEXPRESSION = "self.variables->select(i|i.oclIsKindOf(Iterator))->isEmpty()";
    protected static final String BLOCK__IS_SIDE_EFFECT_FREE_IF_IMPLEMENTS_SIDE_EFFECT_FREE_SIGNATURE__EEXPRESSION = "self.implements_->notEmpty() implies\r\n    (self.implements_.sideEffectFree implies self.isSideEffectFree())";
    protected static final String BLOCK__DISTINCT_NAMED_VALUE_NAMES__EEXPRESSION = "self.variables->forAll( i, j | i <> j implies i.name <> j.name )";
    protected static final String FOREACH__VARIABLE_OWNED_BY_RIGHT_BLOCK__EEXPRESSION = "self.forVariable.owner = self.nestedBlocks->at(1)";
    protected static final String RETURN__RETURN_MUST_BE_LAST_IN_BLOCK__EEXPRESSION = "self = self.block.statements->last()";
    protected static final String RETURN__RETURN_TYPE_MUST_MATCH__EEXPRESSION = "self.argument.getType().conformsTo(self.getOutermostBlock().getImplementedSignature().output)";
    protected static final String LINK_MANIPULATION_STATEMENT__OBJECTS_MUST_CONFORM_TO_END_TYPES__EEXPRESSION = "Sequence{1..self.objects->size()}->forAll(i:Integer |\r\n    objects->at(i).getType().conformsTo(association.ends->at(i).type))";
    protected static final String LINK_MANIPULATION_STATEMENT__BLOCK_MUST_NOT_IMPLEMENT_SIDE_EFFECT_FREE_SIGNATURE__EEXPRESSION = "self.block.getImplementedSignature()->notEmpty() implies\r\n  not self.block.getImplementedSignature().sideEffectFree";
    protected static final String LINK_MANIPULATION_STATEMENT__NO_VALUE_MUST_BE_MODIFIED__EEXPRESSION = "self.association.ends->forAll(ae:data::classes::AssociationEnd |\r\n    ae.type.clazz.valueType implies not ae.contributesToEquality)";
    protected static final String CONSTANT__INIT_EXPRESSION_TYPE_MUST_MATCH_VARIABLE_TYPE__EEXPRESSION = "self.initExpression->notEmpty() implies self.initExpression.getType().conformsTo(self.getType())";
    protected static final String VARIABLE__INIT_EXPRESSION_TYPE_MUST_MATCH_VARIABLE_TYPE__EEXPRESSION = "self.initExpression->notEmpty() implies self.initExpression.getType().conformsTo(self.getType())";
    protected static final String SINGLE_BLOCK_STATEMENT__OWNS_EXACTLY_ONE_BLOCK__EEXPRESSION = "self.nestedBlocks->size() = 1";
    protected static final String NAMED_VALUE_WITH_OPTIONAL_INIT_EXPRESSION__ASSIGNMENT_COMPATIBILITY__EEXPRESSION = "self.initExpression->forAll(ie | ie.getType().conformsTo(self.getType()))";

    protected EPackage getEPackage() {
        return ActionsPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateAssignment((Assignment)value, diagnostics, context);
            }
            case 1: {
                return this.validateStatement((Statement)value, diagnostics, context);
            }
            case 2: {
                return this.validateBlock((Block)value, diagnostics, context);
            }
            case 3: {
                return this.validateIfElse((IfElse)value, diagnostics, context);
            }
            case 4: {
                return this.validateWhileLoop((WhileLoop)value, diagnostics, context);
            }
            case 5: {
                return this.validateForeach((Foreach)value, diagnostics, context);
            }
            case 6: {
                return this.validateReturn((Return)value, diagnostics, context);
            }
            case 7: {
                return this.validateAddLink((AddLink)value, diagnostics, context);
            }
            case 8: {
                return this.validateRemoveLink((RemoveLink)value, diagnostics, context);
            }
            case 9: {
                return this.validateLinkManipulationStatement((LinkManipulationStatement)value, diagnostics, context);
            }
            case 10: {
                return this.validateExpressionStatement((ExpressionStatement)value, diagnostics, context);
            }
            case 11: {
                return this.validateSort((Sort)value, diagnostics, context);
            }
            case 12: {
                return this.validateQueryInvocation((QueryInvocation)value, diagnostics, context);
            }
            case 13: {
                return this.validateConstant((Constant)value, diagnostics, context);
            }
            case 14: {
                return this.validateVariable((Variable)value, diagnostics, context);
            }
            case 15: {
                return this.validateIterator((Iterator)value, diagnostics, context);
            }
            case 16: {
                return this.validateNamedValueDeclaration((NamedValueDeclaration)value, diagnostics, context);
            }
            case 17: {
                return this.validateStatementWithNestedBlocks((StatementWithNestedBlocks)value, diagnostics, context);
            }
            case 18: {
                return this.validateSingleBlockStatement((SingleBlockStatement)value, diagnostics, context);
            }
            case 19: {
                return this.validateStatementWithArgument((StatementWithArgument)value, diagnostics, context);
            }
            case 20: {
                return this.validateNamedValueWithOptionalInitExpression((NamedValueWithOptionalInitExpression)value, diagnostics, context);
            }
            case 21: {
                return this.validateConditionalStatement((ConditionalStatement)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateAssignment(Assignment assignment, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(assignment, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(assignment, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(assignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(assignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(assignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(assignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(assignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(assignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(assignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssignment_AssignmentCompatibility(assignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssignment_MustHaveArgument(assignment, diagnostics, context);
        }
        return result;
    }

    public boolean validateAssignment_AssignmentCompatibility(Assignment assignment, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ActionsPackage.Literals.ASSIGNMENT, assignment, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "AssignmentCompatibility", ASSIGNMENT__ASSIGNMENT_COMPATIBILITY__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAssignment_MustHaveArgument(Assignment assignment, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ActionsPackage.Literals.ASSIGNMENT, assignment, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "MustHaveArgument", ASSIGNMENT__MUST_HAVE_ARGUMENT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateStatement(Statement statement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(statement, diagnostics, context);
    }

    public boolean validateBlock(Block block, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(block, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(block, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBlock_DoesNotOwnIterators(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBlock_IsSideEffectFreeIfImplementsSideEffectFreeSignature(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBlock_DistinctNamedValueNames(block, diagnostics, context);
        }
        return result;
    }

    public boolean validateBlock_DoesNotOwnIterators(Block block, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ActionsPackage.Literals.BLOCK, block, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "DoesNotOwnIterators", BLOCK__DOES_NOT_OWN_ITERATORS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateBlock_IsSideEffectFreeIfImplementsSideEffectFreeSignature(Block block, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ActionsPackage.Literals.BLOCK, block, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "IsSideEffectFreeIfImplementsSideEffectFreeSignature", BLOCK__IS_SIDE_EFFECT_FREE_IF_IMPLEMENTS_SIDE_EFFECT_FREE_SIGNATURE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateBlock_DistinctNamedValueNames(Block block, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ActionsPackage.Literals.BLOCK, block, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "DistinctNamedValueNames", BLOCK__DISTINCT_NAMED_VALUE_NAMES__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateIfElse(IfElse ifElse, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(ifElse, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(ifElse, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(ifElse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(ifElse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(ifElse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(ifElse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(ifElse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(ifElse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(ifElse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.expressionsValidator.validateConditional_ConditionMustBeBoolean(ifElse, diagnostics, context);
        }
        return result;
    }

    public boolean validateWhileLoop(WhileLoop whileLoop, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(whileLoop, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(whileLoop, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(whileLoop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(whileLoop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(whileLoop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(whileLoop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(whileLoop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(whileLoop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(whileLoop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.expressionsValidator.validateConditional_ConditionMustBeBoolean(whileLoop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSingleBlockStatement_OwnsExactlyOneBlock(whileLoop, diagnostics, context);
        }
        return result;
    }

    public boolean validateForeach(Foreach foreach, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(foreach, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(foreach, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(foreach, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(foreach, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(foreach, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(foreach, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(foreach, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(foreach, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(foreach, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSingleBlockStatement_OwnsExactlyOneBlock(foreach, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateForeach_VariableOwnedByRightBlock(foreach, diagnostics, context);
        }
        return result;
    }

    public boolean validateForeach_VariableOwnedByRightBlock(Foreach foreach, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ActionsPackage.Literals.FOREACH, foreach, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "VariableOwnedByRightBlock", FOREACH__VARIABLE_OWNED_BY_RIGHT_BLOCK__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateReturn(Return return_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(return_, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(return_, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(return_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(return_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(return_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(return_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(return_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(return_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(return_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateReturn_ReturnMustBeLastInBlock(return_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateReturn_ReturnTypeMustMatch(return_, diagnostics, context);
        }
        return result;
    }

    public boolean validateReturn_ReturnMustBeLastInBlock(Return return_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ActionsPackage.Literals.RETURN, return_, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ReturnMustBeLastInBlock", RETURN__RETURN_MUST_BE_LAST_IN_BLOCK__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateReturn_ReturnTypeMustMatch(Return return_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ActionsPackage.Literals.RETURN, return_, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ReturnTypeMustMatch", RETURN__RETURN_TYPE_MUST_MATCH__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAddLink(AddLink addLink, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(addLink, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(addLink, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(addLink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(addLink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(addLink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(addLink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(addLink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(addLink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(addLink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLinkManipulationStatement_ObjectsMustConformToEndTypes(addLink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLinkManipulationStatement_BlockMustNotImplementSideEffectFreeSignature(addLink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLinkManipulationStatement_NoValueMustBeModified(addLink, diagnostics, context);
        }
        return result;
    }

    public boolean validateRemoveLink(RemoveLink removeLink, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(removeLink, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(removeLink, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(removeLink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(removeLink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(removeLink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(removeLink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(removeLink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(removeLink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(removeLink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLinkManipulationStatement_ObjectsMustConformToEndTypes(removeLink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLinkManipulationStatement_BlockMustNotImplementSideEffectFreeSignature(removeLink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLinkManipulationStatement_NoValueMustBeModified(removeLink, diagnostics, context);
        }
        return result;
    }

    public boolean validateLinkManipulationStatement(LinkManipulationStatement linkManipulationStatement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(linkManipulationStatement, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(linkManipulationStatement, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(linkManipulationStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(linkManipulationStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(linkManipulationStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(linkManipulationStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(linkManipulationStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(linkManipulationStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(linkManipulationStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLinkManipulationStatement_ObjectsMustConformToEndTypes(linkManipulationStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLinkManipulationStatement_BlockMustNotImplementSideEffectFreeSignature(linkManipulationStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLinkManipulationStatement_NoValueMustBeModified(linkManipulationStatement, diagnostics, context);
        }
        return result;
    }

    public boolean validateLinkManipulationStatement_ObjectsMustConformToEndTypes(LinkManipulationStatement linkManipulationStatement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ActionsPackage.Literals.LINK_MANIPULATION_STATEMENT, linkManipulationStatement, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ObjectsMustConformToEndTypes", LINK_MANIPULATION_STATEMENT__OBJECTS_MUST_CONFORM_TO_END_TYPES__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateLinkManipulationStatement_BlockMustNotImplementSideEffectFreeSignature(LinkManipulationStatement linkManipulationStatement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ActionsPackage.Literals.LINK_MANIPULATION_STATEMENT, linkManipulationStatement, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "BlockMustNotImplementSideEffectFreeSignature", LINK_MANIPULATION_STATEMENT__BLOCK_MUST_NOT_IMPLEMENT_SIDE_EFFECT_FREE_SIGNATURE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateLinkManipulationStatement_NoValueMustBeModified(LinkManipulationStatement linkManipulationStatement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ActionsPackage.Literals.LINK_MANIPULATION_STATEMENT, linkManipulationStatement, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "NoValueMustBeModified", LINK_MANIPULATION_STATEMENT__NO_VALUE_MUST_BE_MODIFIED__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateExpressionStatement(ExpressionStatement expressionStatement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(expressionStatement, diagnostics, context);
    }

    public boolean validateSort(Sort sort, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(sort, diagnostics, context);
    }

    public boolean validateQueryInvocation(QueryInvocation queryInvocation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(queryInvocation, diagnostics, context);
    }

    public boolean validateConstant(Constant constant, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(constant, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(constant, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(constant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(constant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(constant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(constant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(constant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(constant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(constant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedValueWithOptionalInitExpression_AssignmentCompatibility(constant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateConstant_InitExpressionTypeMustMatchVariableType(constant, diagnostics, context);
        }
        return result;
    }

    public boolean validateConstant_InitExpressionTypeMustMatchVariableType(Constant constant, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ActionsPackage.Literals.CONSTANT, constant, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "InitExpressionTypeMustMatchVariableType", "self.initExpression->notEmpty() implies self.initExpression.getType().conformsTo(self.getType())", 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateVariable(Variable variable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(variable, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(variable, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(variable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(variable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(variable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(variable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(variable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(variable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(variable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedValueWithOptionalInitExpression_AssignmentCompatibility(variable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateVariable_InitExpressionTypeMustMatchVariableType(variable, diagnostics, context);
        }
        return result;
    }

    public boolean validateVariable_InitExpressionTypeMustMatchVariableType(Variable variable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ActionsPackage.Literals.VARIABLE, variable, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "InitExpressionTypeMustMatchVariableType", "self.initExpression->notEmpty() implies self.initExpression.getType().conformsTo(self.getType())", 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateIterator(Iterator iterator, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(iterator, diagnostics, context);
    }

    public boolean validateNamedValueDeclaration(NamedValueDeclaration namedValueDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(namedValueDeclaration, diagnostics, context);
    }

    public boolean validateStatementWithNestedBlocks(StatementWithNestedBlocks statementWithNestedBlocks, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(statementWithNestedBlocks, diagnostics, context);
    }

    public boolean validateSingleBlockStatement(SingleBlockStatement singleBlockStatement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(singleBlockStatement, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(singleBlockStatement, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(singleBlockStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(singleBlockStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(singleBlockStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(singleBlockStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(singleBlockStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(singleBlockStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(singleBlockStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSingleBlockStatement_OwnsExactlyOneBlock(singleBlockStatement, diagnostics, context);
        }
        return result;
    }

    public boolean validateSingleBlockStatement_OwnsExactlyOneBlock(SingleBlockStatement singleBlockStatement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ActionsPackage.Literals.SINGLE_BLOCK_STATEMENT, singleBlockStatement, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "OwnsExactlyOneBlock", SINGLE_BLOCK_STATEMENT__OWNS_EXACTLY_ONE_BLOCK__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateStatementWithArgument(StatementWithArgument statementWithArgument, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(statementWithArgument, diagnostics, context);
    }

    public boolean validateNamedValueWithOptionalInitExpression(NamedValueWithOptionalInitExpression namedValueWithOptionalInitExpression, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(namedValueWithOptionalInitExpression, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(namedValueWithOptionalInitExpression, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(namedValueWithOptionalInitExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(namedValueWithOptionalInitExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(namedValueWithOptionalInitExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(namedValueWithOptionalInitExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(namedValueWithOptionalInitExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(namedValueWithOptionalInitExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(namedValueWithOptionalInitExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedValueWithOptionalInitExpression_AssignmentCompatibility(namedValueWithOptionalInitExpression, diagnostics, context);
        }
        return result;
    }

    public boolean validateNamedValueWithOptionalInitExpression_AssignmentCompatibility(NamedValueWithOptionalInitExpression namedValueWithOptionalInitExpression, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ActionsPackage.Literals.NAMED_VALUE_WITH_OPTIONAL_INIT_EXPRESSION, namedValueWithOptionalInitExpression, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "AssignmentCompatibility", NAMED_VALUE_WITH_OPTIONAL_INIT_EXPRESSION__ASSIGNMENT_COMPATIBILITY__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateConditionalStatement(ConditionalStatement conditionalStatement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(conditionalStatement, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(conditionalStatement, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(conditionalStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(conditionalStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(conditionalStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(conditionalStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(conditionalStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(conditionalStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(conditionalStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.expressionsValidator.validateConditional_ConditionMustBeBoolean(conditionalStatement, diagnostics, context);
        }
        return result;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

