/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.tests;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.tests.GenericEvaluationTestSuite;

public abstract class GenericEvaluationOclAnyOperationTest<E extends EObject, PK extends E, T extends E, C extends T, CLS extends C, DT extends C, PT extends C, ET extends DT, O extends E, PM extends E, P extends E, PA extends P, PR extends P, EL, S, COA, SSA, CT>
extends GenericEvaluationTestSuite<E, PK, T, C, CLS, DT, PT, ET, O, PM, P, PA, PR, EL, S, COA, SSA, CT> {
    public void test_oclAsSet_explicit() {
        this.assertExpressionResults("Set{true}", "true.oclAsSet()");
        this.assertExpressionResults("Set{}", "null.oclAsSet()");
        this.assertQueryInvalid(null, "invalid.oclAsSet()");
        this.assertExpressionResults("Set{Set{1..4}}", "Set{1..4}->oclAsSet()");
    }

    public void test_oclAsSet_implicit() {
        this.assertExpressionResults("Set{true}", "true->select(true)");
        this.assertExpressionResults("Set{true}", "Set{true}->select(true)");
        this.assertExpressionResults("Set{}", "null->select(true)");
        this.assertExpressionResults("Set{}", "Set{}->select(true)");
        this.assertExpressionResults("Set{null}", "Set{null}->select(true)");
        this.assertQueryInvalid(null, "invalid->select(true)");
        this.assertExpressionResults("false", "true.oclIsUndefined()");
        this.assertExpressionResults("false", "true->oclIsUndefined()");
        this.assertExpressionResults("true", "null.oclIsUndefined()");
        this.assertExpressionResults("false", "null->oclIsUndefined()");
        this.assertExpressionResults("true", "invalid.oclIsUndefined()");
        this.assertExpressionResults("true", "invalid->oclIsUndefined()");
        this.assertResult(4, "'1234'.size()");
        this.assertResult(1, "'1234'->size()");
    }

    public void testEqualInvalid() {
        this.assertResultInvalid("invalid = 3");
        this.assertResultInvalid("3 = invalid");
        this.assertResultInvalid("invalid = 3.0");
        this.assertResultInvalid("3.0 = invalid");
        this.assertResultInvalid("invalid = 'test'");
        this.assertResultInvalid("'test' = invalid");
        this.assertResultInvalid("invalid = true");
        this.assertResultInvalid("false = invalid");
        this.assertResultInvalid("invalid = Sequence{}");
        this.assertResultInvalid("Sequence{} = invalid");
        this.assertResultInvalid("invalid = invalid");
    }

    public void testEqualNull() {
        this.assertResultFalse("null = 3");
        this.assertResultFalse("3 = null");
        this.assertResultFalse("null = 3.0");
        this.assertResultFalse("3.0 = null");
        this.assertResultFalse("null = 'test'");
        this.assertResultFalse("'test' = null");
        this.assertResultFalse("null = true");
        this.assertResultFalse("false = null");
        this.assertResultFalse("null = Sequence{}");
        this.assertResultFalse("Sequence{} = null");
        this.assertResultTrue("null = null");
    }

    public void testGreaterThanInvalid() {
        this.assertResultInvalid("invalid > 0");
        this.assertResultInvalid("0 > invalid");
        this.assertResultInvalid("invalid > invalid");
    }

    public void testGreaterThanNull() {
        this.assertResultInvalid("null > 0");
        this.assertResultInvalid("0 > null");
        this.assertResultInvalid("null > null");
    }

    public void testGreaterThanOrEqualInvalid() {
        this.assertResultInvalid("invalid >= 0");
        this.assertResultInvalid("0 >= invalid");
        this.assertResultInvalid("invalid >= invalid");
    }

    public void testGreaterThanOrEqualNull() {
        this.assertResultInvalid("null >= 0");
        this.assertResultInvalid("0 >= null");
        this.assertResultInvalid("null >= null");
    }

    public void testLessThanInvalid() {
        this.assertResultInvalid("invalid < 0");
        this.assertResultInvalid("0 < invalid");
        this.assertResultInvalid("invalid < invalid");
    }

    public void testLessThanNull() {
        this.assertResultInvalid("null < 0");
        this.assertResultInvalid("0 < null");
        this.assertResultInvalid("null < null");
    }

    public void testLessThanOrEqualInvalid() {
        this.assertResultInvalid("invalid <= 0");
        this.assertResultInvalid("0 <= invalid");
        this.assertResultInvalid("invalid <= invalid");
    }

    public void testLessThanOrEqualNull() {
        this.assertResultInvalid("null <= 0");
        this.assertResultInvalid("0 <= null");
        this.assertResultInvalid("null <= null");
    }

    public void testNotEqualInvalid() {
        this.assertResultInvalid("invalid <> 3");
        this.assertResultInvalid("3 <> invalid");
        this.assertResultInvalid("invalid <> 3.0");
        this.assertResultInvalid("3.0 <> invalid");
        this.assertResultInvalid("invalid <> 'test'");
        this.assertResultInvalid("'test' <> invalid");
        this.assertResultInvalid("invalid <> true");
        this.assertResultInvalid("false <> invalid");
        this.assertResultInvalid("invalid <> Sequence{}");
        this.assertResultInvalid("Sequence{} <> invalid");
        this.assertResultInvalid("invalid <> invalid");
    }

    public void testNotEqualNull() {
        this.assertResultTrue("null <> 3");
        this.assertResultTrue("3 <> null");
        this.assertResultTrue("null <> 3.0");
        this.assertResultTrue("3.0 <> null");
        this.assertResultTrue("null <> 'test'");
        this.assertResultTrue("'test' <> null");
        this.assertResultTrue("null <> true");
        this.assertResultTrue("false <> null");
        this.assertResultTrue("null <> Sequence{}");
        this.assertResultTrue("Sequence{} <> null");
        this.assertResultFalse("null <> null");
    }

    public void testOclIsInvalidInvalid() {
        this.assertResultTrue("invalid.oclIsInvalid()");
    }

    public void testOclIsInvalidNull() {
        this.assertResultFalse("null.oclIsInvalid()");
    }

    public void testOclIsTypeOfOclAny() {
        this.assertResultFalse("null.oclIsTypeOf(OclAny)");
        this.assertResultFalse("'abc'.oclIsTypeOf(OclAny)");
        this.assertResultFalse("invalid.oclIsTypeOf(OclAny)");
    }

    public void testOclIsUndefinedInvalid() {
        this.assertResultTrue("invalid.oclIsUndefined()");
    }

    public void testOclIsUndefinedNull() {
        this.assertResultTrue("null.oclIsUndefined()");
    }
}

