/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.Customizable;
import org.eclipse.ocl.options.EvaluationOptions;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.options.ProblemOption;
import org.eclipse.ocl.uml.OCL;
import org.eclipse.ocl.uml.OCLExpression;
import org.eclipse.ocl.uml.UMLEnvironment;
import org.eclipse.ocl.uml.UMLEnvironmentFactory;
import org.eclipse.ocl.uml.UMLEvaluationEnvironment;
import org.eclipse.ocl.uml.options.EvaluationMode;
import org.eclipse.ocl.uml.options.UMLEvaluationOptions;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.SendSignalAction;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLEnvironmentTest
extends AbstractTestSuite {
    public void test_extensibility_156360() {
        OCL ocl = OCL.newInstance((EnvironmentFactory)new MyEnvironmentFactory());
        OCL.Helper helper = ocl.createOCLHelper();
        helper.setContext((Object)((Classifier)this.getUMLString()));
        Constraint constraint = null;
        try {
            constraint = (Constraint)helper.createInvariant("self.regexMatch('\\\\d{3}-\\\\d{3}-\\\\d{3}') <> null");
        }
        catch (Exception e) {
            UMLEnvironmentTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        UMLEnvironmentTest.assertTrue((boolean)ocl.check((Object)"123-456-789", (Object)constraint));
        UMLEnvironmentTest.assertFalse((boolean)ocl.check((Object)"123-4567-890", (Object)constraint));
        UMLEnvironmentTest.assertFalse((boolean)ocl.check((Object)"123-abc-456", (Object)constraint));
    }

    public void test_evaluationMode_instanceModel_194390() {
        this.expectModified = true;
        UMLEnvironmentFactory factory = new UMLEnvironmentFactory(resourceSet);
        OCL ocl = OCL.newInstance((EnvironmentFactory)factory);
        EvaluationOptions.setOption((EvaluationEnvironment)ocl.getEvaluationEnvironment(), (Option)UMLEvaluationOptions.EVALUATION_MODE, (Object)EvaluationMode.INSTANCE_MODEL);
        OCL.Helper helper = ocl.createOCLHelper();
        helper.setContext((Object)((Classifier)this.getMetaclass("Element")));
        Constraint constraint = null;
        try {
            constraint = (Constraint)helper.createInvariant("self.oclIsKindOf(InstanceSpecification)");
        }
        catch (Exception e) {
            UMLEnvironmentTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        InstanceSpecification instance1 = (InstanceSpecification)((Package)this.fruitPackage).createPackagedElement(null, UMLPackage.Literals.INSTANCE_SPECIFICATION);
        instance1.getClassifiers().add((Object)this.apple);
        try {
            UMLEnvironmentTest.assertFalse((boolean)ocl.check((Object)instance1, (Object)constraint));
            instance1.getClassifiers().add((Object)((Classifier)this.getMetaclass("InstanceSpecification")));
            UMLEnvironmentTest.assertTrue((boolean)ocl.check((Object)instance1, (Object)constraint));
        }
        finally {
            instance1.destroy();
        }
    }

    public void test_evaluationMode_runtimeObjects_194390() {
        this.expectModified = true;
        UMLEnvironmentFactory factory = new UMLEnvironmentFactory(resourceSet);
        OCL ocl = OCL.newInstance((EnvironmentFactory)factory);
        EvaluationOptions.setOption((EvaluationEnvironment)ocl.getEvaluationEnvironment(), (Option)UMLEvaluationOptions.EVALUATION_MODE, (Object)EvaluationMode.RUNTIME_OBJECTS);
        OCL.Helper helper = ocl.createOCLHelper();
        helper.setContext((Object)((Classifier)this.getMetaclass("Element")));
        Constraint constraint1 = null;
        Constraint constraint2 = null;
        try {
            constraint1 = (Constraint)helper.createInvariant("self.oclIsKindOf(InstanceSpecification)");
            constraint2 = (Constraint)helper.createInvariant("self.oclIsKindOf(ocltest::Apple)");
        }
        catch (Exception e) {
            UMLEnvironmentTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        InstanceSpecification instance1 = (InstanceSpecification)((Package)this.fruitPackage).createPackagedElement(null, UMLPackage.Literals.INSTANCE_SPECIFICATION);
        instance1.getClassifiers().add((Object)this.apple);
        try {
            UMLEnvironmentTest.assertTrue((boolean)ocl.check((Object)instance1, (Object)constraint1));
            UMLEnvironmentTest.assertFalse((boolean)ocl.check((Object)instance1, (Object)constraint2));
        }
        finally {
            instance1.destroy();
        }
    }

    public void test_evaluationMode_adaptive_194390() {
        this.expectModified = true;
        UMLEnvironmentFactory factory = new UMLEnvironmentFactory(resourceSet);
        OCL ocl = OCL.newInstance((EnvironmentFactory)factory);
        EvaluationOptions.setOption((EvaluationEnvironment)ocl.getEvaluationEnvironment(), (Option)UMLEvaluationOptions.EVALUATION_MODE, (Object)EvaluationMode.ADAPTIVE);
        OCL.Helper helper = ocl.createOCLHelper();
        helper.setContext((Object)((Classifier)this.getMetaclass("Element")));
        Constraint constraint = null;
        Constraint ownerConstraint = null;
        try {
            constraint = (Constraint)helper.createInvariant("self.oclIsKindOf(InstanceSpecification)");
            ownerConstraint = (Constraint)helper.createInvariant("self.owner.oclIsKindOf(InstanceSpecification)");
        }
        catch (Exception e) {
            UMLEnvironmentTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        InstanceSpecification instance1 = (InstanceSpecification)((Package)this.fruitPackage).createPackagedElement(null, UMLPackage.Literals.INSTANCE_SPECIFICATION);
        instance1.getClassifiers().add((Object)this.apple);
        Comment comment = instance1.createOwnedComment();
        InstanceSpecification instance2 = (InstanceSpecification)((Package)this.fruitPackage).createPackagedElement(null, UMLPackage.Literals.INSTANCE_SPECIFICATION);
        instance2.getClassifiers().add((Object)((Classifier)this.getMetaclass("InstanceSpecification")));
        try {
            UMLEnvironmentTest.assertTrue((boolean)ocl.check((Object)instance2, (Object)constraint));
            UMLEnvironmentTest.assertTrue((boolean)ocl.check((Object)comment, (Object)ownerConstraint));
            UMLEnvironmentTest.assertFalse((boolean)ocl.check((Object)instance1, (Object)constraint));
        }
        finally {
            instance2.destroy();
            comment.destroy();
            instance1.destroy();
        }
    }

    public void test_optionInheritance() {
        Environment parent = this.ocl.getEnvironment();
        ParsingOptions.setOption((Environment)parent, (Option)ProblemOption.CLOSURE_ITERATOR, (Object)ProblemHandler.Severity.INFO);
        Map parentOptions = ((Customizable)OCLUtil.getAdapter((Environment)parent, Customizable.class)).getOptions();
        UMLEnvironmentTest.assertSame((Object)ProblemHandler.Severity.INFO, parentOptions.get(ProblemOption.CLOSURE_ITERATOR));
        Environment child = parent.getFactory().createEnvironment(parent);
        Map childOptions = ((Customizable)OCLUtil.getAdapter((Environment)child, Customizable.class)).getOptions();
        UMLEnvironmentTest.assertSame((Object)ProblemHandler.Severity.INFO, parentOptions.get(ProblemOption.CLOSURE_ITERATOR));
        UMLEnvironmentTest.assertEquals((Object)parentOptions, (Object)childOptions);
        UMLEnvironmentTest.assertNotSame((Object)parentOptions, (Object)childOptions);
        ParsingOptions.setOption((Environment)child, (Option)ProblemOption.CLOSURE_ITERATOR, (Object)ProblemHandler.Severity.ERROR);
        childOptions = ((Customizable)OCLUtil.getAdapter((Environment)child, Customizable.class)).getOptions();
        UMLEnvironmentTest.assertFalse((boolean)parentOptions.equals(childOptions));
        UMLEnvironmentTest.assertSame((Object)ProblemHandler.Severity.ERROR, childOptions.get(ProblemOption.CLOSURE_ITERATOR));
    }

    public void test_linkNavigationInReverse_259630() {
        UMLEnvironmentFactory factory = new UMLEnvironmentFactory(resourceSet);
        OCL ocl = OCL.newInstance((EnvironmentFactory)factory);
        EvaluationOptions.setOption((EvaluationEnvironment)ocl.getEvaluationEnvironment(), (Option)UMLEvaluationOptions.EVALUATION_MODE, (Object)EvaluationMode.INSTANCE_MODEL);
        URI uri = this.getTestModelURI("/model/instances.uml");
        Resource res = resourceSet.getResource(uri, true);
        Package instancesPkg = (Package)EcoreUtil.getObjectByType((Collection)res.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        Class classA = (Class)instancesPkg.getOwnedType("A");
        Class classB = (Class)instancesPkg.getOwnedType("B");
        InstanceSpecification anA = (InstanceSpecification)instancesPkg.getPackagedElement("anA");
        InstanceSpecification anotherA = (InstanceSpecification)instancesPkg.getPackagedElement("anotherA");
        InstanceSpecification aB = (InstanceSpecification)instancesPkg.getPackagedElement("aB");
        OCL.Helper helper = ocl.createOCLHelper();
        helper.setContext((Object)classA);
        OCLExpression query = null;
        try {
            query = helper.createQuery("self.b");
        }
        catch (Exception e) {
            UMLEnvironmentTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        Object result = ocl.evaluate((Object)anA, (org.eclipse.ocl.expressions.OCLExpression)query);
        UMLEnvironmentTest.assertEquals((String)"Wrong result in forward direction", Collections.singleton(aB), (Object)result);
        helper.setContext((Object)classB);
        try {
            query = helper.createQuery("self.a");
        }
        catch (Exception e) {
            UMLEnvironmentTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        result = ocl.evaluate((Object)aB, (org.eclipse.ocl.expressions.OCLExpression)query);
        UMLEnvironmentTest.assertTrue((boolean)(result instanceof Collection));
        Collection collection = (Collection)result;
        UMLEnvironmentTest.assertEquals((String)"Wrong number of results", (int)2, (int)collection.size());
        UMLEnvironmentTest.assertTrue((String)"anA not in the results", (boolean)collection.contains(anA));
        UMLEnvironmentTest.assertTrue((String)"anotherA not in the results", (boolean)collection.contains(anotherA));
    }

    class MyEnvironment
    extends UMLEnvironment {
        Operation regexMatch;

        MyEnvironment(EPackage.Registry registry, ResourceSet rset) {
            super(registry, rset);
            this.defineCustomOperations();
        }

        MyEnvironment(MyEnvironment parent) {
            super((Environment)parent);
            this.regexMatch = parent.regexMatch;
        }

        protected void setFactory(EnvironmentFactory<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> factory) {
            super.setFactory(factory);
        }

        private void defineCustomOperations() {
            this.regexMatch = UMLFactory.eINSTANCE.createOperation();
            this.regexMatch.setName("regexMatch");
            this.regexMatch.setType((Type)this.getOCLStandardLibrary().getString());
            this.regexMatch.createOwnedParameter("pattern", (Type)this.getOCLStandardLibrary().getString());
            this.regexMatch.setIsQuery(true);
            this.regexMatch.addKeyword("MyEnvironment");
            this.addHelperOperation((Classifier)this.getOCLStandardLibrary().getString(), this.regexMatch);
        }
    }

    class MyEnvironmentFactory
    extends UMLEnvironmentFactory {
        MyEnvironmentFactory() {
        }

        public MyEnvironment createEnvironment() {
            MyEnvironment result = new MyEnvironment(this.getEPackageRegistry(), this.getResourceSet());
            result.setFactory((EnvironmentFactory<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject>)this);
            return result;
        }

        public Environment<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> createEnvironment(Environment<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> parent) {
            if (!(parent instanceof MyEnvironment)) {
                throw new IllegalArgumentException("Parent environment must be my environment: " + parent);
            }
            MyEnvironment result = new MyEnvironment((MyEnvironment)parent);
            result.setFactory((EnvironmentFactory<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject>)this);
            return result;
        }

        public EvaluationEnvironment<Classifier, Operation, Property, Class, EObject> createEvaluationEnvironment() {
            return new MyEvaluationEnvironment(this);
        }

        public EvaluationEnvironment<Classifier, Operation, Property, Class, EObject> createEvaluationEnvironment(EvaluationEnvironment<Classifier, Operation, Property, Class, EObject> parent) {
            return new MyEvaluationEnvironment(parent);
        }
    }

    class MyEvaluationEnvironment
    extends UMLEvaluationEnvironment {
        MyEvaluationEnvironment(UMLEnvironmentFactory factory) {
            super(factory);
        }

        MyEvaluationEnvironment(EvaluationEnvironment<Classifier, Operation, Property, Class, EObject> parent) {
            super(parent);
        }

        public Object callOperation(Operation operation, int opcode, Object source, Object[] args) {
            if (!operation.getKeywords().contains((Object)"MyEnvironment")) {
                return super.callOperation(operation, opcode, source, args);
            }
            if ("regexMatch".equals(operation.getName())) {
                Pattern pattern = Pattern.compile((String)args[0]);
                Matcher matcher = pattern.matcher((String)source);
                return matcher.matches() ? matcher.group() : null;
            }
            throw new UnsupportedOperationException();
        }
    }
}

