/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationHaltedException;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.EvaluationVisitorDecorator;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.uml.OCL;
import org.eclipse.ocl.uml.UMLEnvironment;
import org.eclipse.ocl.uml.UMLEnvironmentFactory;
import org.eclipse.ocl.uml.UMLEvaluationEnvironment;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.SendSignalAction;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class EvaluationHaltedTest
extends AbstractTestSuite {
    OCLExpression<Classifier> queryExp;
    OCL.Query query;
    InterruptibleEnvFactory envFactory = new InterruptibleEnvFactory();
    static final String HALT_OPERATION_NAME = "halt";
    static final String HALT_KIND_BASIC = "basic";
    static final String HALT_KIND_ON_ERROR = "error";
    static final String HALT_KIND_CUSTOM = "custom";
    static final String HALT_KIND_NONE = "none";
    static final String OCL_CATCHED_EXC = "ocl.catch";
    static final Diagnostic CUSTOM_DIAGNOSTIC_INSTANCE = new BasicDiagnostic("custom", 0, "custom", null);
    private boolean exceptionThrown = false;

    public OCL createOCL() {
        return OCL.newInstance((EnvironmentFactory)this.envFactory);
    }

    protected void setUp() {
        this.envFactory = new InterruptibleEnvFactory();
        super.setUp();
        this.helper.setContext((Object)((Classifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString()));
        try {
            this.queryExp = this.helper.createQuery("Sequence { self }->collect(i | i.halt(self))");
            EvaluationHaltedTest.assertNull((Object)this.helper.getProblems());
        }
        catch (Exception e) {
            EvaluationHaltedTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        this.query = (OCL.Query)this.ocl.createQuery(this.queryExp);
    }

    public void testBasicEvaluationHalted() {
        EvaluationHaltedTest.assertNull((Object)this.ocl.getEvaluationProblems());
        Object result = this.ocl.evaluate((Object)HALT_KIND_BASIC, this.queryExp);
        this.assertInvalid(result);
        Diagnostic evaluationProblems = this.ocl.getEvaluationProblems();
        EvaluationHaltedTest.assertNotNull((Object)evaluationProblems);
        EvaluationHaltedTest.assertNull((Object)evaluationProblems.getException());
        EvaluationHaltedTest.assertEquals((String)evaluationProblems.getMessage(), (String)HALT_KIND_BASIC);
        this.ocl.evaluate((Object)HALT_KIND_NONE, this.queryExp);
        EvaluationHaltedTest.assertNull((Object)this.ocl.getProblems());
    }

    public void testEvaluationHaltedOnError() {
        EvaluationHaltedTest.assertNull((Object)this.ocl.getEvaluationProblems());
        Object result = this.ocl.evaluate((Object)HALT_KIND_ON_ERROR, this.queryExp);
        this.assertInvalid(result);
        Diagnostic evaluationProblems = this.ocl.getEvaluationProblems();
        EvaluationHaltedTest.assertNotNull((Object)evaluationProblems);
        Throwable exception = evaluationProblems.getException();
        EvaluationHaltedTest.assertTrue((boolean)(exception instanceof TestCauseException));
        EvaluationHaltedTest.assertEquals((String)evaluationProblems.getMessage(), (String)HALT_KIND_ON_ERROR);
        this.ocl.evaluate((Object)HALT_KIND_NONE, this.queryExp);
        EvaluationHaltedTest.assertNull((Object)this.ocl.getProblems());
    }

    public void testEvaluationHaltedWithCustomDiagnostic() {
        EvaluationHaltedTest.assertNull((Object)this.ocl.getEvaluationProblems());
        Object result = this.ocl.evaluate((Object)HALT_KIND_CUSTOM, this.queryExp);
        this.assertInvalid(result);
        Diagnostic evaluationProblems = this.ocl.getEvaluationProblems();
        EvaluationHaltedTest.assertSame((Object)CUSTOM_DIAGNOSTIC_INSTANCE, (Object)evaluationProblems);
        EvaluationHaltedTest.assertNull((Object)evaluationProblems.getException());
        EvaluationHaltedTest.assertEquals((String)evaluationProblems.getMessage(), (String)CUSTOM_DIAGNOSTIC_INSTANCE.getMessage());
        this.ocl.evaluate((Object)HALT_KIND_NONE, this.queryExp);
        EvaluationHaltedTest.assertNull((Object)this.ocl.getProblems());
    }

    public void testOCLCaughtExcConvertedToInvalid() {
        EvaluationHaltedTest.assertNull((Object)this.ocl.getEvaluationProblems());
        this.assertInvalid(this.ocl.evaluate((Object)HALT_KIND_BASIC, this.queryExp));
        EvaluationHaltedTest.assertNotNull((Object)this.ocl.getEvaluationProblems());
        EvaluationHaltedTest.assertFalse((boolean)this.exceptionThrown);
        Object result = this.ocl.evaluate((Object)OCL_CATCHED_EXC, this.queryExp);
        this.assertInvalid(result);
        EvaluationHaltedTest.assertTrue((boolean)this.exceptionThrown);
        EvaluationHaltedTest.assertNull((Object)this.ocl.getEvaluationProblems());
    }

    public void testHaltedQuery() {
        EvaluationHaltedTest.assertNull((Object)OCLUtil.getEvaluationProblems((Query)this.query));
        EvaluationHaltedTest.assertListResult(this.query.evaluate((Object)HALT_KIND_NONE), Collections.singletonList(HALT_KIND_NONE));
        EvaluationHaltedTest.assertNull((Object)OCLUtil.getEvaluationProblems((Query)this.query));
        this.envFactory.haltOnContextLessExecution = true;
        this.assertInvalid(this.query.evaluate((Object)HALT_KIND_NONE));
        EvaluationHaltedTest.assertNotNull((Object)OCLUtil.getEvaluationProblems((Query)this.query));
        EvaluationHaltedTest.assertNotNull((Object)OCLUtil.getEvaluationProblems((Query)this.query).getMessage().equals("Halt"));
        this.envFactory.haltOnContextLessExecution = false;
        this.query.evaluate((Object)HALT_KIND_NONE);
        EvaluationHaltedTest.assertNull((Object)OCLUtil.getEvaluationProblems((Query)this.query));
    }

    public void testEvaluateListHaltedQuery() {
        EvaluationHaltedTest.assertNull((Object)OCLUtil.getEvaluationProblems((Query)this.query));
        List listResult = this.query.evaluate(Arrays.asList(HALT_KIND_BASIC, HALT_KIND_NONE, HALT_KIND_CUSTOM));
        EvaluationHaltedTest.assertEquals((int)3, (int)listResult.size());
        this.assertInvalid(listResult.get(0));
        EvaluationHaltedTest.assertListResult(listResult.get(1), Collections.singletonList(HALT_KIND_NONE));
        this.assertInvalid(listResult.get(2));
        Diagnostic batchProblems = OCLUtil.getEvaluationProblems((Query)this.query);
        EvaluationHaltedTest.assertNotNull((Object)batchProblems);
        EvaluationHaltedTest.assertEquals((int)2, (int)batchProblems.getChildren().size());
        EvaluationHaltedTest.assertEquals((String)HALT_KIND_BASIC, (String)((Diagnostic)batchProblems.getChildren().get(0)).getMessage());
        EvaluationHaltedTest.assertEquals((String)HALT_KIND_CUSTOM, (String)((Diagnostic)batchProblems.getChildren().get(1)).getMessage());
        this.query.evaluate(Arrays.asList(HALT_KIND_NONE));
        EvaluationHaltedTest.assertNull((Object)OCLUtil.getEvaluationProblems((Query)this.query));
    }

    public void testSelectListHaltedQuery() {
        this.query = this.createQuery("Sequence { self }->exists(i | i.halt(self) = 'none')");
        EvaluationHaltedTest.assertNull((Object)OCLUtil.getEvaluationProblems((Query)this.query));
        List listResult = this.query.select(Arrays.asList(HALT_KIND_BASIC, HALT_KIND_NONE, HALT_KIND_CUSTOM));
        EvaluationHaltedTest.assertEquals((int)1, (int)listResult.size());
        EvaluationHaltedTest.assertEquals(listResult.get(0), (Object)HALT_KIND_NONE);
        Diagnostic batchProblems = OCLUtil.getEvaluationProblems((Query)this.query);
        EvaluationHaltedTest.assertNotNull((Object)batchProblems);
        EvaluationHaltedTest.assertEquals((int)2, (int)batchProblems.getChildren().size());
        EvaluationHaltedTest.assertEquals((String)HALT_KIND_BASIC, (String)((Diagnostic)batchProblems.getChildren().get(0)).getMessage());
        EvaluationHaltedTest.assertEquals((String)HALT_KIND_CUSTOM, (String)((Diagnostic)batchProblems.getChildren().get(1)).getMessage());
        EvaluationHaltedTest.assertEquals(Arrays.asList(HALT_KIND_NONE), (Object)this.query.select(Arrays.asList(HALT_KIND_NONE)));
        EvaluationHaltedTest.assertNull((Object)OCLUtil.getEvaluationProblems((Query)this.query));
    }

    public void testRejectListHaltedQuery() {
        this.query = this.createQuery("Sequence { self }->one(i | i.halt(self) = 'none')");
        EvaluationHaltedTest.assertNull((Object)OCLUtil.getEvaluationProblems((Query)this.query));
        List listResult = this.query.reject(Arrays.asList(HALT_KIND_BASIC, HALT_KIND_NONE, HALT_KIND_CUSTOM));
        EvaluationHaltedTest.assertEquals((int)2, (int)listResult.size());
        EvaluationHaltedTest.assertListResult(listResult, Arrays.asList(HALT_KIND_BASIC, HALT_KIND_CUSTOM));
        Diagnostic batchProblems = OCLUtil.getEvaluationProblems((Query)this.query);
        EvaluationHaltedTest.assertNotNull((Object)batchProblems);
        EvaluationHaltedTest.assertEquals((int)2, (int)batchProblems.getChildren().size());
        EvaluationHaltedTest.assertEquals((String)HALT_KIND_BASIC, (String)((Diagnostic)batchProblems.getChildren().get(0)).getMessage());
        EvaluationHaltedTest.assertEquals((String)HALT_KIND_CUSTOM, (String)((Diagnostic)batchProblems.getChildren().get(1)).getMessage());
        EvaluationHaltedTest.assertEquals(Collections.emptyList(), (Object)this.query.reject(Arrays.asList(HALT_KIND_NONE)));
        EvaluationHaltedTest.assertNull((Object)OCLUtil.getEvaluationProblems((Query)this.query));
    }

    public void testVariablesCleanup() {
        this.assertCleanupAfterHaltedEvaluation("let i : OclAny = true in halt('basic')");
        this.assertCleanupAfterHaltedEvaluation("let i : OclAny = halt('basic') in true");
        this.assertCleanupAfterHaltedEvaluation("Bag { 'foo' }->any(i | i.halt('basic').size() > 0)");
        this.assertCleanupAfterHaltedEvaluation("Bag { 'foo' }->collect(i | i.halt('basic'))");
        this.assertCleanupAfterHaltedEvaluation("Bag { Bag{ 'foo'} }->collectNested(i | i.halt('basic'))");
        this.assertCleanupAfterHaltedEvaluation("Bag { 'foo' }->exists(i | i.halt('basic').size() > 0)");
        this.assertCleanupAfterHaltedEvaluation("Bag { 'foo' }->forAll(i1, i2 | i1.halt('basic').size() > 0)");
        this.assertCleanupAfterHaltedEvaluation("Bag { 'foo' }->isUnique(i | i.halt('basic'))");
        this.assertCleanupAfterHaltedEvaluation("Bag { 'foo' }->one(i | i.halt('basic').size() > 0)");
        this.assertCleanupAfterHaltedEvaluation("Bag { 'foo' }->reject(i | i.halt('basic').size() > 0)");
        this.assertCleanupAfterHaltedEvaluation("Bag { 'foo' }->select(i | i.halt('basic').size() > 0)");
        this.assertCleanupAfterHaltedEvaluation("Bag { 'a', 'b' }->sortedBy(i | i.halt('basic'))");
    }

    private OCL.Query createQuery(String expression) {
        try {
            return (OCL.Query)this.ocl.createQuery(this.helper.createQuery(expression));
        }
        catch (ParserException e) {
            EvaluationHaltedTest.fail((String)e.getLocalizedMessage());
            return null;
        }
    }

    private void assertCleanupAfterHaltedEvaluation(String testExpression) {
        this.query = this.createQuery(testExpression);
        InterruptibleEvalEnv evalEnv = (InterruptibleEvalEnv)this.query.getEvaluationEnvironment();
        Object result = this.query.evaluate();
        this.assertInvalid(result);
        EvaluationHaltedTest.assertTrue((boolean)evalEnv.isEmpty());
        Diagnostic evaluationProblems = OCLUtil.getEvaluationProblems((Query)this.query);
        EvaluationHaltedTest.assertNotNull((Object)evaluationProblems);
        EvaluationHaltedTest.assertTrue((boolean)evaluationProblems.getChildren().isEmpty());
        EvaluationHaltedTest.assertEquals((String)HALT_KIND_BASIC, (String)evaluationProblems.getMessage());
    }

    private static void assertListResult(Object result, List<?> expectedElements) {
        EvaluationHaltedTest.assertTrue((String)"result must be a List", (boolean)(result instanceof List));
        EvaluationHaltedTest.assertNotNull((String)"expectedElements must be a List", (Object)(result instanceof List));
        List resultCollection = (List)result;
        EvaluationHaltedTest.assertEquals(expectedElements, (Object)resultCollection);
    }

    class InterruptibleEnv
    extends UMLEnvironment {
        Operation haltOperation;

        InterruptibleEnv(EPackage.Registry registry, ResourceSet rset) {
            super(registry, rset);
            this.defineHaltOperation();
        }

        InterruptibleEnv(InterruptibleEnv parent) {
            super((Environment)parent);
            this.haltOperation = parent.haltOperation;
        }

        protected void setFactory(EnvironmentFactory<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> factory) {
            super.setFactory(factory);
        }

        private void defineHaltOperation() {
            this.haltOperation = UMLFactory.eINSTANCE.createOperation();
            this.haltOperation.setName(EvaluationHaltedTest.HALT_OPERATION_NAME);
            this.haltOperation.setType((Type)this.getOCLStandardLibrary().getString());
            Parameter parm = UMLFactory.eINSTANCE.createParameter();
            parm.setName("kind");
            parm.setType((Type)this.getOCLStandardLibrary().getString());
            this.haltOperation.getOwnedParameters().add((Object)parm);
            this.haltOperation.setIsQuery(true);
            this.addHelperOperation((Classifier)this.getOCLStandardLibrary().getString(), this.haltOperation);
        }
    }

    class InterruptibleEnvFactory
    extends UMLEnvironmentFactory {
        public boolean haltOnContextLessExecution = false;

        InterruptibleEnvFactory() {
        }

        public InterruptibleEnv createEnvironment() {
            InterruptibleEnv result = new InterruptibleEnv(this.getEPackageRegistry(), this.getResourceSet());
            result.setFactory((EnvironmentFactory<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject>)this);
            return result;
        }

        public Environment<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> createEnvironment(Environment<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> parent) {
            if (!(parent instanceof InterruptibleEnv)) {
                throw new IllegalArgumentException("Parent environment must be my environment: " + parent);
            }
            InterruptibleEnv result = new InterruptibleEnv((InterruptibleEnv)parent);
            result.setFactory((EnvironmentFactory<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject>)this);
            return result;
        }

        public EvaluationEnvironment<Classifier, Operation, Property, Class, EObject> createEvaluationEnvironment() {
            return new InterruptibleEvalEnv(this);
        }

        public EvaluationEnvironment<Classifier, Operation, Property, Class, EObject> createEvaluationEnvironment(EvaluationEnvironment<Classifier, Operation, Property, Class, EObject> parent) {
            return new InterruptibleEvalEnv(parent);
        }

        public EvaluationVisitor<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> createEvaluationVisitor(Environment<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> env, EvaluationEnvironment<Classifier, Operation, Property, Class, EObject> evalEnv, Map<? extends Class, ? extends Set<? extends EObject>> extentMap) {
            EvaluationVisitor baseVisitor = super.createEvaluationVisitor(env, evalEnv, extentMap);
            if (this.haltOnContextLessExecution) {
                return new EvaluationVisitorDecorator<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject>(baseVisitor){

                    public Object visitExpression(OCLExpression<Classifier> expression) {
                        throw new EvaluationHaltedException("Halt");
                    }
                };
            }
            return baseVisitor;
        }
    }

    class InterruptibleEvalEnv
    extends UMLEvaluationEnvironment {
        private Set<String> names;

        InterruptibleEvalEnv(UMLEnvironmentFactory factory) {
            super(factory);
            this.names = new HashSet<String>();
        }

        InterruptibleEvalEnv(EvaluationEnvironment<Classifier, Operation, Property, Class, EObject> parent) {
            super(parent);
            this.names = new HashSet<String>();
        }

        public boolean overrides(Operation operation, int opcode) {
            return operation.getName().equals(EvaluationHaltedTest.HALT_OPERATION_NAME);
        }

        public Object callOperation(Operation operation, int opcode, Object source, Object[] args) {
            String kind = (String)args[0];
            if (EvaluationHaltedTest.HALT_KIND_BASIC.equals(kind)) {
                throw new EvaluationHaltedException(EvaluationHaltedTest.HALT_KIND_BASIC);
            }
            if (EvaluationHaltedTest.HALT_KIND_ON_ERROR.equals(kind)) {
                TestCauseException error = new TestCauseException();
                error.fillInStackTrace();
                throw new EvaluationHaltedException(EvaluationHaltedTest.HALT_KIND_ON_ERROR, (Throwable)error);
            }
            if (EvaluationHaltedTest.HALT_KIND_CUSTOM.equals(kind)) {
                throw new EvaluationHaltedException(CUSTOM_DIAGNOSTIC_INSTANCE);
            }
            if (EvaluationHaltedTest.OCL_CATCHED_EXC.equals(kind)) {
                throw new TestCauseException();
            }
            EvaluationHaltedTest.assertEquals((String)EvaluationHaltedTest.HALT_KIND_NONE, (String)kind);
            return kind;
        }

        public void add(String name, Object value) {
            this.names.add(name);
            super.add(name, value);
        }

        public Object remove(String name) {
            this.names.remove(name);
            return super.remove(name);
        }

        public void clear() {
            this.names.clear();
        }

        boolean isEmpty() {
            return this.names.isEmpty();
        }
    }

    private class TestCauseException
    extends RuntimeException {
        private static final long serialVersionUID = -2513266245112148087L;

        public TestCauseException() {
            EvaluationHaltedTest.this.exceptionThrown = true;
        }
    }
}

