/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.model;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.model.ModelReference;

public class ResourceTraversalHelper {
    public static Collection<EObject> getModelElementsInResource(Resource resource) {
        ArrayList<EObject> modelElementList = new ArrayList<EObject>();
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            EObject fromObject = (EObject)iterator.next();
            modelElementList.add(fromObject);
        }
        return modelElementList;
    }

    public static Collection<ModelReference> getModelReferencesForModelElements(Collection<EObject> modelElementList) {
        ArrayList<ModelReference> modelReferenceList = new ArrayList<ModelReference>();
        for (EObject fromObject : modelElementList) {
            for (EReference reference : fromObject.eClass().getEAllReferences()) {
                ResourceTraversalHelper.addNewModelReference(modelReferenceList, fromObject, reference);
            }
        }
        return modelReferenceList;
    }

    private static void addNewModelReference(ArrayList<ModelReference> modelReferenceList, EObject fromObject, EReference reference) {
        if (fromObject.eGet((EStructuralFeature)reference) instanceof EList) {
            for (Object referencedObject : (EList)fromObject.eGet((EStructuralFeature)reference)) {
                if (!(referencedObject instanceof EObject)) continue;
                modelReferenceList.add(new ModelReference(fromObject, (EObject)referencedObject, reference));
            }
        } else if (fromObject.eGet((EStructuralFeature)reference) instanceof EObject) {
            modelReferenceList.add(new ModelReference(fromObject, (EObject)fromObject.eGet((EStructuralFeature)reference), reference));
        }
    }
}

