/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.tests;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.tests.GenericInitializedFruitTestSuite;

public abstract class GenericTuplesTest<E extends EObject, PK extends E, T extends E, C extends T, CLS extends C, DT extends C, PT extends C, ET extends DT, O extends E, PM extends E, P extends E, PA extends P, PR extends P, EL, S, COA, SSA, CT>
extends GenericInitializedFruitTestSuite<E, PK, T, C, CLS, DT, PT, ET, O, PM, P, PA, PR, EL, S, COA, SSA, CT> {
    public void test_tupleLiteral_withTypes() {
        this.parse("package ocltest context Fruit inv: Tuple{a : Integer = 1} endpackage");
        this.parse("package ocltest context Fruit inv: Tuple{a : Integer = 1, b : String = 'foo', c : Color = Color::red} endpackage");
    }

    public void test_tupleLiteral_noTypes() {
        this.parse("package ocltest context Fruit inv: Tuple{a = 1} endpackage");
        this.parse("package ocltest context Fruit inv: Tuple{a = 1, b = 'foo', c = Color::red} endpackage");
    }

    public void test_tupleLiteral_mixedTypes() {
        this.parse("package ocltest context Fruit inv: Tuple{a : Integer = 1, b = 'foo', c : Color = Color::red} endpackage");
        this.parse("package ocltest context Fruit inv: Tuple{a = 1, b : String = 'foo', c = Color::red} endpackage");
    }

    public void test_tupleLiteral_nullValues() {
        GenericTuplesTest.assertEquals(null, (Object)this.evaluate(this.parse("package ocltest context Fruit inv: Tuple{a = null}.a endpackage")));
        GenericTuplesTest.assertEquals(null, (Object)this.evaluate(this.parse("package ocltest context Fruit inv: Tuple{a:OclVoid = null}.a endpackage")));
        GenericTuplesTest.assertEquals(null, (Object)this.evaluate(this.parse("package ocltest context Fruit inv: Tuple{a:String = null}.a endpackage")));
        GenericTuplesTest.assertEquals(null, (Object)this.evaluate(this.parse("package ocltest context Fruit inv: Tuple{a:Fruit = null}.a endpackage")));
        GenericTuplesTest.assertEquals((Object)1, (Object)this.evaluate(this.parse("package ocltest context Fruit inv: Tuple{a = null, b=1}.b endpackage")));
        GenericTuplesTest.assertEquals(null, (Object)this.evaluate(this.parse("package ocltest context Fruit inv: Tuple{a = null, b=1}.a endpackage")));
        GenericTuplesTest.assertEquals(null, (Object)this.evaluate(this.parse("package ocltest context Fruit inv: Tuple{a:String = null, b='abc'}.a endpackage")));
        GenericTuplesTest.assertEquals((Object)"abc", (Object)this.evaluate(this.parse("package ocltest context Fruit inv: Tuple{a:String = null, b='abc'}.b endpackage")));
        GenericTuplesTest.assertEquals(null, (Object)this.evaluate(this.parse("package ocltest context Fruit inv: Tuple{a:Fruit = null, b:String='abc'}.a endpackage")));
        GenericTuplesTest.assertEquals(null, (Object)this.evaluate(this.parse("package ocltest context Fruit inv: Tuple{a:Fruit = null, b:OclVoid=null}.b endpackage")));
    }

    public void test_tupleAssignment() {
        this.parse("package ocltest context Fruit inv: let t : Tuple(a : Integer, b : String, c : Color)  = Tuple{a = 1, b = 'foo', c = Color::red}  in t endpackage");
    }

    public void test_tupleCollections() {
        this.parse("package ocltest context Fruit inv: let ts : Set(Tuple(a : Integer, b : String, c : Color))  = Set{}->including(Tuple{a = 1, b = 'foo', c = Color::red})  in ts endpackage");
    }

    public void test_tupleEquivalence() {
        GenericTuplesTest.assertEquals((Object)Boolean.FALSE, (Object)this.evaluate(this.parse("package ocltest context Fruit inv: Tuple{a = 1, b = 'foo', c = Color::red}  = Tuple{b = 'foo', c = Color::black, a = 1} endpackage")));
        GenericTuplesTest.assertEquals((Object)Boolean.TRUE, (Object)this.evaluate(this.parse("package ocltest context Fruit inv: Tuple{a = 1, b = 'foo', c = Color::red}  <> Tuple{b = 'foo', c = Color::black, a = 1} endpackage")));
        GenericTuplesTest.assertEquals((Object)Boolean.TRUE, (Object)this.evaluate(this.parse("package ocltest context Fruit inv: Tuple{a = 1, b = 'foo', c = Color::red}  = Tuple{b = 'foo', c = Color::red, a = 1} endpackage")));
        GenericTuplesTest.assertEquals((Object)Boolean.TRUE, (Object)this.evaluate(this.parse("package ocltest context Fruit inv: Set{Tuple{a = 1, b = 'foo'}, Tuple{a = 5, b = 'bar'}}  = Set{Tuple{b = 'bar', a = 5}, Tuple{b = 'foo', a = 1}} endpackage")));
    }

    public void test_tupleTypeDistinction_192832() {
        OCLInput doc = new OCLInput("package ocltest context Fruit def: foo : Tuple(a : String) = Tuple{a = 'foo'} def: bar : Tuple(a : Integer) = Tuple{a = 100} endpackage");
        try {
            this.ocl.parse(doc);
            this.helper.setContext((Object)this.fruit);
            OCLExpression expr1 = this.helper.createQuery("self.foo");
            OCLExpression expr2 = this.helper.createQuery("self.bar");
            GenericTuplesTest.assertNotSame((Object)expr1.getType(), (Object)expr2.getType());
            EObject type = (EObject)expr1.getType();
            EObject a = (EObject)this.reflection.getAttribute(type, "a", null);
            GenericTuplesTest.assertNotNull((Object)a);
            GenericTuplesTest.assertEquals((Object)this.getOCLStandardLibrary().getString(), (Object)this.reflection.getOCLType(a));
            type = (EObject)expr2.getType();
            a = (EObject)this.reflection.getAttribute(type, "a", null);
            GenericTuplesTest.assertNotNull((Object)a);
            GenericTuplesTest.assertEquals((Object)this.getOCLStandardLibrary().getInteger(), (Object)this.reflection.getOCLType(a));
        }
        catch (Exception e) {
            GenericTuplesTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_tuplePartAccess_238049() {
        OCLExpression expr = this.parse("package ocltest context Fruit inv: Tuple{first : String = 'Roger', last : String = 'Bacon'}.first endpackage");
        GenericTuplesTest.assertEquals((Object)"Roger", (Object)this.evaluate(expr));
    }

    public void test_tupleWithLongLiteral_349117() {
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)true);
        OCLExpression expr = this.parse("package ocltest context Fruit inv: Tuple{first : Integer = 5000000000}.first endpackage");
        GenericTuplesTest.assertEquals((Object)5000000000L, (Object)this.evaluate(expr));
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)false);
    }

    public void test_tupleWithLongIntegerProperty_349117() throws ParserException {
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)true);
        this.helper.setContext((Object)((EObject)this.reflection.getUMLInteger()));
        OCLExpression expr2 = this.helper.createQuery("Tuple{first : Integer = self}.first");
        GenericTuplesTest.assertEquals((Object)5000000, (Object)this.evaluate(expr2, 5000000));
        this.helper.setContext((Object)((EObject)this.reflection.getUMLLong()));
        OCLExpression expr3 = this.helper.createQuery("2*self");
        GenericTuplesTest.assertEquals((Object)10000000000L, (Object)this.evaluate(expr3, 5000000000L));
        this.helper.setContext((Object)((EObject)this.reflection.getMetametaclass(this.denormalize("%Package"))));
        OCLExpression expr4 = this.helper.createQuery("Tuple{first : Integer = 1000*5000000}.first");
        GenericTuplesTest.assertEquals((Object)5000000000L, (Object)this.evaluate(expr4, this.reflection.getMetametaclass("Package")));
        this.helper.setContext((Object)((EObject)this.reflection.getUMLInteger()));
        OCLExpression expr5 = this.helper.createQuery("Tuple{first : Integer = self}.first");
        GenericTuplesTest.assertEquals((Object)5000000000L, (Object)this.evaluate(expr5, 5000000000L));
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)false);
    }
}

