/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.testutils;

import company.CompanyFactory;
import company.CompanyPackage;
import company.Department;
import company.Division;
import company.impl.CompanyImpl;
import company.impl.DepartmentImpl;
import company.impl.DivisionImpl;
import company.impl.EmployeeImpl;
import company.impl.FreelanceImpl;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.ExpressionInOCL;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.ocl.EnvironmentFactory;
import org.eclipse.ocl.examples.impactanalyzer.util.OCL;
import org.eclipse.ocl.examples.testutils.BaseDepartmentTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;

@Ignore
public class BaseDepartmentTestWithOCL
extends BaseDepartmentTest {
    protected ResourceSet rs = null;
    protected EPackage companyPackage = null;
    protected CompanyPackage comp = null;
    protected Set<DepartmentImpl> allDepartments = new HashSet<DepartmentImpl>();
    protected Set<FreelanceImpl> allFreelances = new HashSet<FreelanceImpl>();
    protected Set<EmployeeImpl> allEmployees = new HashSet<EmployeeImpl>();
    protected int curImployeeID = 0;
    protected int curDepartmentID = 0;
    protected EmployeeImpl aEmployee = null;
    protected DepartmentImpl aDepartment = null;
    protected DivisionImpl aDivision = null;
    protected FreelanceImpl aFreelance = null;
    protected CompanyImpl aCompany = null;
    public final String notBossFreelance = "context Department \n  inv NotBossFreelance: \n  not self.boss.oclIsTypeOf(Freelance)";
    public final String oldEmployee = "context Department \n  inv OldEmployee: \n  self.employee->exists(e | e.age > 45)";
    public final String uniqueNames = "context Employee \ninv UniqueNames: \n  Employee.allInstances()->forAll(e | \n  e <> self implies e.name <> self.name)";
    public final String validAssignment = "context Freelance \n  inv ValidAssignment: \n  self.assignment >= 5 and self.assignment <= 30";
    public final String maxJuniors = "context Department inv MaxJuniors: \nself.employee->select(e|e.age < 25)->size() < self.maxJuniors\n";
    public final String bossIsOldest = "context Employee inv BossIsOldest: \nself.age <= self.employer.boss.age\n";
    public final String bossHighestSalary = "context Department inv BossHighestSalary: \nself.employee->select(\n\te|e.salary >= self.boss.salary)->size() <= 1\n";
    public final String nastyConstraint = "context Division \ninv nasty: \nself.department->collect(d| \nd.employee->including(d.boss)).salary->sum() < budget";
    public final String limitEmployeesOfTheMonth = "context Division \ninv limitEmployeesOfTheMonth: \nself.employeesOfTheMonth->size() <= self.department->size()";
    public final String nestedDerivation = "context Division \ninv nestedDerivation: \nself.numberEmployeesOfTheMonth <= self.department->size()";
    public final String nonLinearDerivation = "context Department \ninv nonLinearDerivation: \nself.biggestNumberOfStudentsOrFreelancers < 5";
    public final String longNavigationWithDerivation = "context Company \ninv longNavigationWithDerivation: \nself.division.department->sortedBy(biggestNumberOfStudentsOrFreelancers)->last().biggestNumberOfStudentsOrFreelancers < 5";
    public final String eotmDeltaMax = "context Company \ninv eotmDeltaMax: \nself.eotmDelta <= 5";
    public final String divisionBossSecretary = "context Employee \ninv divBossSecretary: \nif self.directed->isEmpty() then \n   self.secretary.oclIsUndefined() \nelse \n   not self.secretary.oclIsUndefined() \nendif";
    public final String secretaryOlderThanBoss = "context Employee \ninv secretaryOlderThanBoss: \nif self.directed->notEmpty() and \n  not self.secretary.oclIsUndefined() then \n    self.age < self.secretary.age \nelse true \nendif";
    public final String boss10YearsOlderThanJunior = "context Department \ninv boss10YearsOlderThanJunior: \nlet t:Tuple(boss:Employee,junior:Employee)=Tuple{boss=self.boss, junior=self.employee->sortedBy(age)->first()} in \nt.boss.age > t.junior.age + 10";
    public final String expensesRestriction = "context Department inv BudgetRestriction: \nself.calcExpenses() <= self.budget";
    public final String simpleAllInstances = "context Employee inv InstanceCount: \nEmployee.allInstances()->size() = 17";
    public final String departmentMustHaveDivision = "context Department inv departmentMustHaveDivision: \nself.department2division->notEmpty()";
    public final String compareBossSalaryToJuniorSalary = "context Department \ninv compareBossSalaryToJuniorSalary: \nlet bt:Tuple(bp:Employee,bs:Integer)=Tuple{bp=self.boss, bs=self.boss.salary} in let jt:Tuple(jp:Employee, js:Integer)=Tuple{jp=self.employee->sortedBy(age)->first(), js=self.employee->sortedBy(age)->first().salary} in let t:Tuple(b:Tuple(p1:Employee, s1:Integer), j:Tuple(p2:Employee, s2:Integer))=Tuple{b=bt, j=jt} in \nt.b.p1 <> t.j.p2 implies t.b.s1 > t.j.s2 + 100";
    public final String employeeInSameDepartmentAsIntern = "context Employee \ninv employeeInSameDepartmentAsIntern: \nself.employer = self.intern.employer";
    public final String checkForBob = "context Employee inv checkForBob: Employee.allInstances()->select(e:Employee | e.name = 'Bob')->asOrderedSet()->first().oclAsType(Employee).name = 'Bob'";
    public final String sumBudgetLimit = "context company::Department inv: self.sumBudget() < 10000";
    public ExpressionInOCL notBossFreelanceAST = null;
    public ExpressionInOCL oldEmployeeAST = null;
    public ExpressionInOCL uniqueNamesAST = null;
    public ExpressionInOCL validAssignmentAST = null;
    public ExpressionInOCL maxJuniorsAST = null;
    public ExpressionInOCL bossIsOldestAST = null;
    public ExpressionInOCL bossHighestSalaryAST = null;
    public ExpressionInOCL expensesRestrictionAST = null;
    public ExpressionInOCL nastyConstraintAST = null;
    public ExpressionInOCL limitEmployeesOfTheMonthAST = null;
    public ExpressionInOCL nestedDerivationAST = null;
    public ExpressionInOCL nonLinearDerivationAST = null;
    public ExpressionInOCL longNavigationWithDerivationAST = null;
    public ExpressionInOCL eotmDeltaMaxAST = null;
    public ExpressionInOCL divisionBossSecretaryAST = null;
    public ExpressionInOCL secretaryOlderThanBossAST = null;
    public ExpressionInOCL boss10YearsOlderThanJuniorAST = null;
    public ExpressionInOCL departmentMustHaveDivisionAST = null;
    public ExpressionInOCL compareBossSalaryToJuniorSalaryAST = null;
    public ExpressionInOCL employeeInSameDepartmentAsInternAST = null;
    public ExpressionInOCL checkForBobAST = null;
    public ExpressionInOCL simpleAllInstancesAST = null;
    public ExpressionInOCL sumBudgetLimitAST = null;
    protected EClass companyClass = null;
    protected EClass division = null;
    protected EAttribute divisionBudget = null;
    protected EClass department = null;
    protected EAttribute departmentName = null;
    protected EAttribute departmentMaxJuniors = null;
    protected EAttribute departmentBudget = null;
    protected EClass employee = null;
    protected EAttribute employeeName = null;
    protected EAttribute employeeAge = null;
    protected EAttribute employeeSalary = null;
    protected EReference employeeSecretary = null;
    protected EAttribute employeeIsSecretary = null;
    protected EClass freelance = null;
    protected EClass student = null;
    protected EAttribute freelanceAssignment = null;
    protected EReference departmentRef = null;
    protected EReference departmentEmployeeOfTheMonth = null;
    protected EReference divisionEmployeesOfTheMonth = null;
    protected EAttribute numberEmployeesOfTheMonth = null;
    protected EAttribute biggestNumberOfStudentsOrFreelancers = null;
    protected EAttribute eotmDelta = null;
    protected EReference bossRef = null;
    protected EReference managedRef = null;
    protected EReference employerRef = null;
    protected EReference employeeRef = null;
    protected EReference directedRef = null;
    protected EReference internRef = null;
    protected EReference divisionDirector = null;

    protected ExpressionInOCL getAST(String stringFieldName) {
        try {
            Field stringField = ((Object)((Object)this)).getClass().getField(stringFieldName);
            Field astField = ((Object)((Object)this)).getClass().getField(String.valueOf(stringFieldName) + "AST");
            ExpressionInOCL result = (ExpressionInOCL)astField.get((Object)this);
            if (result == null) {
                result = (ExpressionInOCL)BaseDepartmentTestWithOCL.parse((String)stringField.get((Object)this), (EPackage)this.comp).iterator().next().getSpecification();
                astField.set((Object)this, result);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ExpressionInOCL getNotBossFreelanceAST() {
        return this.getAST("notBossFreelance");
    }

    protected ExpressionInOCL getOldEmployeeAST() {
        return this.getAST("oldEmployee");
    }

    protected ExpressionInOCL getUniqueNamesAST() {
        return this.getAST("uniqueNames");
    }

    protected ExpressionInOCL getValidAssignmentAST() {
        return this.getAST("validAssignment");
    }

    protected ExpressionInOCL getMaxJuniorsAST() {
        return this.getAST("maxJuniors");
    }

    protected ExpressionInOCL getBossIsOldestAST() {
        return this.getAST("bossIsOldest");
    }

    protected ExpressionInOCL getSumBudgetLimitAST() {
        return this.getAST("sumBudgetLimit");
    }

    protected ExpressionInOCL getBossHighestSalaryAST() {
        return this.getAST("bossHighestSalary");
    }

    protected ExpressionInOCL getExpensesRestrictionAST() {
        return this.getAST("expensesRestriction");
    }

    protected ExpressionInOCL getNastyConstraintAST() {
        return this.getAST("nastyConstraint");
    }

    protected ExpressionInOCL getLimitEmployeesOfTheMonthAST() {
        return this.getAST("limitEmployeesOfTheMonth");
    }

    protected ExpressionInOCL getNestedDerivationAST() {
        return this.getAST("nestedDerivation");
    }

    protected ExpressionInOCL getNonLinearDerivationAST() {
        return this.getAST("nonLinearDerivation");
    }

    protected ExpressionInOCL getlongNavigationWithDerivationAST() {
        return this.getAST("longNavigationWithDerivation");
    }

    protected ExpressionInOCL getEotmDeltaMaxAST() {
        return this.getAST("eotmDeltaMax");
    }

    protected ExpressionInOCL getDivisionBossSecretaryAST() {
        return this.getAST("divisionBossSecretary");
    }

    protected ExpressionInOCL getSecretaryOlderThanBossAST() {
        return this.getAST("secretaryOlderThanBoss");
    }

    protected ExpressionInOCL getBoss10YearsOlderThanJuniorAST() {
        return this.getAST("boss10YearsOlderThanJunior");
    }

    protected ExpressionInOCL getDepartmentMustHaveDivisionAST() {
        return this.getAST("departmentMutsHaveDivision");
    }

    protected ExpressionInOCL getCompareBossSalaryToJuniorSalaryAST() {
        return this.getAST("compareBossSalaryToJuniorSalary");
    }

    protected ExpressionInOCL getEmployeeInSameDepartmentAsInternAST() {
        return this.getAST("employeeInSameDepartmentAsIntern");
    }

    protected ExpressionInOCL getCheckForBobAST() {
        return this.getAST("checkForBob");
    }

    protected ExpressionInOCL getSimpleAllInstancesAST() {
        return this.getAST("simpleAllInstances");
    }

    @Before
    public void setUp() {
        this.beforeTestMethod();
    }

    @After
    public void tearDown() {
        this.resetInstances();
    }

    protected void beforeTestMethod() {
        this.buildModel();
    }

    protected void createInstances(double numDepartments, int numEmployees, int numFreelance) {
        int maxNumJuniors = 3;
        int budget = 50000;
        this.aDivision = (DivisionImpl)CompanyFactory.eINSTANCE.createDivision();
        this.aDivision.setName("The super Division");
        this.aDivision.setBudget(2000000);
        this.aCompany = (CompanyImpl)CompanyFactory.eINSTANCE.createCompany();
        this.aCompany.setDivision((Division)this.aDivision);
        if (this.comp.eResource() != null) {
            this.comp.eResource().getContents().add((Object)this.aDivision);
            this.comp.eResource().getContents().add((Object)this.aCompany);
        }
        double i = 0.0;
        while (i < numDepartments) {
            this.createDepartment(numEmployees, numFreelance, maxNumJuniors, budget);
            i += 1.0;
        }
        this.aDepartment = this.allDepartments.iterator().next();
        this.aDivision.getDepartment().add((Object)this.aDepartment);
        this.aEmployee = this.allEmployees.iterator().next();
        this.aFreelance = this.allFreelances.iterator().next();
    }

    private void buildModel() {
        this.comp = CompanyPackage.eINSTANCE;
        this.companyClass = this.comp.getCompany();
        this.division = this.comp.getDivision();
        this.divisionBudget = (EAttribute)this.division.getEStructuralFeature("budget");
        this.department = this.comp.getDepartment();
        this.departmentName = (EAttribute)this.department.getEStructuralFeature("name");
        this.departmentMaxJuniors = (EAttribute)this.department.getEStructuralFeature("maxJuniors");
        this.departmentBudget = (EAttribute)this.department.getEStructuralFeature("budget");
        this.bossRef = (EReference)this.department.getEStructuralFeature("boss");
        this.employeeRef = (EReference)this.department.getEStructuralFeature("employee");
        this.departmentRef = (EReference)this.division.getEStructuralFeature("department");
        this.departmentEmployeeOfTheMonth = (EReference)this.department.getEStructuralFeature("employeeOfTheMonth");
        this.divisionEmployeesOfTheMonth = (EReference)this.division.getEStructuralFeature("employeesOfTheMonth");
        this.numberEmployeesOfTheMonth = (EAttribute)this.division.getEStructuralFeature("numberEmployeesOfTheMonth");
        this.biggestNumberOfStudentsOrFreelancers = (EAttribute)this.department.getEStructuralFeature("biggestNumberOfStudentsOrFreelancers");
        this.eotmDelta = (EAttribute)this.companyClass.getEStructuralFeature("eotmDelta");
        this.employee = this.comp.getEmployee();
        this.employeeName = (EAttribute)this.employee.getEStructuralFeature("name");
        this.employeeAge = (EAttribute)this.employee.getEStructuralFeature("age");
        this.employeeSalary = (EAttribute)this.employee.getEStructuralFeature("salary");
        this.employerRef = (EReference)this.employee.getEStructuralFeature("employer");
        this.employeeSecretary = (EReference)this.employee.getEStructuralFeature("secretary");
        this.directedRef = (EReference)this.employee.getEStructuralFeature("directed");
        this.managedRef = (EReference)this.employee.getEStructuralFeature("managed");
        this.internRef = (EReference)this.employee.getEStructuralFeature("intern");
        this.divisionDirector = (EReference)this.companyClass.getEStructuralFeature("divisionDirector");
        this.freelance = this.comp.getFreelance();
        this.student = this.comp.getStudent();
        this.freelanceAssignment = (EAttribute)this.freelance.getEStructuralFeature("assignment");
        this.rs = new ResourceSetImpl();
        this.rs.eAdapters().add((Object)new ECrossReferenceAdapter());
        this.rs.getResources().add((Object)this.comp.eResource());
    }

    protected DepartmentImpl createDepartment(int employees, int freelances, int maxNumJuniors, int budget) {
        DepartmentImpl dep = (DepartmentImpl)CompanyFactory.eINSTANCE.createDepartment();
        dep.setName("Dep" + this.curDepartmentID);
        dep.setMaxJuniors(maxNumJuniors);
        dep.setBudget(budget);
        ++this.curDepartmentID;
        EmployeeImpl e = null;
        FreelanceImpl f = null;
        int i = 0;
        while (i < employees) {
            e = this.createEmployee();
            dep.getEmployee().add((Object)e);
            e.setEmployer((Department)dep);
            ++i;
        }
        i = 0;
        while (i < freelances) {
            f = this.createFreelance();
            dep.getEmployee().add((Object)f);
            f.setEmployer((Department)dep);
            ++i;
        }
        this.allDepartments.add(dep);
        if (this.comp.eResource() != null) {
            this.comp.eResource().getContents().add((Object)dep);
        }
        return dep;
    }

    protected EmployeeImpl createEmployee() {
        EmployeeImpl e = (EmployeeImpl)CompanyFactory.eINSTANCE.createEmployee();
        e.setName("empl" + this.curImployeeID);
        e.setAge(42);
        e.setSalary(2345);
        ++this.curImployeeID;
        this.allEmployees.add(e);
        if (this.comp.eResource() != null) {
            this.comp.eResource().getContents().add((Object)e);
        }
        return e;
    }

    protected FreelanceImpl createFreelance() {
        FreelanceImpl f = (FreelanceImpl)CompanyFactory.eINSTANCE.createFreelance();
        f.setName("empl" + this.curImployeeID);
        f.setAge(42);
        f.setAssignment(7);
        f.setSalary(2345);
        ++this.curImployeeID;
        this.allFreelances.add(f);
        if (this.comp.eResource() != null) {
            this.comp.eResource().getContents().add((Object)f);
        }
        return f;
    }

    public static List<Constraint> parse(String expression, EPackage basePackage) {
        OCLInput exp = new OCLInput(expression);
        String nsPrefix = basePackage.getNsPrefix();
        EPackage.Registry.INSTANCE.put((Object)nsPrefix, (Object)basePackage);
        org.eclipse.ocl.ecore.OCL ocl = OCL.newInstance();
        ocl = org.eclipse.ocl.ecore.OCL.newInstance(new EnvironmentFactory().createPackageContext((Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)ocl.getEnvironment(), basePackage));
        List result = null;
        try {
            result = ocl.parse(exp);
        }
        catch (ParserException e) {
            System.err.println("Error while parsing Expression:" + exp);
            e.printStackTrace();
        }
        return result;
    }

    private void resetInstances() {
        this.rs = null;
        this.companyPackage = null;
        this.comp = null;
        this.allDepartments = null;
        this.allFreelances = null;
        this.allEmployees = null;
        this.aEmployee = null;
        this.aDepartment = null;
        this.aDivision = null;
        this.aFreelance = null;
        this.companyClass = null;
        this.division = null;
        this.divisionBudget = null;
        this.department = null;
        this.departmentName = null;
        this.departmentMaxJuniors = null;
        this.departmentBudget = null;
        this.employee = null;
        this.employeeName = null;
        this.employeeAge = null;
        this.employeeSalary = null;
        this.employeeSecretary = null;
        this.freelance = null;
        this.student = null;
        this.freelanceAssignment = null;
        this.departmentRef = null;
        this.departmentEmployeeOfTheMonth = null;
        this.divisionEmployeesOfTheMonth = null;
        this.numberEmployeesOfTheMonth = null;
        this.biggestNumberOfStudentsOrFreelancers = null;
        this.eotmDelta = null;
        this.bossRef = null;
        this.managedRef = null;
        this.employerRef = null;
        this.employeeRef = null;
        this.directedRef = null;
    }
}

