/*
 * Decompiled with CFR 0.152.
 */
package dataaccess.analytics.util;

import dataaccess.analytics.AnalyticsPackage;
import dataaccess.analytics.CellSet;
import dataaccess.analytics.Dimension;
import dataaccess.analytics.DimensionDefinition;
import dataaccess.analytics.DimensionExpression;
import dataaccess.analytics.GroupBy;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class AnalyticsValidator
extends EObjectValidator {
    public static final AnalyticsValidator INSTANCE = new AnalyticsValidator();
    public static final String DIAGNOSTIC_SOURCE = "dataaccess.analytics";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected static final String DIMENSION__BLOCK_SIGNATURE_MUST_MATCH__EEXPRESSION = "self.characteristicFunction.input->size() = 1 and \r\n  self.cellSet.factsType.conformsToIgnoringMultiplicity(self.characteristicFunction.input->at(1).getType())\r\n    -- Add the following again once we have NestedTypeDefinitions under control...\r\n    -- and  self.characteristicFunction.input->at(1).getType().upperMultiplicity = 1";
    protected static final String DIMENSION__CHARACTERISTIC_FUNCTION_MUST_NOT_BE_ABSTRACT__EEXPRESSION = "not self.characteristicFunction.isAbstract()";
    protected static final String CELL_SET__VALUE_FUNCTION_SIGNATURE_MUST_MATCH__EEXPRESSION = "self.valueFunction->notEmpty() implies\r\n    (self.valueFunction.input->size() = 1 and\r\n     self.factsType.conformsToIgnoringMultiplicity(self.valueFunction.input->at(1).getType())\r\n    -- Add the following again once we have NestedTypeDefinitions under control...\r\n    -- and  self.valueFunction.input->at(1).getType().upperMultiplicity = 1\r\n    )";
    protected static final String CELL_SET__AGGREGATION_FUNCTION_SIGNATURE_MUST_MATCH__EEXPRESSION = "self.aggregationFunction.input->size() = 1 and \r\n  self.keyFigureType().conformsTo(self.aggregationFunction.input->at(1).getType())";
    protected static final String CELL_SET__AGGREGATION_FUNCTION_MUST_NOT_BE_ABSTRACT__EEXPRESSION = "not self.aggregationFunction.isAbstract()";
    protected static final String CELL_SET__VALUE_FUNCTION_MUST_NOT_BE_ABSTRACT__EEXPRESSION = "self.valueFunction->forAll(vf | not vf.isAbstract())";
    protected static final String DIMENSION_EXPRESSION__FACTS_TYPE_CONFORMS_TO_FIRST_FUNCTION_PARAMETER_TYPE__EEXPRESSION = "self.facts.getType().conformsTo(self.dimensionParameter.ownerSignature.input->at(1).getType())";
    protected static final String DIMENSION_EXPRESSION__CELL_SET_EXPRESSION_MUST_HAVE_FUNCTION_SIGNATURE_TYPE__EEXPRESSION = "self.cellSet.getType().oclIsKindOf(data::classes::FunctionSignatureTypeDefinition)";
    protected static final String DIMENSION_EXPRESSION__DIMENSION_PARAMETER_IS_NOT_FIRST__EEXPRESSION = "self.dimensionParameter.ownerSignature.input->indexOf(self.dimensionParameter) > 1";
    protected static final String GROUP_BY__GROUPED_FACTS_ITERATOR_MUST_EXIST_IF_MAP_EXPRESSION_EXISTS__EEXPRESSION = "self.mapExpression->notEmpty() implies self.groupedFacts->notEmpty()";
    protected static final String GROUP_BY__MAP_EXPRESSION_MUST_BE_SIDE_EFFECT_FREE__EEXPRESSION = "if self.mapExpression->notEmpty() then\r\n    self.mapExpression.isSideEffectFree()\r\n  else\r\n    true\r\n  endif";
    protected static final String GROUP_BY__GROUP_BY_ITERATORS_MUST_HAVE_DISTINCT_NAMES__EEXPRESSION = "self.dimensions.iterator->asSet()->union(self.groupedFacts->asSet())->union(self.fact->asSet())->forAll(i, j | i<>j implies i.name<>j.name)";
    protected static final String DIMENSION_DEFINITION__DIMENSION_EXPRESSION_MUST_BE_SIDE_EFFECT_FREE__EEXPRESSION = "self.expression.isSideEffectFree()";

    protected EPackage getEPackage() {
        return AnalyticsPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateDimension((Dimension)value, diagnostics, context);
            }
            case 1: {
                return this.validateCellSet((CellSet)value, diagnostics, context);
            }
            case 2: {
                return this.validateDimensionExpression((DimensionExpression)value, diagnostics, context);
            }
            case 3: {
                return this.validateGroupBy((GroupBy)value, diagnostics, context);
            }
            case 4: {
                return this.validateDimensionDefinition((DimensionDefinition)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateDimension(Dimension dimension, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(dimension, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(dimension, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(dimension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(dimension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(dimension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(dimension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(dimension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(dimension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(dimension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDimension_BlockSignatureMustMatch(dimension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDimension_CharacteristicFunctionMustNotBeAbstract(dimension, diagnostics, context);
        }
        return result;
    }

    public boolean validateDimension_BlockSignatureMustMatch(Dimension dimension, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(AnalyticsPackage.Literals.DIMENSION, dimension, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "BlockSignatureMustMatch", DIMENSION__BLOCK_SIGNATURE_MUST_MATCH__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateDimension_CharacteristicFunctionMustNotBeAbstract(Dimension dimension, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(AnalyticsPackage.Literals.DIMENSION, dimension, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "CharacteristicFunctionMustNotBeAbstract", DIMENSION__CHARACTERISTIC_FUNCTION_MUST_NOT_BE_ABSTRACT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateCellSet(CellSet cellSet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(cellSet, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(cellSet, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(cellSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(cellSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(cellSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(cellSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(cellSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(cellSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(cellSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCellSet_ValueFunctionSignatureMustMatch(cellSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCellSet_AggregationFunctionSignatureMustMatch(cellSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCellSet_AggregationFunctionMustNotBeAbstract(cellSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCellSet_ValueFunctionMustNotBeAbstract(cellSet, diagnostics, context);
        }
        return result;
    }

    public boolean validateCellSet_ValueFunctionSignatureMustMatch(CellSet cellSet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(AnalyticsPackage.Literals.CELL_SET, cellSet, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ValueFunctionSignatureMustMatch", CELL_SET__VALUE_FUNCTION_SIGNATURE_MUST_MATCH__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateCellSet_AggregationFunctionSignatureMustMatch(CellSet cellSet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(AnalyticsPackage.Literals.CELL_SET, cellSet, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "AggregationFunctionSignatureMustMatch", CELL_SET__AGGREGATION_FUNCTION_SIGNATURE_MUST_MATCH__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateCellSet_AggregationFunctionMustNotBeAbstract(CellSet cellSet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(AnalyticsPackage.Literals.CELL_SET, cellSet, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "AggregationFunctionMustNotBeAbstract", CELL_SET__AGGREGATION_FUNCTION_MUST_NOT_BE_ABSTRACT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateCellSet_ValueFunctionMustNotBeAbstract(CellSet cellSet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(AnalyticsPackage.Literals.CELL_SET, cellSet, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ValueFunctionMustNotBeAbstract", CELL_SET__VALUE_FUNCTION_MUST_NOT_BE_ABSTRACT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateDimensionExpression(DimensionExpression dimensionExpression, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(dimensionExpression, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(dimensionExpression, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(dimensionExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(dimensionExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(dimensionExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(dimensionExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(dimensionExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(dimensionExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(dimensionExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDimensionExpression_FactsTypeConformsToFirstFunctionParameterType(dimensionExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDimensionExpression_CellSetExpressionMustHaveFunctionSignatureType(dimensionExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDimensionExpression_DimensionParameterIsNotFirst(dimensionExpression, diagnostics, context);
        }
        return result;
    }

    public boolean validateDimensionExpression_FactsTypeConformsToFirstFunctionParameterType(DimensionExpression dimensionExpression, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(AnalyticsPackage.Literals.DIMENSION_EXPRESSION, dimensionExpression, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "FactsTypeConformsToFirstFunctionParameterType", DIMENSION_EXPRESSION__FACTS_TYPE_CONFORMS_TO_FIRST_FUNCTION_PARAMETER_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateDimensionExpression_CellSetExpressionMustHaveFunctionSignatureType(DimensionExpression dimensionExpression, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(AnalyticsPackage.Literals.DIMENSION_EXPRESSION, dimensionExpression, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "CellSetExpressionMustHaveFunctionSignatureType", DIMENSION_EXPRESSION__CELL_SET_EXPRESSION_MUST_HAVE_FUNCTION_SIGNATURE_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateDimensionExpression_DimensionParameterIsNotFirst(DimensionExpression dimensionExpression, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(AnalyticsPackage.Literals.DIMENSION_EXPRESSION, dimensionExpression, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "DimensionParameterIsNotFirst", DIMENSION_EXPRESSION__DIMENSION_PARAMETER_IS_NOT_FIRST__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateGroupBy(GroupBy groupBy, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(groupBy, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(groupBy, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(groupBy, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(groupBy, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(groupBy, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(groupBy, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(groupBy, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(groupBy, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(groupBy, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGroupBy_GroupedFactsIteratorMustExistIfMapExpressionExists(groupBy, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGroupBy_MapExpressionMustBeSideEffectFree(groupBy, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGroupBy_GroupByIteratorsMustHaveDistinctNames(groupBy, diagnostics, context);
        }
        return result;
    }

    public boolean validateGroupBy_GroupedFactsIteratorMustExistIfMapExpressionExists(GroupBy groupBy, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(AnalyticsPackage.Literals.GROUP_BY, groupBy, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "GroupedFactsIteratorMustExistIfMapExpressionExists", GROUP_BY__GROUPED_FACTS_ITERATOR_MUST_EXIST_IF_MAP_EXPRESSION_EXISTS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateGroupBy_MapExpressionMustBeSideEffectFree(GroupBy groupBy, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(AnalyticsPackage.Literals.GROUP_BY, groupBy, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "MapExpressionMustBeSideEffectFree", GROUP_BY__MAP_EXPRESSION_MUST_BE_SIDE_EFFECT_FREE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateGroupBy_GroupByIteratorsMustHaveDistinctNames(GroupBy groupBy, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(AnalyticsPackage.Literals.GROUP_BY, groupBy, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "GroupByIteratorsMustHaveDistinctNames", GROUP_BY__GROUP_BY_ITERATORS_MUST_HAVE_DISTINCT_NAMES__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateDimensionDefinition(DimensionDefinition dimensionDefinition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(dimensionDefinition, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(dimensionDefinition, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(dimensionDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(dimensionDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(dimensionDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(dimensionDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(dimensionDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(dimensionDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(dimensionDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDimensionDefinition_DimensionExpressionMustBeSideEffectFree(dimensionDefinition, diagnostics, context);
        }
        return result;
    }

    public boolean validateDimensionDefinition_DimensionExpressionMustBeSideEffectFree(DimensionDefinition dimensionDefinition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(AnalyticsPackage.Literals.DIMENSION_DEFINITION, dimensionDefinition, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "DimensionExpressionMustBeSideEffectFree", DIMENSION_DEFINITION__DIMENSION_EXPRESSION_MUST_BE_SIDE_EFFECT_FREE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

