/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.utilities.AbstractVisitor;
import org.eclipse.ocl.utilities.ExpressionInOCL;
import org.eclipse.ocl.utilities.Visitor;

public class AbstractVisitorTest
extends AbstractTestSuite {
    public void test_visitResults() {
        OCLExpression expression = this.parse("package ocltest context Apple inv: Apple.allInstances()->select(label->notEmpty())->forAll(a1, a2 | a1 <> a2 implies a1.label <> a2.label) endpackage");
        TestVisitor<Integer> visitor = new TestVisitor<Integer>(Integer.valueOf(0)){

            protected Integer handlePropertyCallExp(PropertyCallExp<EClassifier, EStructuralFeature> callExp, Integer sourceResult, List<Integer> qualifierResults) {
                if (callExp.getReferredProperty() == AbstractVisitorTest.this.apple_label) {
                    this.result = (Integer)this.result + 1;
                }
                return (Integer)this.result;
            }
        };
        AbstractVisitorTest.assertEquals((Object)3, (Object)expression.accept((Visitor)visitor));
    }

    public void test_visitInvariantConstraint_210580() {
        this.helper.setContext((Object)this.apple);
        try {
            Constraint constraint = (Constraint)this.helper.createInvariant("Apple.allInstances()->select(label->notEmpty())->forAll(a1, a2 | a1 <> a2 implies a1.label <> a2.label)");
            AbstractVisitorTest.assertEquals((Object)((Object)this), (Object)new TestVisitor<AbstractVisitorTest>(this).visitConstraint(constraint));
        }
        catch (Exception e) {
            AbstractVisitorTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
        }
    }

    private static class TestVisitor<T>
    extends AbstractVisitor<T, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> {
        public TestVisitor() {
        }

        public TestVisitor(T initialValue) {
            super(initialValue);
        }

        protected ExpressionInOCL<EClassifier, EParameter> getSpecification(Constraint constraint) {
            return constraint.getSpecification();
        }
    }
}

