/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.internal.UMLReflectionImpl;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.ecore.tests.LocationInformationTest;
import org.eclipse.ocl.expressions.AssociationClassCallExp;
import org.eclipse.ocl.expressions.FeatureCallExp;
import org.eclipse.ocl.expressions.LoopExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.helper.ChoiceKind;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.tests.GenericFruitTestSuite;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.UMLReflection;

public class AssociationTest
extends AbstractTestSuite {
    EReference stem_apple;
    EReference stem_tree;
    EAttribute stem_thickness;
    EReference apple_tree;
    EReference tree_apples;
    EClass forest;
    EReference forest_trees;
    EStructuralFeature q1;
    EStructuralFeature q2;

    public void test_qualifiers_associationEnd_RATLC00538077() {
        this.parse("package ocltest context Forest inv: self.trees->forAll(t : Tree | not t.apples->isEmpty()) endpackage");
        this.parse("package ocltest context Forest inv: not self.trees['foo', 3].apples->isEmpty() endpackage");
        AssertionFailedError err = null;
        try {
            this.parse("package ocltest context Forest inv: not self.trees['foo'].apples->isEmpty() endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            AssociationTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        AssociationTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
        try {
            this.parse("package ocltest context Forest inv: not self.trees[3, 'foo'].apples->isEmpty() endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            AssociationTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        AssociationTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
        try {
            this.parse("package ocltest context Forest inv: not self.trees['foo', 3, 'bar'].apples->isEmpty() endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            AssociationTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        AssociationTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
    }

    public void test_associationClass_RATLC00538077() {
        this.parse("package ocltest context Tree inv: self.apples->forAll(a : Apple | a.color <> Color::black) endpackage");
        this.parse("package ocltest context Tree inv: self.stem->forAll(s : Stem | s.thickness > 0) endpackage");
    }

    public void test_associationClass_qualifiers_RATLC00538077() {
        this.parse("package ocltest context Tree inv: self.stem[apples]->forAll(s : Stem | s.thickness > 0) endpackage");
        AssertionFailedError err = null;
        try {
            this.parse("package ocltest context Tree inv: self.stem[tree]->forAll(s : Stem | s.thickness > 0) endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            AssociationTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        AssociationTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
        try {
            this.parse("package ocltest context Tree inv: self.stem[3]->forAll(s : Stem | s.thickness > 0) endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            AssociationTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        AssociationTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
        try {
            this.parse("package ocltest context Tree inv: self.stem[apples, apples]->forAll(s : Stem | s.thickness > 0) endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            AssociationTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        AssociationTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
    }

    public void test_associationClass_reflexive_RATLC00538077() {
        EClass ac = EcoreFactory.eINSTANCE.createEClass();
        ac.setName("AC");
        ((EPackage)this.fruitPackage).getEClassifiers().add((Object)ac);
        EAttribute x = EcoreFactory.eINSTANCE.createEAttribute();
        x.setName("x");
        x.setEType((EClassifier)EcorePackage.eINSTANCE.getEInt());
        ac.getEStructuralFeatures().add((Object)x);
        EReference parent = EcoreFactory.eINSTANCE.createEReference();
        parent.setName("parent");
        parent.setEType((EClassifier)this.tree);
        this.tree.getEStructuralFeatures().add((Object)parent);
        EReference children = EcoreFactory.eINSTANCE.createEReference();
        children.setName("children");
        children.setEType((EClassifier)this.tree);
        children.setUpperBound(-1);
        this.tree.getEStructuralFeatures().add((Object)children);
        EReference parentTree = EcoreFactory.eINSTANCE.createEReference();
        parentTree.setName("parentTree");
        parentTree.setEType((EClassifier)this.tree);
        parentTree.setEOpposite(parent);
        ac.getEStructuralFeatures().add((Object)parentTree);
        EReference childTree = EcoreFactory.eINSTANCE.createEReference();
        childTree.setName("childTree");
        childTree.setEType((EClassifier)this.tree);
        childTree.setEOpposite(children);
        ac.getEStructuralFeatures().add((Object)childTree);
        this.parse("package ocltest context Tree inv: self.children->forAll(t : Tree | not t.apples->isEmpty()) endpackage");
        this.parse("package ocltest context Tree inv: self.aC[children]->forAll(ac : AC | ac.x > 0) endpackage");
        this.parse("package ocltest context Tree inv: self.aC[parent].x > 0 endpackage");
        AssertionFailedError err = null;
        try {
            this.parse("package ocltest context Tree inv: self.aC->forAll(ac : AC | ac.x > 0) endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            AssociationTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        AssociationTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
    }

    public void test_navigateFromAssociationClass_RATLC00538077() {
        this.parse("package ocltest context Stem inv: self.apple.color <> Color::black endpackage");
        this.parse("package ocltest context Stem inv: self.tree.apples->forAll(a : Apple | a.color <> Color::black) endpackage");
        this.parse("package ocltest context Stem inv: self.thickness > 0 endpackage");
    }

    public void test_associationClass_contextAssist_RATLC00538077() {
        this.helper.setContext((Object)this.tree);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            AssociationTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.PROPERTY, "apples");
            this.assertChoice(choices, ChoiceKind.ASSOCIATION_CLASS, "stem");
        }
        catch (Exception e) {
            AssociationTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_propertyPositions_associationClassEndCall() {
        String exprString = "self.apples->notEmpty()";
        OCLExpression constraint = this.createQuery((EObject)this.tree, "self.apples->notEmpty()");
        OperationCallExp<EClassifier, EOperation> notEmptyExp = LocationInformationTest.asOperationCall(constraint);
        FeatureCallExp<EClassifier> mpcExp = LocationInformationTest.asFeatureCall(notEmptyExp.getSource());
        LocationInformationTest.assertPropertyLocation(mpcExp, "self.apples->notEmpty()".indexOf("apples"), "self.apples->notEmpty()".indexOf("->"));
    }

    public void test_propertyPositions_associationClassCall() {
        String exprString = "self.stem[apples]->notEmpty()";
        OCLExpression constraint = this.createQuery((EObject)this.tree, "self.stem[apples]->notEmpty()");
        OperationCallExp<EClassifier, EOperation> notEmptyExp = LocationInformationTest.asOperationCall(constraint);
        FeatureCallExp<EClassifier> mpcExp = LocationInformationTest.asFeatureCall(notEmptyExp.getSource());
        LocationInformationTest.assertPropertyLocation(mpcExp, "self.stem[apples]->notEmpty()".indexOf("stem"), "self.stem[apples]->notEmpty()".indexOf("["));
    }

    public void test_propertyPositions_associationClassCall_implicitCollect() {
        String exprString = "Tree.allInstances().stem[apples]->notEmpty()";
        OCLExpression constraint = this.createQuery((EObject)this.tree, "Tree.allInstances().stem[apples]->notEmpty()");
        OperationCallExp<EClassifier, EOperation> notEmptyExp = LocationInformationTest.asOperationCall(constraint);
        LoopExp<EClassifier, EParameter> loopExp = LocationInformationTest.asLoop(notEmptyExp.getSource());
        FeatureCallExp<EClassifier> mpcExp = LocationInformationTest.asFeatureCall(loopExp.getBody());
        LocationInformationTest.assertPropertyLocation(mpcExp, "Tree.allInstances().stem[apples]->notEmpty()".indexOf("stem"), "Tree.allInstances().stem[apples]->notEmpty()".indexOf("["));
    }

    public void test_propertyPositions_associationClassQualified() {
        String exprString = "self.stem[apples]->notEmpty()";
        OCLExpression constraint = this.createQuery((EObject)this.tree, "self.stem[apples]->notEmpty()");
        OperationCallExp<EClassifier, EOperation> notEmptyExp = LocationInformationTest.asOperationCall(constraint);
        AssociationClassCallExp<EClassifier, EStructuralFeature> accExp = LocationInformationTest.asAssociationClassCall(notEmptyExp.getSource());
        EList qualifiers = accExp.getQualifier();
        AssociationTest.assertEquals((int)1, (int)qualifiers.size());
        OCLExpression qualifier = (OCLExpression)qualifiers.get(0);
        LocationInformationTest.assertLocation((ASTNode)qualifier, "self.stem[apples]->notEmpty()".indexOf("apples"), "self.stem[apples]->notEmpty()".indexOf("]->"));
    }

    public void test_propertyPositions_associationClassQualified_implicitCollect() {
        String exprString = "Tree.allInstances().stem[apples]->notEmpty()";
        OCLExpression constraint = this.createQuery((EObject)this.tree, "Tree.allInstances().stem[apples]->notEmpty()");
        OperationCallExp<EClassifier, EOperation> notEmptyExp = LocationInformationTest.asOperationCall(constraint);
        LoopExp<EClassifier, EParameter> loopExp = LocationInformationTest.asLoop(notEmptyExp.getSource());
        AssociationClassCallExp<EClassifier, EStructuralFeature> accExp = LocationInformationTest.asAssociationClassCall(loopExp.getBody());
        EList qualifiers = accExp.getQualifier();
        AssociationTest.assertEquals((int)1, (int)qualifiers.size());
        OCLExpression qualifier = (OCLExpression)qualifiers.get(0);
        LocationInformationTest.assertLocation((ASTNode)qualifier, "Tree.allInstances().stem[apples]->notEmpty()".indexOf("apples"), "Tree.allInstances().stem[apples]->notEmpty()".indexOf("]->"));
    }

    public void test_associationNullContext_bugzilla121614() {
        EPackage epackage = EcoreFactory.eINSTANCE.createEPackage();
        epackage.setName("MyPackage");
        epackage.setNsPrefix("mypkg");
        epackage.setNsURI("http:///mypkg.ecore");
        resourceSet.getPackageRegistry().put((Object)epackage.getNsURI(), (Object)epackage);
        EClass employee = EcoreFactory.eINSTANCE.createEClass();
        employee.setName("Employee");
        epackage.getEClassifiers().add((Object)employee);
        EReference manager = EcoreFactory.eINSTANCE.createEReference();
        manager.setName("manager");
        manager.setEType((EClassifier)employee);
        employee.getEStructuralFeatures().add((Object)manager);
        EFactory efactory = epackage.getEFactoryInstance();
        EObject emp1 = efactory.create(employee);
        OCLExpression expr = this.parse("package mypkg context Employee inv: self.manager.manager endpackage");
        Object result = this.evaluate(expr, emp1);
        this.assertInvalid(result);
    }

    public void test_qualifiedAssociation_scalar_133435() {
        OCLExpression expr = this.parse("package ocltest context Forest inv: self.trees endpackage");
        AssociationTest.assertTrue((boolean)(expr.getType() instanceof CollectionType));
        CollectionType collType = (CollectionType)expr.getType();
        AssociationTest.assertSame((Object)this.tree, (Object)collType.getElementType());
        expr = this.parse("package ocltest context Forest inv: self.trees['foo', 3] endpackage");
        AssociationTest.assertSame((Object)this.tree, (Object)expr.getType());
    }

    public void setUp() {
        super.setUp();
        this.expectModified = true;
        this.initFruitExtensions();
    }

    private void initFruitExtensions() {
        if (this.q1 != null) {
            return;
        }
        ((EPackage)this.fruitPackage).getEClassifiers().remove((Object)this.stem);
        this.stem = EcoreFactory.eINSTANCE.createEClass();
        this.stem.setName("Stem");
        ((EPackage)this.fruitPackage).getEClassifiers().add((Object)this.stem);
        this.apple.getEStructuralFeatures().remove((Object)this.apple_stem);
        this.apple_stem = null;
        this.apple_tree = EcoreFactory.eINSTANCE.createEReference();
        this.apple_tree.setName("tree");
        this.apple_tree.setEType((EClassifier)this.tree);
        this.apple.getEStructuralFeatures().add((Object)this.apple_tree);
        this.tree_apples = EcoreFactory.eINSTANCE.createEReference();
        this.tree_apples.setName("apples");
        this.tree_apples.setEType((EClassifier)this.apple);
        this.tree_apples.setUpperBound(-1);
        this.tree.getEStructuralFeatures().add((Object)this.tree_apples);
        this.stem_thickness = EcoreFactory.eINSTANCE.createEAttribute();
        this.stem_thickness.setName("thickness");
        this.stem_thickness.setEType((EClassifier)EcorePackage.eINSTANCE.getEInt());
        this.stem.getEStructuralFeatures().add((Object)this.stem_thickness);
        this.stem_apple = EcoreFactory.eINSTANCE.createEReference();
        this.stem_apple.setName("apple");
        this.stem_apple.setEType((EClassifier)this.apple);
        this.stem.getEStructuralFeatures().add((Object)this.stem_apple);
        this.stem_tree = EcoreFactory.eINSTANCE.createEReference();
        this.stem_tree.setName("tree");
        this.stem_tree.setEType((EClassifier)this.tree);
        this.stem.getEStructuralFeatures().add((Object)this.stem_tree);
        this.forest = EcoreFactory.eINSTANCE.createEClass();
        this.forest.setName("Forest");
        ((EPackage)this.fruitPackage).getEClassifiers().add((Object)this.forest);
        this.forest_trees = EcoreFactory.eINSTANCE.createEReference();
        this.forest_trees.setName("trees");
        this.forest_trees.setEType((EClassifier)this.tree);
        this.forest_trees.setUpperBound(-1);
        this.forest.getEStructuralFeatures().add((Object)this.forest_trees);
        this.q1 = EcoreFactory.eINSTANCE.createEAttribute();
        this.q1.setName("q1");
        this.q1.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        this.q2 = EcoreFactory.eINSTANCE.createEAttribute();
        this.q2.setName("q2");
        this.q2.setEType((EClassifier)EcorePackage.eINSTANCE.getEInt());
    }

    protected OCL createOCL() {
        return OCL.newInstance((EnvironmentFactory)new AssocClassFruitEnvironmentFactory());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.fruitPackage = null;
    }

    private class AssocClassFruitEnvironment
    extends EcoreEnvironment
    implements GenericFruitTestSuite.InitEnvironment {
        private List<EStructuralFeature> stemEnds;
        private List<EStructuralFeature> qualifiers;

        public AssocClassFruitEnvironment(AssocClassFruitEnvironmentFactory factory) {
            super((EcoreEnvironmentFactory)factory, null);
            this.stemEnds = new ArrayList<EStructuralFeature>(2);
            this.qualifiers = new ArrayList<EStructuralFeature>(2);
            this.setContextPackage((EPackage)AssociationTest.this.fruitPackage);
        }

        public AssocClassFruitEnvironment(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent) {
            super(parent);
            this.stemEnds = new ArrayList<EStructuralFeature>(2);
            this.qualifiers = new ArrayList<EStructuralFeature>(2);
        }

        public void init() {
            AssociationTest.this.initFruitExtensions();
            this.stemEnds.add((EStructuralFeature)AssociationTest.this.stem_tree);
            this.stemEnds.add((EStructuralFeature)AssociationTest.this.stem_apple);
            this.qualifiers.add(AssociationTest.this.q1);
            this.qualifiers.add(AssociationTest.this.q2);
        }

        public UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> getUMLReflection() {
            return new UMLReflectionImpl(){

                public boolean isAssociationClass(EClassifier eclass) {
                    return eclass == ((AssocClassFruitEnvironment)AssocClassFruitEnvironment.this).AssociationTest.this.stem || eclass.getName().equals("AC");
                }

                public EClass getAssociationClass(EStructuralFeature reference) {
                    if (reference == ((AssocClassFruitEnvironment)AssocClassFruitEnvironment.this).AssociationTest.this.tree_apples || reference == ((AssocClassFruitEnvironment)AssocClassFruitEnvironment.this).AssociationTest.this.apple_tree) {
                        return ((AssocClassFruitEnvironment)AssocClassFruitEnvironment.this).AssociationTest.this.stem;
                    }
                    if (reference.getName().equals("parent") || reference.getName().equals("children")) {
                        return (EClass)((EPackage)((AssocClassFruitEnvironment)AssocClassFruitEnvironment.this).AssociationTest.this.fruitPackage).getEClassifier("AC");
                    }
                    return null;
                }

                public List<EStructuralFeature> getMemberEnds(EClassifier associationClass) {
                    if (associationClass == ((AssocClassFruitEnvironment)AssocClassFruitEnvironment.this).AssociationTest.this.stem) {
                        return AssocClassFruitEnvironment.this.stemEnds;
                    }
                    if (associationClass.getName().equals("AC")) {
                        EClass ac = (EClass)associationClass;
                        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>(2);
                        result.add(ac.getEStructuralFeature("parentTree"));
                        result.add(ac.getEStructuralFeature("childTree"));
                        return result;
                    }
                    return Collections.emptyList();
                }

                public List<EStructuralFeature> getQualifiers(EStructuralFeature property) {
                    if (property == ((AssocClassFruitEnvironment)AssocClassFruitEnvironment.this).AssociationTest.this.forest_trees) {
                        return AssocClassFruitEnvironment.this.qualifiers;
                    }
                    return Collections.emptyList();
                }
            };
        }
    }

    private class AssocClassFruitEnvironmentFactory
    extends EcoreEnvironmentFactory {
        public AssocClassFruitEnvironmentFactory() {
            super(resourceSet.getPackageRegistry());
        }

        public EcoreEnvironment createEnvironment() {
            return new AssocClassFruitEnvironment(this);
        }

        public EcoreEnvironment createEnvironment(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent) {
            return new AssocClassFruitEnvironment(parent);
        }
    }
}

