/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.tests.EcoreTestReflection;
import org.eclipse.ocl.tests.GenericEvaluationNumberOperationTest;

public class EvaluationNumberOperationTest
extends GenericEvaluationNumberOperationTest<EObject, EPackage, EClassifier, EClassifier, EClass, EDataType, EClassifier, EEnum, EOperation, EParameter, EStructuralFeature, EAttribute, EReference, EEnumLiteral, EObject, CallOperationAction, SendSignalAction, Constraint> {
    public EcoreTestReflection getStaticReflection() {
        return EcoreTestReflection.INSTANCE;
    }

    public void testNumberOclAsType() {
        this.assertResult(3, "3.oclAsType(Integer)");
        this.assertResult(3.0, "3.oclAsType(Real)");
        this.assertResultInvalid("3.oclAsType(String)");
        this.assertResult(3, "3.oclAsType(OclAny)");
        this.assertResultInvalid("3.oclAsType(OclVoid)");
        this.assertResultInvalid("3.oclAsType(OclInvalid)");
        this.assertResultInvalid("(3.0).oclAsType(Integer)");
        this.assertResult(3.0, "(3.0).oclAsType(Real)");
        this.assertResultInvalid("(3.0).oclAsType(String)");
        this.assertResult(3.0, "(3.0).oclAsType(OclAny)");
        this.assertResultInvalid("(3.0).oclAsType(OclVoid)");
        this.assertResultInvalid("(3.0).oclAsType(OclInvalid)");
    }

    public void testNumberOclIsKindOf() {
        this.assertResultTrue("3.oclIsKindOf(Integer)");
        this.assertResultTrue("3.oclIsKindOf(Real)");
        this.assertResultFalse("3.oclIsKindOf(String)");
        this.assertResultTrue("3.oclIsKindOf(OclAny)");
        this.assertResultFalse("3.oclIsKindOf(OclVoid)");
        this.assertResultFalse("3.oclIsKindOf(OclInvalid)");
        this.assertResultFalse("(3.0).oclIsKindOf(Integer)");
        this.assertResultTrue("(3.0).oclIsKindOf(Real)");
        this.assertResultFalse("(3.0).oclIsKindOf(String)");
        this.assertResultTrue("(3.0).oclIsKindOf(OclAny)");
        this.assertResultFalse("(3.0).oclIsKindOf(OclVoid)");
        this.assertResultFalse("(3.0).oclIsKindOf(OclInvalid)");
    }

    public void testNumberOclIsTypeOf() {
        this.assertResultTrue("3.oclIsTypeOf(Integer)");
        this.assertResultFalse("3.oclIsTypeOf(Real)");
        this.assertResultFalse("3.oclIsTypeOf(String)");
        this.assertResultFalse("3.oclIsTypeOf(OclAny)");
        this.assertResultFalse("3.oclIsTypeOf(OclVoid)");
        this.assertResultFalse("3.oclIsTypeOf(OclInvalid)");
        this.assertResultFalse("(3.0).oclIsTypeOf(Integer)");
        this.assertResultTrue("(3.0).oclIsTypeOf(Real)");
        this.assertResultFalse("(3.0).oclIsTypeOf(String)");
        this.assertResultFalse("(3.0).oclIsTypeOf(OclAny)");
        this.assertResultFalse("(3.0).oclIsTypeOf(OclVoid)");
        this.assertResultFalse("(3.0).oclIsTypeOf(OclInvalid)");
    }

    public void testNumberToString() {
        super.testNumberToString();
        this.assertResult("6", "6.oclAsType(UnlimitedNatural).toString()");
    }

    public void testUnlimitedOclIsKindOf() {
        this.assertResultTrue("*.oclIsKindOf(Integer)");
        this.assertResultTrue("*.oclIsKindOf(Real)");
        this.assertResultTrue("*.oclIsKindOf(UnlimitedNatural)");
        this.assertResultFalse("*.oclIsKindOf(String)");
        this.assertResultTrue("*.oclIsKindOf(OclAny)");
        this.assertResultFalse("*.oclIsKindOf(OclVoid)");
        this.assertResultFalse("*.oclIsKindOf(OclInvalid)");
    }

    public void testUnlimitedToInteger() {
        super.testUnlimitedToInteger();
        this.assertResult(-1, "-1.oclAsType(UnlimitedNatural).toInteger()");
        this.assertResultInvalid("(-1).oclAsType(UnlimitedNatural).toInteger()");
        this.assertResult(4, "4.oclAsType(UnlimitedNatural).toInteger()");
    }
}

