/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.tests;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.tests.GenericTestSuite;

public abstract class GenericEvaluationTestSuite<E extends EObject, PK extends E, T extends E, C extends T, CLS extends C, DT extends C, PT extends C, ET extends DT, O extends E, PM extends E, P extends E, PA extends P, PR extends P, EL, S, COA, SSA, CT>
extends GenericTestSuite<E, PK, T, C, CLS, DT, PT, ET, O, PM, P, PA, PR, EL, S, COA, SSA, CT> {
    protected Object invalidObject;
    protected EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> visitor;

    protected void assertResultContainsAll(Collection<Object> expectedResult, String expression) {
        OCLExpression query = this.createQuery(this.getContext(), expression);
        Object result = this.visitor.visitExpression(query);
        GenericEvaluationTestSuite.assertTrue((boolean)expectedResult.getClass().isInstance(result));
        GenericEvaluationTestSuite.assertSame((Object)expectedResult.size(), (Object)((Collection)result).size());
        GenericEvaluationTestSuite.assertTrue((boolean)((Collection)result).containsAll(expectedResult));
    }

    protected CLS getContext() {
        return (CLS)this.getMetaclass(this.denormalize("%Package"));
    }

    protected void assertResultContainsAll(String expectedResultExpression, String expression) {
        OCLExpression expectedResultQuery = this.createQuery(this.getContext(), expectedResultExpression);
        Object result = this.visitor.visitExpression(expectedResultQuery);
        GenericEvaluationTestSuite.assertTrue((boolean)(result instanceof Collection));
        this.assertResultContainsAll((Collection)result, expression);
    }

    protected void assertResult(Object expectedResult, String expression) {
        OCLExpression query = this.createQuery(this.getContext(), expression);
        Object result = this.visitor.visitExpression(query);
        if (expectedResult instanceof Double && result instanceof Double) {
            GenericEvaluationTestSuite.assertEquals((double)((Double)expectedResult), (double)((Double)result), (double)0.001);
        } else if (expectedResult instanceof LinkedHashSet) {
            GenericEvaluationTestSuite.assertTrue((boolean)(result instanceof LinkedHashSet));
            GenericEvaluationTestSuite.assertSame((Object)((LinkedHashSet)result).size(), (Object)((LinkedHashSet)expectedResult).size());
            Iterator resultIterator = ((LinkedHashSet)result).iterator();
            Iterator expectedResultIterator = ((LinkedHashSet)expectedResult).iterator();
            while (resultIterator.hasNext()) {
                GenericEvaluationTestSuite.assertEquals(resultIterator.next(), expectedResultIterator.next());
            }
        } else if (expectedResult instanceof Set) {
            GenericEvaluationTestSuite.assertTrue((result instanceof Set && !(result instanceof LinkedHashSet) ? 1 : 0) != 0);
            GenericEvaluationTestSuite.assertEquals((Object)expectedResult, (Object)result);
        } else if (expectedResult instanceof Collection) {
            GenericEvaluationTestSuite.assertTrue((boolean)expectedResult.getClass().isInstance(result));
            GenericEvaluationTestSuite.assertEquals((Object)expectedResult, (Object)result);
        } else {
            GenericEvaluationTestSuite.assertEquals((Object)expectedResult, (Object)result);
        }
    }

    protected void assertResultTrue(String expression) {
        this.assertResult(Boolean.TRUE, expression);
    }

    protected void assertResultFalse(String expression) {
        this.assertResult(Boolean.FALSE, expression);
    }

    protected void assertResultInvalid(String expression) {
        this.assertResult(this.invalidObject, expression);
    }

    protected void assertExpressionResults(String expectedResultExpression, String expression) {
        OCLExpression expectedResultQuery = this.createQuery(this.getContext(), expectedResultExpression);
        Object result = this.visitor.visitExpression(expectedResultQuery);
        this.assertResult(result, expression);
    }

    @Override
    protected void setUp() {
        super.setUp();
        this.visitor = this.ocl.getEnvironment().getFactory().createEvaluationVisitor(this.ocl.getEnvironment(), this.ocl.getEvaluationEnvironment(), this.ocl.getExtentMap());
        this.invalidObject = this.ocl.getEnvironment().getOCLStandardLibrary().getInvalid();
    }
}

