/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.tests;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.lpg.AbstractBasicEnvironment;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.lpg.AbstractProblemHandler;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.parser.backtracking.OCLBacktrackingLexer;
import org.eclipse.ocl.parser.backtracking.OCLBacktrackingParser;
import org.eclipse.ocl.tests.GenericTestSuite;

public abstract class GenericParserBacktrackingTest<E extends EObject, PK extends E, T extends E, C extends T, CLS extends C, DT extends C, PT extends C, ET extends DT, O extends E, PM extends E, P extends E, PA extends P, PR extends P, EL, S, COA, SSA, CT>
extends GenericTestSuite<E, PK, T, C, CLS, DT, PT, ET, O, PM, P, PA, PR, EL, S, COA, SSA, CT> {
    public void test_reservedKeywordAsIdentifier() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: package endpackage", "\"<simpleName>\" expected instead of \"package\"");
    }

    public void test_reservedKeywordAsPropertyName() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: self.endif endpackage", "\"<simpleName>\" expected instead of \"endif\"");
    }

    public void test_reservedKeywordAsOperationName() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: self.else() endpackage", "\"<simpleName>\" expected instead of \"else\"");
    }

    public void test_reservedKeywordAsPathNamePrefix() {
        this.checkDocumentWithParseFailure("package ecore context if::xx inv: true endpackage", "\"<simpleName>\" expected instead of \"if\"");
    }

    public void test_reservedKeywordAsPathNameMidfix() {
        this.checkDocumentWithParseFailure("package ecore context xx::if::yy inv: true endpackage", "\"<simpleName>\" expected instead of \"if\"");
    }

    public void test_reservedKeywordAsPathNameSuffix() {
        this.checkDocumentWithParseFailure("package ecore context xx::if inv: true endpackage", "\"<simpleName>\" expected instead of \"if\"");
    }

    public void test_punctuationAsOperationName() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: self. .. () endpackage", "\"<simpleName>\" expected instead of \"..\"");
    }

    public void test_missingEndPackage() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: true", "\"endpackage\" expected after \"true\"");
    }

    public void test_ifMissingCondition() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: if then else false endif endpackage", "\"then <expr> else <expr>\" expected instead of \"endif\"");
    }

    public void test_ifMissingThen() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: if true true else false endif endpackage", "\"then <expr> else <expr> endif\" expected instead of \"true else false endif\"");
    }

    public void test_ifMissingThenExpression() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: if true then else false endif endpackage", "\"<simpleName>\" expected after \"then\"");
    }

    public void test_ifMissingElse() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: if true then true false endif endpackage", "\"else <expr> endif\" expected instead of \"false endif\"");
    }

    public void test_ifMissingElseExpression() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: if true then true else endif endpackage", "\"<simpleName>\" expected after \"else\"");
    }

    public void test_ifMissingEndif() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: if true then true else false endpackage", "\"endif\" expected after \"false\"");
    }

    private void checkDocumentWithParseFailure(String oclText, String failure) {
        Environment environment = this.ocl.getEnvironment();
        AbstractBasicEnvironment abstractBasicEnvironment = (AbstractBasicEnvironment)environment;
        OCLBacktrackingLexer lexer = new OCLBacktrackingLexer(environment, oclText.toCharArray());
        OCLBacktrackingParser parser = new OCLBacktrackingParser(lexer);
        parser.setDefaultRepairCount(-1);
        MyProblemHandler problemHandler = new MyProblemHandler((AbstractParser)parser, oclText, failure);
        abstractBasicEnvironment.setProblemHandler((ProblemHandler)problemHandler);
        try {
            lexer.lexer(parser.getIPrsStream());
            CSTNode cst = parser.parser();
            if (problemHandler.getErrors() != 1) {
                GenericParserBacktrackingTest.fail((String)("Expected failure '" + failure + "' not found in '" + oclText + "'"));
            }
            GenericParserBacktrackingTest.assertNotNull((Object)cst);
        }
        catch (Exception e) {
            GenericParserBacktrackingTest.assertEquals((String)failure, (String)e.getLocalizedMessage());
        }
    }

    private final class MyProblemHandler
    extends AbstractProblemHandler {
        protected final String source;
        protected final String failure;
        private int errors;

        private MyProblemHandler(AbstractParser parser, String source, String failure) {
            super(parser);
            this.errors = 0;
            this.source = source;
            this.failure = failure;
        }

        public int getErrors() {
            return this.errors;
        }

        public void handleProblem(ProblemHandler.Severity problemSeverity, ProblemHandler.Phase processingPhase, String problemMessage, String processingContext, int startOffset, int endOffset) {
            if (!this.failure.equals(problemMessage)) {
                GenericParserBacktrackingTest.fail((String)("Unexpected failure '" + problemMessage + "' in '" + this.source + "'"));
            }
            if (this.errors > 1) {
                GenericParserBacktrackingTest.fail((String)("Repeated failure '" + problemMessage + "' in '" + this.source + "'"));
            }
            ++this.errors;
        }
    }
}

