/*
 * Decompiled with CFR 0.152.
 */
package abapmapping.abapdictionary.util;

import abapmapping.abapdictionary.AbapPrimtiveType;
import abapmapping.abapdictionary.AbapStructureField;
import abapmapping.abapdictionary.AbapStructureType;
import abapmapping.abapdictionary.AbapType;
import abapmapping.abapdictionary.AbapdictionaryPackage;
import abapmapping.abapdictionary.Code;
import abapmapping.abapdictionary.CodeValue;
import abapmapping.abapdictionary.DataElement;
import abapmapping.abapdictionary.UnstructuredAbapType;
import abapmapping.abapdictionary.XsdType;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class AbapdictionaryValidator
extends EObjectValidator {
    public static final AbapdictionaryValidator INSTANCE = new AbapdictionaryValidator();
    public static final String DIAGNOSTIC_SOURCE = "abapmapping.abapdictionary";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected static final String CODE__TYPE_OF_VALUES_EQUALS_ABAP_TYPE__EEXPRESSION = "self.values->forAll(cv:CodeValue |\r\n      cv.type = self.abapType)";

    protected EPackage getEPackage() {
        return AbapdictionaryPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateXsdType((XsdType)value, diagnostics, context);
            }
            case 1: {
                return this.validateUnstructuredAbapType((UnstructuredAbapType)value, diagnostics, context);
            }
            case 2: {
                return this.validateCodeValue((CodeValue)value, diagnostics, context);
            }
            case 3: {
                return this.validateCode((Code)value, diagnostics, context);
            }
            case 4: {
                return this.validateDataElement((DataElement)value, diagnostics, context);
            }
            case 5: {
                return this.validateAbapType((AbapType)value, diagnostics, context);
            }
            case 6: {
                return this.validateAbapStructureType((AbapStructureType)value, diagnostics, context);
            }
            case 7: {
                return this.validateAbapStructureField((AbapStructureField)value, diagnostics, context);
            }
            case 8: {
                return this.validateAbapPrimtiveType((AbapPrimtiveType)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateXsdType(XsdType xsdType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(xsdType, diagnostics, context);
    }

    public boolean validateUnstructuredAbapType(UnstructuredAbapType unstructuredAbapType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(unstructuredAbapType, diagnostics, context);
    }

    public boolean validateCodeValue(CodeValue codeValue, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(codeValue, diagnostics, context);
    }

    public boolean validateCode(Code code, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(code, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(code, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(code, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(code, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(code, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(code, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(code, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(code, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(code, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCode_TypeOfValuesEqualsAbapType(code, diagnostics, context);
        }
        return result;
    }

    public boolean validateCode_TypeOfValuesEqualsAbapType(Code code, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(AbapdictionaryPackage.Literals.CODE, code, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "TypeOfValuesEqualsAbapType", CODE__TYPE_OF_VALUES_EQUALS_ABAP_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateDataElement(DataElement dataElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(dataElement, diagnostics, context);
    }

    public boolean validateAbapType(AbapType abapType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(abapType, diagnostics, context);
    }

    public boolean validateAbapStructureType(AbapStructureType abapStructureType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(abapStructureType, diagnostics, context);
    }

    public boolean validateAbapStructureField(AbapStructureField abapStructureField, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(abapStructureField, diagnostics, context);
    }

    public boolean validateAbapPrimtiveType(AbapPrimtiveType abapPrimtiveType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(abapPrimtiveType, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

