/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.framework;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.ocl.examples.eventmanager.framework.ListenerTypeEnum;
import org.eclipse.ocl.examples.eventmanager.framework.Registration;

public class RegistrationSet {
    private final WeakReference<? extends Adapter> _listener;
    private ListenerTypeEnum listenerType;
    private final Set<Registration> registrations;

    public RegistrationSet(WeakReference<? extends Adapter> listener, ListenerTypeEnum listenerType, Collection<Registration> registrations) {
        this._listener = listener;
        this.listenerType = listenerType;
        this.registrations = new HashSet<Registration>();
        for (Registration r : registrations) {
            this.registrations.add(r);
            r.addRegistrationSet(this);
        }
    }

    WeakReference<? extends Adapter> getListener() {
        return this._listener;
    }

    public ListenerTypeEnum getListenerType() {
        return this.listenerType;
    }

    Set<Registration> getRegistrations() {
        return Collections.unmodifiableSet(this.registrations);
    }
}

