/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.tests;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.tests.GenericEvaluationTestSuite;

public abstract class GenericEvaluationBooleanOperationTest<E extends EObject, PK extends E, T extends E, C extends T, CLS extends C, DT extends C, PT extends C, ET extends DT, O extends E, PM extends E, P extends E, PA extends P, PR extends P, EL, S, COA, SSA, CT>
extends GenericEvaluationTestSuite<E, PK, T, C, CLS, DT, PT, ET, O, PM, P, PA, PR, EL, S, COA, SSA, CT> {
    public void testBooleanAnd() {
        this.assertResultFalse("false and false");
        this.assertResultFalse("false and true");
        this.assertResultFalse("true and false");
        this.assertResultTrue("true and true");
    }

    public void testBooleanAndInvalid() {
        this.assertResultFalse("let b : Boolean = invalid in false and b");
        this.assertResultInvalid("let b : Boolean = invalid in true and b");
        this.assertResultFalse("let a : Boolean = invalid in a and false");
        this.assertResultInvalid("let a : Boolean = invalid in a and true");
        this.assertResultInvalid("let a : Boolean = invalid, b : Boolean = invalid in a and b");
    }

    public void testBooleanAndNull() {
        this.assertResultFalse("let b : Boolean = null in false and b");
        this.assertResultInvalid("let b : Boolean = null in true and b");
        this.assertResultFalse("let a : Boolean = null in a and false");
        this.assertResultInvalid("let a : Boolean = null in a and true");
        this.assertResultInvalid("let a : Boolean = null, b : Boolean = null in a and b");
    }

    public void testBooleanEqual() {
        this.assertResultFalse("true = false");
        this.assertResultTrue("true = true");
        this.assertResultTrue("false = false");
    }

    public void testBooleanEqualInvalid() {
        this.assertResultInvalid("let b : Boolean = invalid in b = true");
        this.assertResultInvalid("let b : Boolean = invalid in false = b");
        this.assertResultInvalid("let b1 : Boolean = invalid, b2 : Boolean = invalid in b1 = b2");
    }

    public void testBooleanEqualNull() {
        this.assertResultFalse("let b : Boolean = null in b = true");
        this.assertResultFalse("let b : Boolean = null in false = b");
        this.assertResultTrue("let b1 : Boolean = null, b2 : Boolean = null in b1 = b2");
    }

    public void testBooleanImplies() {
        this.assertResultTrue("false implies false");
        this.assertResultTrue("false implies true");
        this.assertResultFalse("true implies false");
        this.assertResultTrue("true implies true");
    }

    public void testBooleanImpliesInvalid() {
        this.assertResultTrue("let b : Boolean = invalid in false implies b");
        this.assertResultInvalid("let b : Boolean = invalid in true implies b");
        this.assertResultInvalid("let a : Boolean = invalid in a implies false");
        this.assertResultTrue("let a : Boolean = invalid in a implies true");
        this.assertResultInvalid("let a : Boolean = invalid, b : Boolean = invalid in a implies b");
    }

    public void testBooleanImpliesNull() {
        this.assertResultTrue("let b : Boolean = null in false implies b");
        this.assertResultInvalid("let b : Boolean = null in true implies b");
        this.assertResultInvalid("let a : Boolean = null in a implies false");
        this.assertResultTrue("let a : Boolean = null in a implies true");
        this.assertResultInvalid("let a : Boolean = null, b : Boolean = null in a implies b");
    }

    public void testBooleanNot() {
        this.assertResultTrue("not false");
        this.assertResultFalse("not true");
    }

    public void testBooleanNotEqual() {
        this.assertResultTrue("true <> false");
        this.assertResultFalse("true <> true");
        this.assertResultFalse("false <> false");
    }

    public void testBooleanNotEqualInvalid() {
        this.assertResultInvalid("let b : Boolean = invalid in b <> true");
        this.assertResultInvalid("let b : Boolean = invalid in false <> b");
        this.assertResultInvalid("let b1 : Boolean = invalid, b2 : Boolean = invalid in b1 <> b2");
    }

    public void testBooleanNotEqualNull() {
        this.assertResultTrue("let b : Boolean = null in b <> true");
        this.assertResultTrue("let b : Boolean = null in false <> b");
        this.assertResultFalse("let b1 : Boolean = null, b2 : Boolean = null in b1 <> b2");
    }

    public void testBooleanNotInvalid() {
        this.assertResultInvalid("let a : Boolean = invalid in not a");
    }

    public void testBooleanNotNull() {
        this.assertResultInvalid("let a : Boolean = null in not a");
    }

    public void testBooleanOclAsType() {
        this.assertResultInvalid("true.oclAsType(Integer)");
        this.assertResultInvalid("true.oclAsType(String)");
        this.assertResultTrue("true.oclAsType(Boolean)");
        this.assertResultTrue("true.oclAsType(OclAny)");
        this.assertResultInvalid("true.oclAsType(OclVoid)");
        this.assertResultInvalid("true.oclAsType(OclInvalid)");
    }

    public void testBooleanOclIsInvalid() {
        this.assertResultFalse("true.oclIsInvalid()");
        this.assertResultFalse("false.oclIsInvalid()");
    }

    public void testBooleanOclIsUndefined() {
        this.assertResultFalse("true.oclIsUndefined()");
        this.assertResultFalse("false.oclIsUndefined()");
    }

    public void testBooleanOr() {
        this.assertResultFalse("false or false");
        this.assertResultTrue("false or true");
        this.assertResultTrue("true or false");
        this.assertResultTrue("true or true");
    }

    public void testBooleanOrInvalid() {
        this.assertResultInvalid("let b : Boolean = invalid in false or b");
        this.assertResultTrue("let b : Boolean = invalid in true or b");
        this.assertResultInvalid("let a : Boolean = invalid in a or false");
        this.assertResultTrue("let a : Boolean = invalid in a or true");
        this.assertResultInvalid("let a : Boolean = invalid, b : Boolean = invalid in a or b");
    }

    public void testBooleanOrNull() {
        this.assertResultInvalid("let b : Boolean = null in false or b");
        this.assertResultTrue("let b : Boolean = null in true or b");
        this.assertResultInvalid("let a : Boolean = null in a or false");
        this.assertResultTrue("let a : Boolean = null in a or true");
        this.assertResultInvalid("let a : Boolean = null, b : Boolean = null in a or b");
    }

    public void testBooleanToString() {
        this.assertResult("false", "false.toString()");
        this.assertResult("true", "true.toString()");
        this.assertResult("true", "(not false).toString()");
    }

    public void testBooleanXor() {
        this.assertResultFalse("false xor false");
        this.assertResultTrue("false xor true");
        this.assertResultTrue("true xor false");
        this.assertResultFalse("true xor true");
    }

    public void testBooleanXorInvalid() {
        this.assertResultInvalid("let b : Boolean = invalid in false xor b");
        this.assertResultInvalid("let b : Boolean = invalid in true xor b");
        this.assertResultInvalid("let a : Boolean = invalid in a xor false");
        this.assertResultInvalid("let a : Boolean = invalid in a xor true");
        this.assertResultInvalid("let a : Boolean = invalid, b : Boolean = invalid in a xor b");
    }

    public void testBooleanXorNull() {
        this.assertResultInvalid("let b : Boolean = null in false xor b");
        this.assertResultInvalid("let b : Boolean = null in true xor b");
        this.assertResultInvalid("let a : Boolean = null in a xor false");
        this.assertResultInvalid("let a : Boolean = null in a xor true");
        this.assertResultInvalid("let a : Boolean = null, b : Boolean = null in a xor b");
    }
}

