/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.tests.GenericFruitTestSuite;
import org.eclipse.ocl.tests.GenericTestSuite;
import org.eclipse.ocl.uml.UMLPackage;
import org.eclipse.ocl.uml.tests.AssociationTest;
import org.eclipse.ocl.uml.tests.BasicOCLTest;
import org.eclipse.ocl.uml.tests.CollectionsTest;
import org.eclipse.ocl.uml.tests.ComparisonTest;
import org.eclipse.ocl.uml.tests.DefExpressionTest;
import org.eclipse.ocl.uml.tests.EvaluationBooleanOperationTest;
import org.eclipse.ocl.uml.tests.EvaluationCollectionOperationTest;
import org.eclipse.ocl.uml.tests.EvaluationHaltedTest;
import org.eclipse.ocl.uml.tests.EvaluationNumberOperationTest;
import org.eclipse.ocl.uml.tests.EvaluationOclAnyOperationTest;
import org.eclipse.ocl.uml.tests.EvaluationStringOperationTest;
import org.eclipse.ocl.uml.tests.ExpressionsValidatorTest;
import org.eclipse.ocl.uml.tests.FeatureRedefinitionTest;
import org.eclipse.ocl.uml.tests.InitOrDerExpressionTest;
import org.eclipse.ocl.uml.tests.InvariantConstraintsTest;
import org.eclipse.ocl.uml.tests.IteratorsTest;
import org.eclipse.ocl.uml.tests.KeywordsTest;
import org.eclipse.ocl.uml.tests.LocationInformationTest;
import org.eclipse.ocl.uml.tests.MessagesTest;
import org.eclipse.ocl.uml.tests.OCLDocumentTest;
import org.eclipse.ocl.uml.tests.OperationConstraintsTest;
import org.eclipse.ocl.uml.tests.ParserBacktrackingTest;
import org.eclipse.ocl.uml.tests.PrecedenceTest;
import org.eclipse.ocl.uml.tests.PrimitiveTypesTest;
import org.eclipse.ocl.uml.tests.ProfilesTest;
import org.eclipse.ocl.uml.tests.RegressionTest;
import org.eclipse.ocl.uml.tests.SerializationTest;
import org.eclipse.ocl.uml.tests.StatesTest;
import org.eclipse.ocl.uml.tests.TuplesTest;
import org.eclipse.ocl.uml.tests.TypesValidatorTest;
import org.eclipse.ocl.uml.tests.UMLEnvironmentTest;
import org.eclipse.ocl.uml.tests.UMLTest;
import org.eclipse.ocl.uml.tests.UMLTestReflection;
import org.eclipse.ocl.uml.tests.UtilitiesTest;
import org.eclipse.ocl.uml.tests.ValidationTest;
import org.eclipse.ocl.uml.util.OCLUMLUtil;
import org.eclipse.uml2.types.TypesPackage;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.SendSignalAction;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public abstract class AbstractTestSuite
extends GenericFruitTestSuite<EObject, Package, Type, Classifier, Class, DataType, PrimitiveType, Enumeration, Operation, Parameter, Property, Property, Property, EnumerationLiteral, State, CallOperationAction, SendSignalAction, Constraint> {
    protected static final ExecutorService exec = Executors.newSingleThreadExecutor();
    private static TypesPackage umltypes = TypesPackage.eINSTANCE;
    protected static UMLPackage ocltypes = UMLPackage.eINSTANCE;
    protected static org.eclipse.uml2.uml.UMLPackage uml = org.eclipse.uml2.uml.UMLPackage.eINSTANCE;
    protected static UMLFactory umlf = uml.getUMLFactory();
    protected EPackage fruitEPackage;
    protected EFactory fruitEFactory;
    protected Class fruit;
    protected Operation fruit_ripen;
    protected Operation fruit_preferredColor;
    protected Operation fruit_newFruit;
    protected Operation fruit_setColor;
    protected Property fruit_color;
    protected Property fruit_friends;
    protected Class apple;
    protected Property apple_label;
    protected Property apple_tree;
    protected Property apple_appleFriends;
    protected Operation apple_labelOper;
    protected Operation apple_newApple;
    protected AssociationClass stem;
    protected Property stem_length;
    protected Class tree;
    protected Property tree_apples;
    protected Property tree_height;
    protected Enumeration color;
    protected EnumerationLiteral color_black;
    protected EnumerationLiteral color_red;
    protected EnumerationLiteral color_green;
    protected EnumerationLiteral color_yellow;
    protected EnumerationLiteral color_orange;
    protected EnumerationLiteral color_brown;
    protected EnumerationLiteral color_pink;
    protected Class forest;
    protected Property forest_trees;
    protected Property forest_trees_zoneQualifier;
    protected Property forest_trees_indexQualifier;
    protected Property forest_area;
    protected Association a_forest_tree;
    protected Property a_forest_tree_forest;
    protected Class util;
    protected Property util_orderedSet;
    protected Property util_set;
    protected Property util_bag;
    protected Property util_sequence;
    protected Operation util_processOrderedSet;
    protected Operation util_processSet;
    protected Operation util_processBag;
    protected Operation util_processSequence;

    public static void suite(GenericTestSuite.CheckedTestSuite result) {
        result.createTestSuite(BasicOCLTest.class, "Basic Tests");
        result.createTestSuite(EvaluationBooleanOperationTest.class, "Boolean operations Tests");
        result.createTestSuite(EvaluationCollectionOperationTest.class, "Collection operations Tests");
        result.createTestSuite(EvaluationNumberOperationTest.class, "Numeric operations Tests");
        result.createTestSuite(EvaluationOclAnyOperationTest.class, "OclAny operations Tests");
        result.createTestSuite(EvaluationStringOperationTest.class, "String operations Tests");
        result.createTestSuite(PrimitiveTypesTest.class, "Primitive Type Tests");
        result.createTestSuite(ComparisonTest.class, "Comparison/Ordering Tests");
        result.createTestSuite(CollectionsTest.class, "Collection Type Tests");
        result.createTestSuite(AssociationTest.class, "Association Tests");
        result.createTestSuite(IteratorsTest.class, "Iterator Tests");
        result.createTestSuite(KeywordsTest.class, "LPG and OCL Keyword Tests");
        result.createTestSuite(PrecedenceTest.class, "Operator Precedence Tests");
        result.createTestSuite(TuplesTest.class, "Tuple Tests");
        result.createTestSuite(StatesTest.class, "State Expression Tests");
        result.createTestSuite(MessagesTest.class, "Message Expression Tests");
        result.createTestSuite(ProfilesTest.class, "Profile Constraint Tests");
        result.createTestSuite(InvariantConstraintsTest.class, "Invariant Constraints");
        result.createTestSuite(OperationConstraintsTest.class, "Operation Constraints");
        result.createTestSuite(LocationInformationTest.class, "Location Information Tests");
        result.createTestSuite(FeatureRedefinitionTest.class, "Feature redefinition tests");
        result.createTestSuite(DefExpressionTest.class, "Def Expression Tests");
        result.createTestSuite(InitOrDerExpressionTest.class, "Initial and Derivation Expression Tests");
        result.createTestSuite(UMLTest.class, "UML-Specific Tests");
        result.createTestSuite(OCLDocumentTest.class, "OCL Document Parsing Tests");
        result.createTestSuite(UtilitiesTest.class, "OCLUMLUtil Utility Class Tests");
        result.createTestSuite(UMLEnvironmentTest.class, "UML Environment Tests");
        result.addTestSuite(org.eclipse.ocl.uml.helper.tests.AbstractTestSuite.suite());
        result.createTestSuite(RegressionTest.class, "Regression Tests");
        result.createTestSuite(ValidationTest.class, "Expression Validation Tests");
        result.createTestSuite(TypesValidatorTest.class, "Types Validator Tests");
        result.createTestSuite(ExpressionsValidatorTest.class, "Expressions Validator Tests");
        result.createTestSuite(SerializationTest.class, "Serialization Tests");
        result.createTestSuite(EvaluationHaltedTest.class, "UML Halted Evaluation Tests");
    }

    public static void suiteBacktracking(GenericTestSuite.CheckedTestSuite result) {
        result.createTestSuite(ParserBacktrackingTest.class, "Parser Backtracking Tests");
    }

    public UMLTestReflection.Static getStaticReflection() {
        return UMLTestReflection.Static.INSTANCE;
    }

    protected void tearDownField(Field field) throws IllegalAccessException {
        field.set((Object)this, null);
    }

    protected final void tearDownStatic(java.lang.Class<?> aClass, Field field) {
        if (aClass != AbstractTestSuite.class) {
            super.tearDownStatic(aClass, field);
        }
    }

    protected void tearDownUsing(Method method) throws IllegalAccessException, InvocationTargetException {
        method.invoke((Object)this, new Object[0]);
    }

    public void tearDown_fruitEPackage() {
        resourceSet.getPackageRegistry().remove((Object)this.fruitEPackage.getNsURI());
        this.fruitEPackage = null;
    }

    protected final String getStereotype(Constraint constraint) {
        EList keywords = constraint.getKeywords();
        return keywords.isEmpty() ? null : (String)keywords.get(0);
    }

    protected InstanceSpecification instantiate(Package pkg, Classifier classifier) {
        InstanceSpecification result = (InstanceSpecification)pkg.createPackagedElement(null, uml.getInstanceSpecification());
        if (classifier != null) {
            result.getClassifiers().add((Object)classifier);
        }
        return result;
    }

    protected Slot setValue(InstanceSpecification instance, Property property, Object value) {
        Slot result = null;
        for (Slot slot : instance.getSlots()) {
            if (slot.getDefiningFeature() != property) continue;
            result = slot;
            slot.getValues().clear();
            break;
        }
        if (result == null) {
            result = instance.createSlot();
            result.setDefiningFeature((StructuralFeature)property);
        }
        if (value instanceof Collection) {
            for (Object e : (Collection)value) {
                this.addValue(result, e);
            }
        } else {
            this.addValue(result, value);
        }
        return result;
    }

    protected void clearValue(InstanceSpecification instance, Property property) {
        for (Slot slot : instance.getSlots()) {
            if (slot.getDefiningFeature() != property) continue;
            instance.getSlots().remove((Object)slot);
            break;
        }
    }

    protected Slot addValue(InstanceSpecification instance, Property property, Object value) {
        Slot result = null;
        for (Slot slot : instance.getSlots()) {
            if (slot.getDefiningFeature() != property) continue;
            result = slot;
            break;
        }
        if (result == null) {
            result = this.setValue(instance, property, value);
        } else {
            this.addValue(result, value);
        }
        return result;
    }

    protected ValueSpecification addValue(Slot slot, Object value) {
        InstanceValue result;
        if (value instanceof InstanceSpecification) {
            InstanceValue valueSpec = (InstanceValue)slot.createValue(null, null, uml.getInstanceValue());
            valueSpec.setInstance((InstanceSpecification)value);
            result = valueSpec;
        } else if (value instanceof String) {
            LiteralString valueSpec = (LiteralString)slot.createValue(null, null, uml.getLiteralString());
            valueSpec.setValue((String)value);
            result = valueSpec;
        } else if (value instanceof Integer) {
            if (slot.getDefiningFeature().getType() == this.getUMLUnlimitedNatural()) {
                LiteralUnlimitedNatural valueSpec = (LiteralUnlimitedNatural)slot.createValue(null, null, uml.getLiteralUnlimitedNatural());
                valueSpec.setValue(((Integer)value).intValue());
                result = valueSpec;
            } else {
                LiteralInteger valueSpec = (LiteralInteger)slot.createValue(null, null, uml.getLiteralInteger());
                valueSpec.setValue(((Integer)value).intValue());
                result = valueSpec;
            }
        } else if (value instanceof Boolean) {
            LiteralBoolean valueSpec = (LiteralBoolean)slot.createValue(null, null, uml.getLiteralBoolean());
            valueSpec.setValue(((Boolean)value).booleanValue());
            result = valueSpec;
        } else if (value == null) {
            LiteralNull valueSpec = (LiteralNull)slot.createValue(null, null, uml.getLiteralNull());
            result = valueSpec;
        } else {
            throw new IllegalArgumentException("Unrecognized slot value: " + value);
        }
        return result;
    }

    protected Object getValue(InstanceSpecification owner, Property property) {
        for (Slot slot : owner.getSlots()) {
            if (slot.getDefiningFeature() != property) continue;
            EList values = slot.getValues();
            if (!property.isMultivalued()) {
                return values.isEmpty() ? null : this.convert((ValueSpecification)values.get(0));
            }
            BasicEList.FastCompare result = new BasicEList.FastCompare(values.size());
            for (ValueSpecification value : values) {
                result.add(this.convert(value));
            }
            return result;
        }
        AbstractTestSuite.fail((String)("No such property value: " + property.getName()));
        return null;
    }

    protected Object convert(ValueSpecification value) {
        Object result;
        if (value instanceof InstanceValue) {
            result = ((InstanceValue)value).getInstance();
        } else if (value instanceof LiteralString) {
            result = ((LiteralString)value).stringValue();
        } else if (value instanceof LiteralInteger) {
            result = ((LiteralInteger)value).integerValue();
        } else if (value instanceof LiteralUnlimitedNatural) {
            result = ((LiteralUnlimitedNatural)value).integerValue();
        } else if (value instanceof LiteralBoolean) {
            result = ((LiteralBoolean)value).booleanValue();
        } else if (value instanceof LiteralNull) {
            result = null;
        } else {
            throw new IllegalArgumentException("Unrecognized slot value: " + value);
        }
        return result;
    }

    protected InstanceSpecification link(Package pkg, InstanceSpecification instance1, Property end1, InstanceSpecification instance2, Property end2, Association assoc) {
        InstanceSpecification result = this.instantiate(pkg, (Classifier)assoc);
        this.setValue(result, end1, instance2);
        if (end1.getOwningAssociation() == null) {
            this.addValue(instance1, end1, instance2);
        }
        this.setValue(result, end2, instance1);
        if (end2.getOwningAssociation() == null) {
            this.addValue(instance2, end2, instance1);
        }
        return result;
    }

    protected InstanceSpecification link(Package pkg, InstanceSpecification instance1, Property end1, Object[] qualifierValues, InstanceSpecification instance2, Property end2, Association assoc) {
        InstanceSpecification result = this.link(pkg, instance1, end1, instance2, end2, assoc);
        EList qualifiers = end1.getQualifiers();
        int count = qualifiers.size();
        int i = 0;
        while (i < count) {
            this.setValue(result, (Property)qualifiers.get(i), qualifierValues[i]);
            ++i;
        }
        return result;
    }

    protected void unload(EObject eObject) {
        eObject.eAdapters().clear();
        TreeIterator iter = eObject.eAllContents();
        while (iter.hasNext()) {
            ((EObject)iter.next()).eAdapters().clear();
        }
    }

    protected void unload(Collection<? extends EObject> eObjects) {
        for (EObject eObject : eObjects) {
            this.unload(eObject);
        }
    }

    protected void initFruitPackage() {
        URI uri = this.getTestModelURI("/model/OCLTest.uml");
        Resource res = resourceSet.getResource(uri, true);
        this.fruitPackage = (Package)res.getContents().get(0);
        this.fruit = (Class)((Package)this.fruitPackage).getOwnedType("Fruit");
        this.fruit_ripen = this.fruit.getOwnedOperation("ripen", null, null);
        this.fruit_preferredColor = this.fruit.getOwnedOperation("preferredColor", null, null);
        this.fruit_newFruit = this.fruit.getOwnedOperation("newFruit", null, null);
        this.fruit_setColor = this.fruit.getOwnedOperation("setColor", null, null);
        this.fruit_color = this.fruit.getOwnedAttribute("color", null);
        this.fruit_friends = this.fruit.getOwnedAttribute("friends", null);
        this.apple = (Class)((Package)this.fruitPackage).getOwnedType("Apple");
        this.apple_label = this.apple.getOwnedAttribute("label", null);
        this.apple_tree = this.apple.getOwnedAttribute("tree", null);
        this.apple_appleFriends = this.apple.getOwnedAttribute("appleFriends", null);
        this.apple_labelOper = this.apple.getOwnedOperation("label", null, null);
        this.apple_newApple = this.apple.getOwnedOperation("newApple", null, null);
        this.stem = (AssociationClass)((Package)this.fruitPackage).getOwnedType("Stem");
        this.stem_length = this.stem.getOwnedAttribute("length", null);
        this.tree = (Class)((Package)this.fruitPackage).getOwnedType("Tree");
        this.tree_apples = this.tree.getOwnedAttribute("apples", null);
        this.tree_height = this.tree.getOwnedAttribute("height", null);
        this.color = (Enumeration)((Package)this.fruitPackage).getOwnedType("Color");
        this.color_black = this.color.getOwnedLiteral("black");
        this.color_red = this.color.getOwnedLiteral("red");
        this.color_green = this.color.getOwnedLiteral("green");
        this.color_yellow = this.color.getOwnedLiteral("yellow");
        this.color_orange = this.color.getOwnedLiteral("orange");
        this.color_brown = this.color.getOwnedLiteral("brown");
        this.color_pink = this.color.getOwnedLiteral("pink");
        this.forest = (Class)((Package)this.fruitPackage).getOwnedType("Forest");
        this.forest_trees = this.forest.getOwnedAttribute("trees", null);
        this.forest_trees_zoneQualifier = this.forest_trees.getQualifier("zone", null);
        this.forest_trees_indexQualifier = this.forest_trees.getQualifier("index", null);
        this.forest_area = this.forest.getOwnedAttribute("area", null);
        this.a_forest_tree = (Association)((Package)this.fruitPackage).getOwnedType("A_Forest_Tree");
        this.a_forest_tree_forest = this.a_forest_tree.getOwnedEnd("forest", null);
        this.util = (Class)((Package)this.fruitPackage).getOwnedType("FruitUtil");
        this.util_orderedSet = this.util.getOwnedAttribute("orderedSet", null);
        this.util_set = this.util.getOwnedAttribute("set", null);
        this.util_bag = this.util.getOwnedAttribute("bag", null);
        this.util_sequence = this.util.getOwnedAttribute("sequence", null);
        this.util_processOrderedSet = this.util.getOwnedOperation("processOrderedSet", null, null);
        this.util_processSet = this.util.getOwnedOperation("processSet", null, null);
        this.util_processBag = this.util.getOwnedOperation("processBag", null, null);
        this.util_processSequence = this.util.getOwnedOperation("processSequence", null, null);
        this.fruitEPackage = (EPackage)UMLUtil.convertToEcore((Package)((Package)this.fruitPackage), null).iterator().next();
        resourceSet.getPackageRegistry().put((Object)this.fruitEPackage.getNsURI(), (Object)this.fruitEPackage);
        this.fruitEFactory = this.fruitEPackage.getEFactoryInstance();
        res.setTrackingModification(true);
        AbstractTestSuite.assertSame((Object)this.fruitPackage, (Object)OCLUMLUtil.findPackage(Collections.singletonList(((Package)this.fruitPackage).getName()), (ResourceSet)resourceSet));
    }
}

