/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.options.ProblemOption;
import org.eclipse.ocl.uml.CollectionType;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ComparisonTest
extends AbstractTestSuite {
    Package pkg;
    Class thingType;
    Property values;
    DataType valueType;
    Class numeroType;
    Property numeros;
    Property bdValue;
    Property biValue;
    EPackage epkg;
    EFactory efactory;
    EClass ethingType;
    EAttribute evalues;
    EDataType evalueType;
    EClass enumeroType;
    EReference enumeros;
    EAttribute ebdValue;
    EAttribute ebiValue;
    Class comparable;
    EObject thing;

    public void test_lessThan() {
        this.helper.setContext((Object)this.thingType);
        try {
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1 < 2"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "21 < 2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1 < 2.0"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "21 < 2.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1.0 < 2"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "21.0 < 2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1.0 < 2.0"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "21.0 < 2.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "'a' < 'b'"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "'ba' < 'b'"));
            this.thing.eSet((EStructuralFeature)this.ebdValue, (Object)new BigDecimal("1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue < 1.1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue < 2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue < 2.0"));
            this.thing.eSet((EStructuralFeature)this.ebdValue, (Object)new BigDecimal("1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue < 1.1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue < 2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue < 2.0"));
            this.thing.eSet((EStructuralFeature)this.ebdValue, (Object)new BigDecimal("1.1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue < 1.2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue < 2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue < 2.0"));
            this.thing.eSet((EStructuralFeature)this.ebiValue, (Object)new BigInteger("1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "biValue < 2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "biValue < 2.1"));
            List valuesList = (List)this.thing.eGet((EStructuralFeature)this.evalues);
            valuesList.add(new Value("a"));
            valuesList.add(new Value("b"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "values->at(1) < values->at(2)"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "values->at(2) < values->at(1)"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_lessThanOrEqual() {
        this.helper.setContext((Object)this.thingType);
        try {
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1 <= 2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1 <= 1"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "21 <= 2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1 <= 2.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1 <= 1.0"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "21 <= 2.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1.0 <= 2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1.0 <= 1"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "21.0 <= 2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1.0 <= 2.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1.0 <= 1.0"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "21.0 <= 2.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "'a' <= 'b'"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "'a' <= 'a'"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "'ba' <= 'b'"));
            this.thing.eSet((EStructuralFeature)this.ebdValue, (Object)new BigDecimal("1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue <= 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue <= 1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue <= 1.1"));
            this.thing.eSet((EStructuralFeature)this.ebdValue, (Object)new BigDecimal("1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue <= 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue <= 1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue <= 1.1"));
            this.thing.eSet((EStructuralFeature)this.ebdValue, (Object)new BigDecimal("1.1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue <= 1.1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue <= 2.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue <= 2"));
            this.thing.eSet((EStructuralFeature)this.ebiValue, (Object)new BigInteger("1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "biValue <= 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "biValue <= 1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "biValue <= 1.1"));
            List valuesList = (List)this.thing.eGet((EStructuralFeature)this.evalues);
            valuesList.add(new Value("a"));
            valuesList.add(new Value("b"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "values->at(1) <= values->at(2)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "values->at(1) <= values->at(1)"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "values->at(2) <= values->at(1)"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_greaterThan() {
        this.helper.setContext((Object)this.thingType);
        try {
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2 > 1"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "2 > 21"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2 > 1.0"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "2 > 21.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2.0 > 1"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "2.0 > 21"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2.0 > 1.0"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "2.0 > 21.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "'b' > 'a'"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "'a' > 'b'"));
            this.thing.eSet((EStructuralFeature)this.ebdValue, (Object)new BigDecimal("1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue > 0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue > 0.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue > 0.1"));
            this.thing.eSet((EStructuralFeature)this.ebdValue, (Object)new BigDecimal("1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue > 0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue > 0.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue > 0.1"));
            this.thing.eSet((EStructuralFeature)this.ebdValue, (Object)new BigDecimal("1.1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue > 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue > 1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue > 1.09"));
            this.thing.eSet((EStructuralFeature)this.ebiValue, (Object)new BigInteger("1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "biValue > 0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "biValue > 0.1"));
            List valuesList = (List)this.thing.eGet((EStructuralFeature)this.evalues);
            valuesList.add(new Value("b"));
            valuesList.add(new Value("a"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "values->at(1) > values->at(2)"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "values->at(2) > values->at(1)"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_greaterThanOrEqual() {
        this.helper.setContext((Object)this.thingType);
        try {
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2 >= 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2 >= 2"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "2 >= 21"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2 >= 1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2 >= 2.0"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "2 >= 21.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2.0 >= 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2.0 >= 2"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "2.0 >= 21"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2.0 >= 1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2.0 >= 2.0"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "2.0 >= 21.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "'b' >= 'a'"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "'b' >= 'b'"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "'a' >= 'b'"));
            this.thing.eSet((EStructuralFeature)this.ebdValue, (Object)new BigDecimal("1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue >= 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue >= 1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue >= 0.9"));
            this.thing.eSet((EStructuralFeature)this.ebdValue, (Object)new BigDecimal("1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue >= 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue >= 1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue >= 0.9"));
            this.thing.eSet((EStructuralFeature)this.ebdValue, (Object)new BigDecimal("1.1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue >= 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue >= 1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue >= 1.1"));
            this.thing.eSet((EStructuralFeature)this.ebiValue, (Object)new BigInteger("1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "biValue >= 0.9"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "biValue >= 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "biValue >= 1.0"));
            List valuesList = (List)this.thing.eGet((EStructuralFeature)this.evalues);
            valuesList.add(new Value("b"));
            valuesList.add(new Value("a"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "values->at(1) >= values->at(2)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "values->at(1) >= values->at(1)"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "values->at(2) >= values->at(1)"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_sortedBy() {
        this.helper.setContext((Object)this.thingType);
        try {
            List valuesList = (List)this.thing.eGet((EStructuralFeature)this.evalues);
            valuesList.add(new Value("b"));
            valuesList.add(new Value("c"));
            valuesList.add(new Value("a"));
            LinkedHashSet<Value> expected = new LinkedHashSet<Value>();
            expected.add((Value)valuesList.get(2));
            expected.add((Value)valuesList.get(0));
            expected.add((Value)valuesList.get(1));
            ComparisonTest.assertEquals(expected, (Object)this.evaluate(this.helper, this.thing, "values->sortedBy(e | e)"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_invalid_equality() {
        this.helper.setContext((Object)this.thingType);
        try {
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "OclInvalid = 'a'"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "OclInvalid <> 'a'"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "OclInvalid = OclInvalid"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "OclInvalid <> OclInvalid"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_void_equality() {
        this.helper.setContext((Object)this.thingType);
        try {
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "null = 'a'"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "null <> 'a'"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "null = null"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "null <> null"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_integerArithmetic() {
        this.helper.setContext((Object)this.thingType);
        try {
            ComparisonTest.assertEquals((Object)1, (Object)this.evaluate(this.helper, this.thing, "3 - 2"));
            ComparisonTest.assertEquals((Object)3, (Object)this.evaluate(this.helper, this.thing, "1 + 2"));
            ComparisonTest.assertEquals((Object)2.0, (Object)this.evaluate(this.helper, this.thing, "6 / 3"));
            ComparisonTest.assertEquals((Object)6, (Object)this.evaluate(this.helper, this.thing, "2 * 3"));
            ComparisonTest.assertEquals((Object)-1, (Object)this.evaluate(this.helper, this.thing, "- 1"));
            ComparisonTest.assertEquals((Object)3, (Object)this.evaluate(this.helper, this.thing, "(2 - 5).abs()"));
            ComparisonTest.assertEquals((Object)3, (Object)this.evaluate(this.helper, this.thing, "3.max(2)"));
            ComparisonTest.assertEquals((Object)2, (Object)this.evaluate(this.helper, this.thing, "3.min(2)"));
            ComparisonTest.assertEquals((Object)3, (Object)this.evaluate(this.helper, this.thing, "7.div(2)"));
            ComparisonTest.assertEquals((Object)1, (Object)this.evaluate(this.helper, this.thing, "7.mod(2)"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_realArithmetic() {
        this.helper.setContext((Object)this.thingType);
        try {
            ComparisonTest.assertEquals((Object)1.0, (Object)this.evaluate(this.helper, this.thing, "3.0 - 2.0"));
            ComparisonTest.assertEquals((Object)3.0, (Object)this.evaluate(this.helper, this.thing, "1.0 + 2.0"));
            ComparisonTest.assertEquals((Object)2.0, (Object)this.evaluate(this.helper, this.thing, "6.0 / 3.0"));
            ComparisonTest.assertEquals((Object)6.0, (Object)this.evaluate(this.helper, this.thing, "2.0 * 3.0"));
            ComparisonTest.assertEquals((Object)-1.0, (Object)this.evaluate(this.helper, this.thing, "- 1.0"));
            ComparisonTest.assertEquals((Object)3.0, (Object)this.evaluate(this.helper, this.thing, "(2.0 - 5.0).abs()"));
            ComparisonTest.assertEquals((Object)3.0, (Object)this.evaluate(this.helper, this.thing, "3.0.max(2.0)"));
            ComparisonTest.assertEquals((Object)2.0, (Object)this.evaluate(this.helper, this.thing, "3.0.min(2.0)"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_mixedArithmetic() {
        this.helper.setContext((Object)this.thingType);
        try {
            ComparisonTest.assertEquals((Object)1.0, (Object)this.evaluate(this.helper, this.thing, "3 - 2.0"));
            ComparisonTest.assertEquals((Object)3.0, (Object)this.evaluate(this.helper, this.thing, "1 + 2.0"));
            ComparisonTest.assertEquals((Object)2.0, (Object)this.evaluate(this.helper, this.thing, "6 / 3.0"));
            ComparisonTest.assertEquals((Object)6.0, (Object)this.evaluate(this.helper, this.thing, "2 * 3.0"));
            ComparisonTest.assertEquals((Object)3.0, (Object)this.evaluate(this.helper, this.thing, "3.max(2.0)"));
            ComparisonTest.assertEquals((Object)2.0, (Object)this.evaluate(this.helper, this.thing, "3.min(2.0)"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_dotNotationForSymbolicOperationNames() {
        ParsingOptions.setOption((Environment)this.helper.getEnvironment(), (Option)ProblemOption.CONCEPTUAL_OPERATION_NAME, (Object)ProblemHandler.Severity.OK);
        this.helper.setContext((Object)((Classifier)this.getUMLInteger()));
        Integer minusOne = -1;
        Integer one = 1;
        Integer two = 2;
        Double doubleTwo = 2.0;
        Integer three = 3;
        Integer six = 6;
        try {
            ComparisonTest.assertEquals((Object)one, (Object)this.evaluate(this.helper, one, "3.-(2)"));
            ComparisonTest.assertEquals((Object)three, (Object)this.evaluate(this.helper, one, "1.+(2)"));
            ComparisonTest.assertEquals((Object)doubleTwo, (Object)this.evaluate(this.helper, one, "6./(3)"));
            ComparisonTest.assertEquals((Object)six, (Object)this.evaluate(this.helper, one, "2.*(3)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, one, "1.<(2)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, one, "1.<=(2)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, one, "2.>=(1)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, one, "2.>(1)"));
            ComparisonTest.assertEquals((Object)one, (Object)this.evaluate(this.helper, three, "self.-(2)"));
            ComparisonTest.assertEquals((Object)three, (Object)this.evaluate(this.helper, one, "self.+(2)"));
            ComparisonTest.assertEquals((Object)doubleTwo, (Object)this.evaluate(this.helper, six, "self./(3)"));
            ComparisonTest.assertEquals((Object)six, (Object)this.evaluate(this.helper, two, "self.*(3)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, one, "self.<(2)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, one, "self.<=(2)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, two, "self.>=(1)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, two, "self.>(1)"));
            ComparisonTest.assertEquals((Object)minusOne, (Object)this.evaluate(this.helper, one, "-1"));
            ComparisonTest.assertEquals((Object)minusOne, (Object)this.evaluate(this.helper, one, "-self"));
            ComparisonTest.assertEquals((Object)minusOne, (Object)this.evaluate(this.helper, one, "self.\"-\"()"));
            ComparisonTest.assertEquals((Object)minusOne, (Object)this.evaluate(this.helper, one, "self.-()"));
            ComparisonTest.assertEquals((Object)one, (Object)this.evaluate(this.helper, one, "- self.\"-\"()"));
            ComparisonTest.assertEquals((Object)one, (Object)this.evaluate(this.helper, one, "- self.-()"));
            ComparisonTest.assertEquals((Object)one, (Object)this.evaluate(this.helper, one, "- -1"));
            ComparisonTest.assertEquals((Object)one, (Object)this.evaluate(this.helper, one, "- -self"));
            this.helper.setContext((Object)((Classifier)this.getUMLBoolean()));
            ComparisonTest.assertEquals((Object)Boolean.FALSE, (Object)this.evaluate(this.helper, Boolean.TRUE, "not self"));
            ComparisonTest.assertEquals((Object)Boolean.FALSE, (Object)this.evaluate(this.helper, Boolean.TRUE, "self.\"not\"()"));
            ComparisonTest.assertEquals((Object)Boolean.FALSE, (Object)this.evaluate(this.helper, Boolean.TRUE, "self.not()"));
            ComparisonTest.assertEquals((Object)Boolean.TRUE, (Object)this.evaluate(this.helper, Boolean.TRUE, "not not self"));
            ComparisonTest.assertEquals((Object)Boolean.TRUE, (Object)this.evaluate(this.helper, Boolean.TRUE, "not self.\"not\"()"));
            ComparisonTest.assertEquals((Object)Boolean.TRUE, (Object)this.evaluate(this.helper, Boolean.TRUE, "not self.not()"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
        ParsingOptions.setOption((Environment)this.helper.getEnvironment(), (Option)ProblemOption.CONCEPTUAL_OPERATION_NAME, (Object)ProblemHandler.Severity.ERROR);
        try {
            ComparisonTest.assertEquals((Object)one, (Object)this.evaluate(this.helper, one, "3.-(2)"));
            ComparisonTest.fail((String)"Missing exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void test_javaImplementationsOfInfixOperators() {
        this.helper.setContext((Object)this.thingType);
        Numero three = new Numero(3L);
        Numero four = new Numero(4L);
        Numero eight = new Numero(8L);
        Numero twelve = new Numero(12L);
        try {
            ComparisonTest.assertEquals((Object)((Object)four), (Object)this.evaluate(this.helper, this.thing, "numeros->at(1) - numeros->at(2)"));
            ComparisonTest.assertEquals((Object)((Object)eight), (Object)this.evaluate(this.helper, this.thing, "numeros->at(1) + numeros->at(2)"));
            ComparisonTest.assertEquals((Object)((Object)three), (Object)this.evaluate(this.helper, this.thing, "numeros->at(1) / numeros->at(2)"));
            ComparisonTest.assertEquals((Object)((Object)twelve), (Object)this.evaluate(this.helper, this.thing, "numeros->at(1) * numeros->at(2)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "numeros->at(2) < numeros->at(1)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "numeros->at(2) <= numeros->at(1)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "numeros->at(1) > numeros->at(2)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "numeros->at(1) >= numeros->at(2)"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_comparisonOfBooleanOperations_137487() {
        Class ctx = (Class)((Package)this.getUMLMetamodel()).getOwnedType("Class");
        this.helper.setContext((Object)ctx);
        try {
            ComparisonTest.assertTrue((boolean)this.check(this.helper, ctx, "self.conformsTo(self)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, ctx, "self.conformsTo(self) and true"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, ctx, "self.conformsTo(self) or false"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, ctx, "self.conformsTo(self) xor false"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, ctx, "self.conformsTo(self) implies true"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, ctx, "self.conformsTo(self) implies false"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, ctx, "self.conformsTo(self) = true"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, ctx, "self.conformsTo(self) <> false"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_enumerationLiteralEquality_137546() {
        EObject ctx = this.fruitEFactory.create((EClass)this.fruitEPackage.getEClassifier(this.apple.getName()));
        this.helper.setContext((Object)this.apple);
        EEnum ecolor = (EEnum)this.fruitEPackage.getEClassifier(this.color.getName());
        ctx.eSet(ctx.eClass().getEStructuralFeature(this.fruit_color.getName()), (Object)ecolor.getEEnumLiteral(this.color_green.getName()));
        try {
            ComparisonTest.assertTrue((boolean)this.check(this.helper, ctx, "ocltest::Color::green = self.color"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, ctx, "self.color = ocltest::Color::green"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_dataTypes_137158() {
        Package upackage = umlf.createPackage();
        upackage.setName("mypkg");
        Class uclass = upackage.createOwnedClass("B", false);
        DataType datatype = (DataType)this.pkg.createOwnedType("Thread", uml.getDataType());
        Operation operation = uclass.createOwnedOperation("f", null, null, (Type)datatype);
        operation.setIsQuery(true);
        this.helper.setContext((Object)uclass);
        try {
            OCLExpression expr = this.helper.createQuery("self.f()");
            Classifier type = (Classifier)expr.getType();
            ComparisonTest.assertSame((Object)datatype, (Object)type);
            operation.setUpper(-1);
            expr = this.helper.createQuery("self.f()");
            type = (Classifier)expr.getType();
            ComparisonTest.assertTrue((boolean)(type instanceof org.eclipse.ocl.types.CollectionType));
            type = (Classifier)((CollectionType)type).getElementType();
            ComparisonTest.assertSame((Object)datatype, (Object)type);
            operation.setUpper(1);
            operation.setType((Type)this.ocl.getEnvironment().getOCLStandardLibrary().getOclAny());
            expr = this.helper.createQuery("self.f()");
            type = (Classifier)expr.getType();
            ComparisonTest.assertSame((Object)this.getOCLStandardLibrary().getOclAny(), (Object)type);
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_supportForELongAttributes_198451() {
        this.helper.setContext((Object)this.thingType);
        long maxInt = Integer.MAX_VALUE;
        long maxIntMinusOne = 0x7FFFFFFEL;
        long maxIntSquared = 4611686014132420609L;
        double quotient = (double)maxIntSquared / (double)maxIntMinusOne;
        Numero maxIntN = new Numero(maxInt);
        Numero maxIntMinusOneN = new Numero(maxIntMinusOne);
        Numero maxIntSquaredN = new Numero(maxIntSquared);
        EList list = (EList)this.thing.eGet((EStructuralFeature)this.enumeros);
        list.clear();
        list.add((Object)maxIntN);
        list.add((Object)maxIntMinusOneN);
        list.add((Object)maxIntSquaredN);
        list.add((Object)new Numero(1L));
        try {
            ComparisonTest.assertEquals((Object)1, (Object)this.evaluate(this.helper, this.thing, "numeros->at(1).asLong() - numeros->at(2).asLong()"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "numeros->at(4).asLong() = 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "numeros->at(4).asLong() <> 2"));
            ComparisonTest.assertEquals((Object)quotient, (Object)this.evaluate(this.helper, this.thing, "numeros->at(3).asLong() / numeros->at(2).asLong()"));
            ComparisonTest.assertEquals((Object)((int)maxIntMinusOne), (Object)this.evaluate(this.helper, this.thing, String.format("(%d + %d).div(2) - 1", maxInt, maxInt)));
            ComparisonTest.assertEquals((Object)maxIntSquared, (Object)this.evaluate(this.helper, this.thing, String.format("%d * %d", maxInt, maxInt)));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_OclAny_equals_unrelatedArgumentTypes() {
        this.helper.setContext((Object)this.fruit);
        try {
            this.helper.createInvariant("not Apple.allInstances()->exists(a | a = self)");
            this.helper.createInvariant("not UML::Class.allInstances()->exists(c | c = self)");
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_OclAny_notEquals_unrelatedArgumentTypes() {
        this.helper.setContext((Object)this.fruit);
        try {
            this.helper.createInvariant("Apple.allInstances()->forAll(a | a <> self)");
            this.helper.createInvariant("UML::Class.allInstances()->forAll(c | c <> self)");
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_compareToOnlyUsedByJavaImplementation_212804() {
        this.helper.setContext((Object)this.comparable);
        try {
            this.helper.createInvariant("Comparable.allInstances()->forAll(c | self >= c)");
            ComparisonTest.fail((String)"Should not have parsed");
        }
        catch (ParserException e) {
            ComparisonTest.debugPrintln((String)("Got expected exception: " + e.getLocalizedMessage()));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Unexpected exception during parse: " + e.getLocalizedMessage()));
        }
    }

    protected void setUp() {
        super.setUp();
        this.pkg = umlf.createPackage();
        this.pkg.setName("pkg");
        this.valueType = this.pkg.createOwnedPrimitiveType("Value");
        this.valueType.createOwnedOperation("<", (EList)new BasicEList(Collections.singleton("v")), (EList)new BasicEList(Collections.singleton(this.valueType)), (Type)this.getUMLBoolean()).setIsQuery(true);
        this.valueType.createOwnedOperation("<=", (EList)new BasicEList(Collections.singleton("v")), (EList)new BasicEList(Collections.singleton(this.valueType)), (Type)this.getUMLBoolean()).setIsQuery(true);
        this.valueType.createOwnedOperation(">", (EList)new BasicEList(Collections.singleton("v")), (EList)new BasicEList(Collections.singleton(this.valueType)), (Type)this.getUMLBoolean()).setIsQuery(true);
        this.valueType.createOwnedOperation(">=", (EList)new BasicEList(Collections.singleton("v")), (EList)new BasicEList(Collections.singleton(this.valueType)), (Type)this.getUMLBoolean()).setIsQuery(true);
        this.thingType = this.pkg.createOwnedClass("Thing", false);
        this.values = this.thingType.createOwnedAttribute("values", (Type)this.valueType);
        this.values.setUpper(-1);
        this.values.setIsOrdered(true);
        this.values.setIsUnique(true);
        this.bdValue = this.thingType.createOwnedAttribute("bdValue", (Type)this.getEcoreBigDecimal());
        this.biValue = this.thingType.createOwnedAttribute("biValue", (Type)this.getEcoreBigInteger());
        this.numeroType = this.pkg.createOwnedClass("Numero", false);
        this.numeroType.createOwnedOperation("+", (EList)new BasicEList(Collections.singleton("n")), (EList)new BasicEList(Collections.singleton(this.numeroType)), (Type)this.numeroType).setIsQuery(true);
        this.numeroType.createOwnedOperation("-", (EList)new BasicEList(Collections.singleton("n")), (EList)new BasicEList(Collections.singleton(this.numeroType)), (Type)this.numeroType).setIsQuery(true);
        this.numeroType.createOwnedOperation("*", (EList)new BasicEList(Collections.singleton("n")), (EList)new BasicEList(Collections.singleton(this.numeroType)), (Type)this.numeroType).setIsQuery(true);
        this.numeroType.createOwnedOperation("/", (EList)new BasicEList(Collections.singleton("n")), (EList)new BasicEList(Collections.singleton(this.numeroType)), (Type)this.numeroType).setIsQuery(true);
        this.numeroType.createOwnedOperation("-", ECollections.emptyEList(), ECollections.emptyEList(), (Type)this.numeroType).setIsQuery(true);
        this.numeroType.createOwnedOperation("<", (EList)new BasicEList(Collections.singleton("n")), (EList)new BasicEList(Collections.singleton(this.numeroType)), (Type)this.getUMLBoolean()).setIsQuery(true);
        this.numeroType.createOwnedOperation("<=", (EList)new BasicEList(Collections.singleton("n")), (EList)new BasicEList(Collections.singleton(this.numeroType)), (Type)this.getUMLBoolean()).setIsQuery(true);
        this.numeroType.createOwnedOperation(">", (EList)new BasicEList(Collections.singleton("n")), (EList)new BasicEList(Collections.singleton(this.numeroType)), (Type)this.getUMLBoolean()).setIsQuery(true);
        this.numeroType.createOwnedOperation(">=", (EList)new BasicEList(Collections.singleton("n")), (EList)new BasicEList(Collections.singleton(this.numeroType)), (Type)this.getUMLBoolean()).setIsQuery(true);
        this.numeroType.createOwnedOperation("asLong", ECollections.emptyEList(), ECollections.emptyEList(), (Type)this.getEcoreLong()).setIsQuery(true);
        this.numeros = this.thingType.createOwnedAttribute("numeros", (Type)this.numeroType);
        this.numeros.setUpper(-1);
        this.numeros.setIsOrdered(true);
        this.numeros.setIsUnique(true);
        this.comparable = this.pkg.createOwnedClass("Comparable", true);
        this.comparable.createOwnedOperation("compareTo", (EList)new BasicEList(Collections.singleton("c")), (EList)new BasicEList(Collections.singleton(this.comparable)), (Type)this.getUMLInteger()).setIsQuery(true);
        this.epkg = (EPackage)UMLUtil.convertToEcore((Package)this.pkg, null).iterator().next();
        this.ethingType = (EClass)this.epkg.getEClassifier(this.thingType.getName());
        this.enumeros = (EReference)this.ethingType.getEStructuralFeature(this.numeros.getName());
        this.evalues = (EAttribute)this.ethingType.getEStructuralFeature(this.values.getName());
        this.ebdValue = (EAttribute)this.ethingType.getEStructuralFeature(this.bdValue.getName());
        this.ebiValue = (EAttribute)this.ethingType.getEStructuralFeature(this.biValue.getName());
        this.enumeroType = (EClass)this.epkg.getEClassifier(this.numeroType.getName());
        this.enumeroType.setInstanceClass(Numero.class);
        this.evalueType = (EDataType)this.epkg.getEClassifier(this.valueType.getName());
        this.evalueType.setInstanceClass(Value.class);
        this.efactory = this.epkg.getEFactoryInstance();
        this.thing = this.efactory.create(this.ethingType);
        EPackage.Registry.INSTANCE.put((Object)this.epkg.getNsURI(), (Object)this.epkg);
        EList list = (EList)this.thing.eGet((EStructuralFeature)this.enumeros);
        list.add((Object)new Numero(6L));
        list.add((Object)new Numero(2L));
    }

    public static class Numero
    extends EObjectImpl {
        private long value;

        Numero() {
        }

        Numero(long value) {
            this.value = value;
        }

        public Numero plus(Numero n) {
            return new Numero(this.value + n.value);
        }

        public Numero minus(Numero n) {
            return new Numero(this.value - n.value);
        }

        public Numero times(Numero n) {
            return new Numero(this.value * n.value);
        }

        public Numero divide(Numero n) {
            return new Numero(this.value / n.value);
        }

        public Numero minus() {
            return new Numero(-this.value);
        }

        public boolean lessThan(Numero n) {
            return this.value < n.value;
        }

        public boolean lessThanEqual(Numero n) {
            return this.value <= n.value;
        }

        public boolean greaterThan(Numero n) {
            return this.value > n.value;
        }

        public boolean greaterThanEqual(Numero n) {
            return this.value >= n.value;
        }

        public long asLong() {
            return this.value;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (int)this.value;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Numero other = (Numero)((Object)obj);
            return this.value == other.value;
        }

        public String toString() {
            return "Numero(" + this.value + ")";
        }
    }

    private static class Value
    implements Comparable<Value> {
        private final String value;

        Value(String value) {
            this.value = value;
        }

        @Override
        public int compareTo(Value arg0) {
            return this.value.compareTo(arg0.value);
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Value other = (Value)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

