/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.serializer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.serializer.SerializationBuilder;
import org.eclipse.ocl.examples.xtext.serializer.SerializationMetaData;
import org.eclipse.ocl.examples.xtext.serializer.SerializationRule;
import org.eclipse.ocl.examples.xtext.serializer.SerializationSegment;
import org.eclipse.ocl.examples.xtext.serializer.SerializationStep;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;
import org.eclipse.ocl.examples.xtext.serializer.UserElementSerializer;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.HiddenLeafNode;
import org.eclipse.xtext.nodemodel.impl.RootNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Strings;

public abstract class AbstractCommentSerializationSegment
extends SerializationSegment.AbstractSerializationSegment {
    protected @NonNull Comment createMultipleLineComment(@NonNull String prefix, @NonNull String suffix, @NonNull HiddenLeafNode node, @Nullable String midfix) {
        String text = node.getText().replace("\r", "");
        String trimmedText = text.trim();
        String contentString = trimmedText.substring(2, trimmedText.length());
        StringBuilder s = new StringBuilder();
        String[] strings = contentString.split("\n");
        int line = 0;
        while (line < strings.length) {
            String string = strings[line];
            if (line > 0) {
                s.append("\n");
            }
            if (line >= strings.length - 1 && (string = string.substring(0, string.length() - 2)).equals(" ")) {
                string = "";
            }
            if (line > 0 && string.startsWith(" *")) {
                s.append(string.substring(2));
            } else {
                s.append(string);
            }
            ++line;
        }
        String netString = s.toString();
        assert (netString != null);
        return new MultipleLineComment(node, prefix, netString, suffix, midfix);
    }

    protected @NonNull Comment createSingleLineComment(@NonNull String prefix, @NonNull HiddenLeafNode node) {
        assert (prefix != null);
        String text = node.getText().replace("\r", "");
        String trimmedText = text.trim();
        String contentString = trimmedText.substring(prefix.length());
        assert (contentString != null);
        return new SingleLineComment(node, prefix, contentString);
    }

    protected boolean endsinNewLine(@NonNull HiddenLeafNode node) {
        int length;
        String text = node.getText();
        int iFinish = length = text.length();
        while (iFinish > 0) {
            char c;
            if ((c = text.charAt(--iFinish)) == '\n') {
                return true;
            }
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return false;
    }

    protected INode getNode(int serializationStepIndex, @NonNull UserElementSerializer serializer) {
        SerializationRule serializationRule = serializer.getSerializationRule();
        @NonNull SerializationStep[] serializationSteps = serializationRule.getSerializationSteps();
        SerializationStep serializationStep = serializationSteps[serializationStepIndex];
        EObject eObject = serializer.getElement();
        ICompositeNode node = NodeModelUtils.getNode((EObject)eObject);
        if (node != null) {
            if (serializationStep.matches((INode)node, serializer)) {
                return node;
            }
            for (INode childNode : SerializationUtils.getChildren(node)) {
                if (!serializationStep.matches(childNode, serializer)) continue;
                return childNode;
            }
        }
        return null;
    }

    protected int isMultipleLineComment(@NonNull String @NonNull [] prefixes, @NonNull String @NonNull [] suffixes, @NonNull HiddenLeafNode node) {
        assert (prefixes.length == suffixes.length);
        String text = node.getText();
        int length = text.length();
        int iStart1 = 0;
        while (iStart1 < length) {
            char c1 = text.charAt(iStart1);
            if (!Character.isWhitespace(c1)) {
                int index = 0;
                while (index < prefixes.length) {
                    String prefix = prefixes[index];
                    if (text.startsWith(prefix, iStart1)) {
                        int iStart2 = iStart1 + prefix.length();
                        String suffix = suffixes[index];
                        int suffixLength = suffix.length();
                        int iFinish = length - 1;
                        while (iStart2 < iFinish) {
                            char c2 = text.charAt(iFinish);
                            if (!Character.isWhitespace(c2)) {
                                if (!text.startsWith(suffix, iFinish + 1 - suffixLength)) break;
                                return index;
                            }
                            --iFinish;
                        }
                        return -1;
                    }
                    ++index;
                }
                break;
            }
            ++iStart1;
        }
        return -1;
    }

    protected @Nullable String isSingleLineComment(@NonNull String @NonNull [] prefixes, @NonNull HiddenLeafNode node) {
        String text = node.getText();
        int length = text.length();
        int iStart = 0;
        while (iStart < length) {
            char c = text.charAt(iStart);
            if (!Character.isWhitespace(c)) {
                int index = 0;
                while (index < prefixes.length) {
                    String prefix = prefixes[index];
                    if (text.startsWith(prefix, iStart)) {
                        return prefix;
                    }
                    ++index;
                }
                break;
            }
            ++iStart;
        }
        return null;
    }

    protected @Nullable List<@NonNull Comment> getPostComments(@NonNull SerializationMetaData serializationMetaData, @NonNull INode node) {
        @NonNull String[] singleLineCommentPrefixes = serializationMetaData.getSingleLineCommentPrefixes();
        String text = node.getText();
        ArrayList<Comment> comments = null;
        SerializationUtils.NodeIterator nodeIterator = new SerializationUtils.NodeIterator(node);
        nodeIterator.next();
        while (nodeIterator.hasNext()) {
            String prefix;
            INode nextNode = nodeIterator.next();
            if (!(nextNode instanceof ILeafNode)) continue;
            if (!(nextNode instanceof HiddenLeafNode)) break;
            HiddenLeafNode leafNode = (HiddenLeafNode)nextNode;
            String leafText = leafNode.getText();
            Comment comment = null;
            if (singleLineCommentPrefixes != null && (prefix = this.isSingleLineComment(singleLineCommentPrefixes, leafNode)) != null) {
                comment = this.createSingleLineComment(prefix, leafNode);
                if (comments == null) {
                    comments = new ArrayList<Comment>();
                }
                comments.add(comment);
                if (!leafText.contains("\n")) continue;
                break;
            }
            if (!leafText.contains("\n")) continue;
            boolean cfr_ignored_0 = node.getParent() instanceof RootNode;
            SerializationUtils.NodeIterator tailIterator = new SerializationUtils.NodeIterator(nodeIterator);
            ILeafNode tailNode = null;
            while (tailIterator.hasNext()) {
                ILeafNode leafNode2;
                INode nextNode2 = tailIterator.next();
                if (!(nextNode2 instanceof ILeafNode) || (leafNode2 = (ILeafNode)nextNode2).isHidden()) continue;
                tailNode = leafNode2;
                break;
            }
            if (tailNode != null) break;
        }
        return comments;
    }

    protected @Nullable List<@NonNull Comment> getPreComments(@NonNull SerializationMetaData serializationMetaData, @NonNull INode node) {
        @NonNull String[] singleLineCommentPrefixes = serializationMetaData.getSingleLineCommentPrefixes();
        @Nullable String[] multipleLineCommentMidfixes = serializationMetaData.getMultipleLineCommentMidfixes();
        @NonNull String[] multipleLineCommentPrefixes = serializationMetaData.getMultipleLineCommentPrefixes();
        @NonNull String[] multipleLineCommentSuffixes = serializationMetaData.getMultipleLineCommentSuffixes();
        String text = node.getText();
        ArrayList<Comment> comments = null;
        INode prevNode = node;
        while ((prevNode = prevNode.getPreviousSibling()) instanceof HiddenLeafNode) {
            String prefix;
            int index;
            HiddenLeafNode leafNode = (HiddenLeafNode)prevNode;
            String leafText = leafNode.getText();
            Comment comment = null;
            if (multipleLineCommentPrefixes != null && multipleLineCommentSuffixes != null && multipleLineCommentMidfixes != null && (index = this.isMultipleLineComment(multipleLineCommentPrefixes, multipleLineCommentSuffixes, leafNode)) >= 0) {
                comment = this.createMultipleLineComment(multipleLineCommentPrefixes[index], multipleLineCommentSuffixes[index], leafNode, multipleLineCommentMidfixes[index]);
            } else if (singleLineCommentPrefixes != null && (prefix = this.isSingleLineComment(singleLineCommentPrefixes, leafNode)) != null) {
                if (leafNode.getOffset() <= 0) {
                    comment = this.createSingleLineComment(prefix, leafNode);
                } else {
                    INode prevPrevNode = prevNode;
                    while ((prevPrevNode = prevPrevNode.getPreviousSibling()) instanceof HiddenLeafNode) {
                        String prevText = prevPrevNode.getText();
                        HiddenLeafNode prevLeafNode = (HiddenLeafNode)prevPrevNode;
                        if (multipleLineCommentPrefixes != null && multipleLineCommentSuffixes != null && (index = this.isMultipleLineComment(multipleLineCommentPrefixes, multipleLineCommentSuffixes, prevLeafNode)) >= 0) break;
                        if (!this.endsinNewLine(prevLeafNode)) continue;
                        comment = this.createSingleLineComment(prefix, leafNode);
                        break;
                    }
                }
            }
            if (comment == null) continue;
            if (comments == null) {
                comments = new ArrayList<Comment>();
            }
            comments.add(0, comment);
        }
        return comments;
    }

    protected void showSiblings(String string, @NonNull ICompositeNode node) {
        INode previousSibling;
        StringBuilder s = new StringBuilder();
        s.append(string);
        s.append(" - ");
        ICompositeNode parent = node.getParent();
        s.append("parent\t");
        if (parent != null) {
            s.append(parent.getClass().getSimpleName());
            s.append("@");
            s.append(Integer.toHexString(System.identityHashCode(parent)));
            s.append(" - \"");
            s.append(Strings.convertToJavaString((String)parent.getText()));
            s.append("\"");
        }
        if ((previousSibling = node.getPreviousSibling()) != null) {
            this.showPreSiblings(s, previousSibling);
        }
        s.append("\n\there\t");
        s.append(node.getClass().getSimpleName());
        s.append("@");
        s.append(Integer.toHexString(System.identityHashCode(node)));
        s.append(" - \"");
        s.append(Strings.convertToJavaString((String)node.getText()));
        s.append("\"");
        ICompositeNode siblingNode = node;
        while ((siblingNode = siblingNode.getNextSibling()) != null) {
            if (!(siblingNode instanceof ILeafNode)) continue;
            s.append("\n\tnext\t");
            s.append(siblingNode.getClass().getSimpleName());
            s.append("@");
            s.append(Integer.toHexString(System.identityHashCode(siblingNode)));
            s.append(" - \"");
            s.append(Strings.convertToJavaString((String)siblingNode.getText()));
            s.append("\"");
        }
        System.out.println(s.toString());
    }

    protected void showPreSiblings(StringBuilder s, INode node) {
        INode siblingNode = node.getPreviousSibling();
        if (siblingNode != null) {
            this.showPreSiblings(s, siblingNode);
        }
        s.append("\n\tprev\t");
        s.append(node.getClass().getSimpleName());
        s.append("@");
        s.append(Integer.toHexString(System.identityHashCode(node)));
        s.append(" - \"");
        s.append(Strings.convertToJavaString((String)node.getText()));
        s.append("\"");
    }

    public static abstract class Comment {
        protected final @NonNull HiddenLeafNode node;
        protected final @NonNull String body;

        protected Comment(@NonNull HiddenLeafNode node, @NonNull String body) {
            this.node = node;
            this.body = body;
        }

        public abstract void append(@NonNull SerializationBuilder var1);

        public @NonNull HiddenLeafNode getNode() {
            return this.node;
        }

        public String toString() {
            return "\"" + Strings.convertToJavaString((String)this.body) + "\"";
        }
    }

    public static class MultipleLineComment
    extends Comment {
        protected final @NonNull String prefix;
        protected final @NonNull String suffix;
        protected final @Nullable String midfix;

        public MultipleLineComment(@NonNull HiddenLeafNode node, @NonNull String prefix, @NonNull String body, @NonNull String suffix, @Nullable String midfix) {
            super(node, body);
            this.prefix = prefix;
            this.suffix = suffix;
            this.midfix = midfix;
        }

        @Override
        public void append(@NonNull SerializationBuilder serializationBuilder) {
            serializationBuilder.append(SerializationBuilder.HALF_NEW_LINE);
            serializationBuilder.append(this.prefix);
            if (this.midfix != null) {
                serializationBuilder.append(SerializationBuilder.PUSH_NEXT);
                serializationBuilder.append(this.midfix);
            }
            int start = 0;
            while (true) {
                int index;
                String line = this.body.substring(start, (index = this.body.indexOf(10, start)) >= 0 ? index : this.body.length());
                assert (line != null);
                serializationBuilder.append(line);
                if (index < 0) break;
                serializationBuilder.append(SerializationBuilder.NEW_LINE);
                start = index + 1;
            }
            if (this.midfix != null) {
                serializationBuilder.append(SerializationBuilder.POP);
            }
            if (this.body.endsWith("\n")) {
                serializationBuilder.append(" ");
            }
            serializationBuilder.append(this.suffix);
            serializationBuilder.append(SerializationBuilder.NEW_LINE);
        }
    }

    public static class SingleLineComment
    extends Comment {
        protected final @NonNull String prefix;

        public SingleLineComment(@NonNull HiddenLeafNode node, @NonNull String prefix, @NonNull String body) {
            super(node, body);
            this.prefix = prefix;
        }

        @Override
        public void append(@NonNull SerializationBuilder serializationBuilder) {
            serializationBuilder.append(SerializationBuilder.SOFT_SPACE);
            serializationBuilder.append(this.prefix);
            serializationBuilder.append(this.body);
            serializationBuilder.append(SerializationBuilder.SOFT_NEW_LINE);
        }
    }
}

