/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.validity.locator;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.locator.AbstractConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.locator.ConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.manager.TypeURI;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityModel;
import org.eclipse.ocl.examples.validity.plugin.OCLValidityPlugin;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.internal.validation.PivotEObjectValidator;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.xtext.basecs.ElementCS;
import org.eclipse.ocl.xtext.basecs.ModelElementCS;

public class PivotConstraintLocator
extends AbstractConstraintLocator {
    public static @NonNull PivotConstraintLocator INSTANCE = new PivotConstraintLocator();

    public @NonNull Set<@NonNull TypeURI> getAllTypes(@NonNull ValidityManager validityManager, @NonNull EObject constrainingObject) {
        EnvironmentFactoryInternal environmentFactory;
        if (constrainingObject instanceof Class && (environmentFactory = PivotUtilInternal.findEnvironmentFactory((EObject)constrainingObject)) != null) {
            HashSet<@NonNull TypeURI> allTypes = new HashSet<TypeURI>();
            CompleteClass completeClass = environmentFactory.getCompleteModel().getCompleteClass((Type)((Class)constrainingObject));
            for (CompleteClass superCompleteClass : completeClass.getSuperCompleteClasses()) {
                for (Class partialClass : superCompleteClass.getPartialClasses()) {
                    EObject eTarget = partialClass.getESObject();
                    if (eTarget == null) continue;
                    allTypes.add(validityManager.getTypeURI(eTarget));
                }
            }
            return allTypes;
        }
        return super.getAllTypes(validityManager, constrainingObject);
    }

    protected EObject getConstrainedESObject(@NonNull EnvironmentFactory environmentFactory, @NonNull Constraint asConstraint) {
        Namespace constrainedElement = asConstraint.getContext();
        if (constrainedElement instanceof Class) {
            CompleteClass completeClass = environmentFactory.getCompleteModel().getCompleteClass((Type)((Class)constrainedElement));
            for (Class partialClass : completeClass.getPartialClasses()) {
                EObject esObject = partialClass.getESObject();
                if (esObject == null) continue;
                return esObject;
            }
        }
        if (constrainedElement != null) {
            MetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
            return metamodelManager.getEcoreOfPivot(EModelElement.class, (Element)constrainedElement);
        }
        return null;
    }

    public @Nullable Map<@NonNull EObject, @NonNull List<@NonNull LeafConstrainingNode>> getConstraints(@NonNull ValidityModel validityModel, @NonNull EPackage ePackage, @NonNull Set<@NonNull Resource> resources, @NonNull Monitor monitor) {
        Map map = null;
        for (Resource resource : resources) {
            EnvironmentFactoryInternal environmentFactory;
            if (monitor.isCanceled()) {
                return null;
            }
            ASResource asResource = null;
            if (resource instanceof ASResource) {
                asResource = (ASResource)resource;
            }
            if (asResource == null || (environmentFactory = PivotUtilInternal.findEnvironmentFactory((Resource)asResource)) == null) continue;
            TreeIterator tit = asResource.getAllContents();
            while (tit.hasNext()) {
                Constraint asConstraint;
                EObject esObject;
                if (monitor.isCanceled()) {
                    return null;
                }
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof Constraint) || (esObject = this.getConstrainedESObject((EnvironmentFactory)environmentFactory, asConstraint = (Constraint)eObject)) == null) continue;
                @NonNull String label = String.valueOf(asConstraint.getName());
                map = this.createLeafConstrainingNode(map, validityModel, esObject, asConstraint, label);
            }
        }
        return map;
    }

    public Object getImage() {
        return OCLValidityPlugin.INSTANCE.getImage("OCLModelFile.gif");
    }

    public @NonNull ConstraintLocator getInstance() {
        return INSTANCE;
    }

    public @NonNull String getName() {
        return "Complete OCL constraints";
    }

    public @Nullable String getSourceExpression(@NonNull LeafConstrainingNode node) {
        Object constrainingObject = node.getConstrainingObject();
        if (!(constrainingObject instanceof Constraint)) {
            return null;
        }
        LanguageExpression specification = ((Constraint)constrainingObject).getOwnedSpecification();
        if (specification == null) {
            return null;
        }
        ModelElementCS csElement = ElementUtil.getCsElement((Element)specification);
        if (csElement == null) {
            return null;
        }
        return ElementUtil.getText((ElementCS)csElement);
    }

    public @Nullable Resource getSourceResource(@NonNull LeafConstrainingNode node) {
        Object constrainingObject = node.getConstrainingObject();
        if (!(constrainingObject instanceof Constraint)) {
            return null;
        }
        ModelElementCS csElement = ElementUtil.getCsElement((Element)((Constraint)constrainingObject));
        if (csElement == null) {
            return null;
        }
        return csElement.eResource();
    }

    public @Nullable TypeURI getTypeURI(@NonNull EObject constrainedObject) {
        EnvironmentFactoryInternal environmentFactory;
        if (constrainedObject instanceof Class && (environmentFactory = PivotUtilInternal.findEnvironmentFactory((EObject)constrainedObject)) != null) {
            CompleteClassInternal completeClass = environmentFactory.getCompleteModel().getCompleteClass((Type)((Class)constrainedObject));
            for (Class partialClass : completeClass.getPartialClasses()) {
                EObject eTarget = partialClass.getESObject();
                if (eTarget == null) continue;
                return super.getTypeURI(eTarget);
            }
            PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
            EObject eTarget = metamodelManager.getEcoreOfPivot(EObject.class, (Element)((Class)constrainedObject));
            if (eTarget != null) {
                return super.getTypeURI(eTarget);
            }
        }
        return super.getTypeURI(constrainedObject);
    }

    public void validate(@NonNull Result result, @NonNull ValidityManager validityManager, @Nullable Monitor monitor) {
        block6: {
            Severity severity = Severity.UNKNOWN;
            try {
                Constraint constraint = (Constraint)result.getLeafConstrainingNode().getConstrainingObject();
                if (constraint == null) break block6;
                EObject eObject = result.getValidatableNode().getConstrainedObject();
                try {
                    ResourceSet resourceSet = eObject.eResource().getResourceSet();
                    if (resourceSet != null) {
                        Map context = validityManager.createDefaultContext();
                        context.put(Monitor.class, monitor);
                        Diagnostic diagnostic = PivotEObjectValidator.INSTANCE.validate(constraint, (Object)eObject, context);
                        result.setDiagnostic((Object)diagnostic);
                        severity = diagnostic != null ? this.getSeverity(diagnostic) : Severity.OK;
                    }
                }
                catch (Throwable e) {
                    result.setException(e);
                    severity = Severity.FATAL;
                }
            }
            finally {
                result.setSeverity(severity);
            }
        }
    }
}

