/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.validation;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.AbstractConstraintEvaluator;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.ThreadLocalExecutor;
import org.eclipse.ocl.pivot.validation.ComposedEValidator;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class PivotEObjectValidator
implements EValidator {
    public static final @NonNull PivotEObjectValidator INSTANCE = new PivotEObjectValidator(null);
    protected final @Nullable List<Model> complementingModels;

    public static @Nullable ValidationAdapter install(@NonNull ResourceSet resourceSet, @NonNull EnvironmentFactoryInternal environmentFactory) {
        return new ValidationAdapter(environmentFactory);
    }

    @Deprecated
    public static synchronized void install(@NonNull EPackage ePackage) {
        PivotEObjectValidator.install(ePackage, null);
    }

    public static synchronized void install(@NonNull EPackage ePackage, @Nullable List<Model> complementingModels) {
        ComposedEValidator composedEValidator = ComposedEValidator.install(ePackage);
        if (complementingModels == null || complementingModels.isEmpty()) {
            composedEValidator.addChild(INSTANCE);
        } else {
            composedEValidator.addChild(new PivotEObjectValidator(complementingModels));
        }
    }

    public static ResourceSet getResourceSet(@NonNull EClassifier eClassifier, @Nullable Object object, @Nullable DiagnosticChain diagnostics) {
        ResourceSet resourceSet = null;
        if (diagnostics instanceof BasicDiagnostic) {
            for (Object dataObject : ((BasicDiagnostic)diagnostics).getData()) {
                Resource resource;
                if (dataObject instanceof EObject && (resource = EcoreUtil.getRootContainer((EObject)((EObject)dataObject)).eResource()) != null && (resourceSet = resource.getResourceSet()) != null) break;
            }
        }
        if (resourceSet == null) {
            Resource resource;
            if (object instanceof EObject && (resource = EcoreUtil.getRootContainer((EObject)((EObject)object)).eResource()) != null) {
                resourceSet = resource.getResourceSet();
            }
            if (resourceSet == null && (resource = EcoreUtil.getRootContainer((EObject)eClassifier).eResource()) != null) {
                resourceSet = resource.getResourceSet();
            }
        }
        return resourceSet;
    }

    @Deprecated
    protected PivotEObjectValidator() {
        this.complementingModels = null;
    }

    public PivotEObjectValidator(@Nullable List<Model> complementingModels) {
        this.complementingModels = complementingModels;
    }

    protected boolean validate(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull EClassifier eClassifier, @Nullable Object object, @Nullable List<Model> complementingModels, @Nullable DiagnosticChain diagnostics, @Nullable Map<Object, Object> context) {
        boolean allOk = true;
        PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
        Type type = metamodelManager.getASOfEcore(Type.class, (EObject)eClassifier);
        if (type != null) {
            for (Constraint constraint : metamodelManager.getAllInvariants(type)) {
                Diagnostic diagnostic;
                Model containingModel;
                if (constraint == null || complementingModels != null && !complementingModels.contains(containingModel = PivotUtil.getContainingModel(constraint)) || (diagnostic = this.validate(environmentFactory, constraint, object, context)) == null) continue;
                if (diagnostics != null) {
                    diagnostics.add(diagnostic);
                }
                allOk = false;
                if (diagnostic.getSeverity() != 4) continue;
                return allOk;
            }
        }
        return allOk;
    }

    private @Nullable Diagnostic validate(@NonNull EnvironmentFactoryInternal environmentFactory, final @NonNull Constraint constraint, final @Nullable Object object, final @Nullable Map<Object, Object> context) {
        ExpressionInOCL query;
        LanguageExpression specification = constraint.getOwnedSpecification();
        if (specification == null) {
            return null;
        }
        if (specification.getBody() == null) {
            return null;
        }
        try {
            query = ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)environmentFactory).parseSpecification(specification);
        }
        catch (ParserException e) {
            String message = e.getLocalizedMessage();
            return new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, message, new Object[]{object});
        }
        Variable contextVariable = query.getOwnedContext();
        if (contextVariable == null) {
            return null;
        }
        ModelManager oldModelManager = null;
        if (context != null) {
            oldModelManager = (ModelManager)context.get(ModelManager.class);
        }
        EvaluationVisitor.EvaluationVisitorExtension evaluationVisitor = (EvaluationVisitor.EvaluationVisitorExtension)environmentFactory.createEvaluationVisitor(object, query, oldModelManager);
        if (context != null) {
            Object monitor;
            ModelManager newModelManager = evaluationVisitor.getExecutor().getModelManager();
            if (newModelManager != oldModelManager) {
                context.put(ModelManager.class, newModelManager);
            }
            if ((monitor = context.get(Monitor.class)) instanceof Monitor) {
                evaluationVisitor.setMonitor((Monitor)monitor);
            }
        }
        final PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
        AbstractConstraintEvaluator<Diagnostic> constraintEvaluator = new AbstractConstraintEvaluator<Diagnostic>(query){

            @Override
            protected String getObjectLabel() {
                Type type = PivotUtil.getContainingType(constraint);
                Type primaryType = type != null ? metamodelManager.getPrimaryType(type) : null;
                EObject eTarget = primaryType != null ? primaryType.getESObject() : null;
                EClassifier eClassifier = eTarget instanceof EClassifier ? (EClassifier)eTarget : null;
                return LabelUtil.getLabel(eClassifier, object, context);
            }

            @Override
            protected Diagnostic handleExceptionResult(@NonNull Throwable e) {
                String message = StringUtil.bind(PivotMessagesInternal.ValidationConstraintException_ERROR_, this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e);
                return new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, message, new Object[]{object});
            }

            @Override
            protected Diagnostic handleFailureResult(@Nullable Object result) {
                String message = this.getConstraintResultMessage(result);
                int severity = this.getConstraintResultSeverity(result);
                return new BasicDiagnostic(severity, "org.eclipse.emf.ecore", 0, message, new Object[]{object});
            }

            @Override
            protected Diagnostic handleInvalidExpression(@NonNull String message) {
                return new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, message, new Object[]{object});
            }

            @Override
            protected Diagnostic handleInvalidResult(@NonNull InvalidValueException e) {
                String message = StringUtil.bind(PivotMessagesInternal.ValidationResultIsInvalid_ERROR_, this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e.getLocalizedMessage());
                return new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, message, new Object[]{object});
            }

            @Override
            protected Diagnostic handleSuccessResult() {
                return null;
            }
        };
        Diagnostic diagnostic = (Diagnostic)constraintEvaluator.evaluate(evaluationVisitor);
        return diagnostic;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, @Nullable Map<Object, Object> context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public @Nullable Diagnostic validate(@NonNull Constraint constraint, @Nullable Object object, @Nullable Map<Object, Object> context) {
        EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.getEnvironmentFactory(object);
        return this.validate(environmentFactory, constraint, object, context);
    }

    protected boolean validate(@NonNull EClassifier eClassifier, @Nullable Object object, @Nullable List<Model> complementingModels, @Nullable DiagnosticChain diagnostics, @Nullable Map<Object, Object> validationContext) {
        EnvironmentFactoryInternal environmentFactory = ThreadLocalExecutor.basicGetEnvironmentFactory();
        if (environmentFactory == null) {
            return true;
        }
        return this.validate(environmentFactory, eClassifier, object, complementingModels, diagnostics, validationContext);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean allOk = true;
        if (eClass != null && !eObject.eIsProxy()) {
            allOk &= this.validatePivot((EClassifier)eClass, eObject, diagnostics, context);
        }
        return allOk;
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean allOk = true;
        if (eDataType != null) {
            allOk &= this.validatePivot((EClassifier)eDataType, value, diagnostics, context);
        }
        return allOk;
    }

    protected boolean validatePivot(@NonNull EClassifier eClassifier, @Nullable Object object, @Nullable DiagnosticChain diagnostics, Map<Object, Object> validationContext) {
        EnvironmentFactoryInternal environmentFactory = ThreadLocalExecutor.basicGetEnvironmentFactory();
        if (environmentFactory == null) {
            return true;
        }
        ResourceSet resourceSet = PivotEObjectValidator.getResourceSet(eClassifier, object, diagnostics);
        if (resourceSet != null) {
            boolean allOk = this.validate(environmentFactory, eClassifier, object, this.complementingModels, diagnostics, validationContext);
            return allOk || diagnostics != null;
        }
        return true;
    }

    @Deprecated
    public static class ValidationAdapter
    extends AdapterImpl {
        protected final @NonNull EnvironmentFactoryInternal environmentFactory;

        public static @Nullable ValidationAdapter findAdapter(@NonNull ResourceSet resourceSet) {
            EnvironmentFactoryInternal environmentFactory = ThreadLocalExecutor.basicGetEnvironmentFactory();
            return environmentFactory != null ? new ValidationAdapter(environmentFactory) : null;
        }

        public ValidationAdapter(@Nullable EnvironmentFactoryInternal environmentFactory) {
            this.environmentFactory = environmentFactory != null ? environmentFactory : PivotUtilInternal.getEnvironmentFactory(null);
        }

        public @NonNull EnvironmentFactoryInternal getEnvironmentFactory() {
            return this.environmentFactory;
        }

        public boolean validate(@NonNull EClassifier eClassifier, @Nullable Object object, @Nullable DiagnosticChain diagnostics, @Nullable Map<Object, Object> context) {
            return INSTANCE.validate(eClassifier, object, null, diagnostics, context);
        }

        public boolean validate(@NonNull EClassifier eClassifier, @Nullable Object object, @Nullable List<Model> complementingModels, @Nullable DiagnosticChain diagnostics, @Nullable Map<Object, Object> context) {
            return INSTANCE.validate(eClassifier, object, complementingModels, diagnostics, context);
        }

        public @Nullable Diagnostic validate(@NonNull Constraint constraint, @Nullable Object object, @Nullable Map<Object, Object> context) {
            return INSTANCE.validate(this.environmentFactory, constraint, object, (Map<Object, Object>)context);
        }
    }
}

