/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.framework;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.eventmanager.filters.NewValueClassFilterIncludingSubclasses;
import org.eclipse.ocl.examples.eventmanager.framework.TableForEventFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableForNewValueClassFilterIncludingSubclasses
extends TableForEventFilter {
    public TableForNewValueClassFilterIncludingSubclasses(int numberOfFilterTables) {
        super(numberOfFilterTables);
    }

    @Override
    public Object getAffectedObject(Notification event) {
        if (this.isEmpty() || event.getNewValue() == null) {
            return null;
        }
        HashSet<EClass> result = new HashSet<EClass>();
        if (event.getNewValue() instanceof EObject) {
            EClass eClass = ((EObject)event.getNewValue()).eClass();
            result.add(eClass);
            result.addAll((Collection<EClass>)eClass.getEAllSuperTypes());
            return result;
        }
        if (event.getNewValue() instanceof EList) {
            for (Object o : (EList)event.getNewValue()) {
                if (!(o instanceof EObject)) continue;
                EClass eClass = ((EObject)o).eClass();
                result.add(eClass);
                result.addAll((Collection<EClass>)eClass.getEAllSuperTypes());
            }
        } else {
            return null;
        }
        return result;
    }

    public Class<NewValueClassFilterIncludingSubclasses> getIdentifier() {
        return NewValueClassFilterIncludingSubclasses.class;
    }

    @Override
    protected String criterionToString(Object criterion) {
        StringBuilder result = new StringBuilder();
        if (criterion instanceof EClass) {
            result.append(((EClass)criterion).getName());
        } else {
            Set eClassSet = (Set)criterion;
            boolean first = true;
            for (Object eClass : eClassSet) {
                if (!first) {
                    result.append(", ");
                    continue;
                }
                result.append(((EClass)eClass).getName());
            }
        }
        return result.toString();
    }
}

