/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.TypeType;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.ecore.tests.MessagesTest;
import org.eclipse.ocl.expressions.ExpressionsPackage;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.types.TypesPackage;
import org.eclipse.ocl.utilities.UtilitiesPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializationTest
extends AbstractTestSuite {
    Resource res;

    public void test_basicSerialization() {
        OCLExpression<EClassifier> expr = this.parseExpression((EClassifier)EcorePackage.Literals.EPACKAGE, "self.eSuperPackage");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
    }

    public void test_primitiveTypeSerialization() {
        OCLExpression<EClassifier> expr = this.parseExpression((EClassifier)EcorePackage.Literals.EPACKAGE, "self.eSubpackages->size() > 2");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
    }

    public void test_primitiveCollectionTypeSerialization() {
        OCLExpression<EClassifier> expr = this.parseExpression((EClassifier)EcorePackage.Literals.EPACKAGE, "self.eSubpackages->collect(eClassifiers->size())");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
    }

    public void test_modelCollectionTypeSerialization() {
        OCLExpression<EClassifier> expr = this.parseExpression((EClassifier)EcorePackage.Literals.EPACKAGE, "let subs : Collection(EPackage) = self.eSubpackages in subs->size() > 2");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
    }

    public void test_typeExpSerialization() {
        OCLExpression<EClassifier> expr = this.parseExpression((EClassifier)EcorePackage.Literals.EPACKAGE, "self.eClassifiers->forAll(c | c.oclIsKindOf(EClass) implies EClass.allInstances()->includes(c.oclAsType(EClass)))");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
    }

    public void test_tupleSerialization() {
        OCLExpression<EClassifier> expr = this.parseExpression((EClassifier)EcorePackage.Literals.EPACKAGE, "self.eSubpackages->collect(Tuple{pkg = name, size = eClassifiers->size()})");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
    }

    public void test_operationMessageSerialization() {
        OCLExpression<EClassifier> expr = this.parseExpression((EClassifier)this.fruit, "let msgs : Sequence(OclMessage) = self^^ripen(?) in msgs->forAll(m | m.hasReturned() implies m.color <> Color::black)");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
    }

    public void test_signalMessageSerialization() {
        this.expectModified = true;
        this.ocl.dispose();
        this.ocl = OCL.newInstance((EnvironmentFactory)new MessagesTest.MessagingFruitEnvironmentFactory(this), (Resource)this.res);
        this.helper = this.ocl.createOCLHelper();
        OCLExpression<EClassifier> expr = this.parseExpression((EClassifier)this.fruit, "let msgs : Sequence(OclMessage) = self^^Drop(?, ?) in msgs->forAll(m | m.delay = 0 implies m.stem.oclIsUndefined())");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
    }

    public void test_additionalOperationSerialization() {
        this.helper.setContext((Object)EcorePackage.Literals.EPACKAGE);
        EcoreEnvironment env = (EcoreEnvironment)this.ocl.getEnvironment();
        EOperation eoper = null;
        try {
            eoper = (EOperation)this.helper.defineOperation("getUniqueClassifierNames() : Set(String) = self.eClassifiers->collect(name)->asSet()");
            SerializationTest.assertSame((Object)eoper, (Object)env.getTypeResolver().resolveAdditionalOperation((Object)EcorePackage.Literals.EPACKAGE, (Object)eoper));
        }
        catch (Exception e) {
            SerializationTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        OCLExpression<EClassifier> expr = this.parseExpression((EClassifier)EcorePackage.Literals.EPACKAGE, "self.getUniqueClassifierNames()->size()");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
        OCL newOCL = OCL.newInstance((EnvironmentFactory)env.getFactory(), (Resource)env.getTypeResolver().getResource());
        EOperation newOper = (EOperation)newOCL.getEnvironment().getTypeResolver().resolveAdditionalOperation((Object)EcorePackage.Literals.EPACKAGE, (Object)eoper);
        SerializationTest.assertNotSame((Object)eoper, (Object)newOper);
    }

    public void test_additionalPropertySerialization() {
        this.helper.setContext((Object)EcorePackage.Literals.EPACKAGE);
        EcoreEnvironment env = (EcoreEnvironment)this.ocl.getEnvironment();
        EStructuralFeature esf = null;
        try {
            esf = (EStructuralFeature)this.helper.defineAttribute("uniqueClassifierNames : Set(String) = self.eClassifiers->collect(name)->asSet()");
            SerializationTest.assertSame((Object)esf, (Object)env.getTypeResolver().resolveAdditionalAttribute((Object)EcorePackage.Literals.EPACKAGE, (Object)esf));
        }
        catch (Exception e) {
            SerializationTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        OCLExpression<EClassifier> expr = this.parseExpression((EClassifier)EcorePackage.Literals.EPACKAGE, "self.uniqueClassifierNames->size()");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
        OCL newOCL = OCL.newInstance((EnvironmentFactory)env.getFactory(), (Resource)env.getTypeResolver().getResource());
        EStructuralFeature newSF = (EStructuralFeature)newOCL.getEnvironment().getTypeResolver().resolveAdditionalAttribute((Object)EcorePackage.Literals.EPACKAGE, (Object)esf);
        SerializationTest.assertNotSame((Object)esf, (Object)newSF);
    }

    public void test_typeTypeSerialization_183494() {
        OCLExpression expr = this.parseExpression((EClassifier)EcorePackage.Literals.EPACKAGE, "EPackage.allInstances()");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
        SerializationTest.assertTrue((boolean)(expr instanceof OperationCallExp));
        expr = ((OperationCallExp)expr).getSource();
        SerializationTest.assertNotNull((Object)expr);
        SerializationTest.assertTrue((boolean)(expr.getType() instanceof TypeType));
        TypeType typeType = (TypeType)expr.getType();
        SerializationTest.assertSame((Object)EcorePackage.Literals.EPACKAGE, (Object)typeType.getReferredType());
    }

    public void test_OclType_serialization_226455() {
        TypeResolver resolver = this.ocl.getEnvironment().getTypeResolver();
        EClassifier oclType = (EClassifier)resolver.resolve((Object)((EClassifier)this.getOCLStandardLibrary().getOclType()));
        SerializationTest.assertSame((Object)this.getOCLStandardLibrary().getOclType(), (Object)oclType);
        SerializationTest.assertTrue((boolean)resolver.getResource().getContents().isEmpty());
    }

    public void test_typespec_resolution_226455() {
        this.parseExpression((EClassifier)EcorePackage.Literals.EPACKAGE, "self.eClassifiers->any(oclIsKindOf(EClass))");
        Resource res = this.ocl.getEnvironment().getTypeResolver().getResource();
        EPackage typesPackage = null;
        for (EObject next : res.getContents()) {
            if (!(next instanceof EPackage) || !"types".equals(((EPackage)next).getName())) continue;
            typesPackage = (EPackage)next;
            break;
        }
        SerializationTest.assertNotNull(typesPackage);
        SerializationTest.assertEquals((int)1, (int)typesPackage.getEClassifiers().size());
        EClassifier first = (EClassifier)typesPackage.getEClassifiers().get(0);
        SerializationTest.assertTrue((boolean)(first instanceof TypeType));
        SerializationTest.assertSame((Object)EcorePackage.Literals.ECLASS, (Object)((TypeType)first).getReferredType());
    }

    public void test_referenceToGenericOCLExpressionsPackage_214878() {
        EPackage epackage = EcoreFactory.eINSTANCE.createEPackage();
        epackage.setName("foo");
        EClass eclass = EcoreFactory.eINSTANCE.createEClass();
        eclass.setName("Foo");
        epackage.getEClassifiers().add((Object)eclass);
        EReference ref = EcoreFactory.eINSTANCE.createEReference();
        ref.setName("expr");
        ref.setEType((EClassifier)ExpressionsPackage.Literals.OCL_EXPRESSION);
        eclass.getEStructuralFeatures().add((Object)ref);
        String serialForm = this.serialize((EObject)epackage);
        epackage = this.load(serialForm, EPackage.class);
        eclass = (EClass)epackage.getEClassifier("Foo");
        SerializationTest.assertNotNull((Object)eclass);
        SerializationTest.assertFalse((boolean)eclass.eIsProxy());
        ref = (EReference)eclass.getEStructuralFeature("expr");
        SerializationTest.assertNotNull((Object)ref);
        SerializationTest.assertFalse((boolean)ref.eIsProxy());
        SerializationTest.assertSame((Object)ExpressionsPackage.Literals.OCL_EXPRESSION, (Object)ref.getEType());
        SerializationTest.assertFalse((boolean)serialForm.contains("http://www.eclipse.org/ocl/1.1.0/OCL#//expressions/OCLExpression"));
        SerializationTest.assertTrue((boolean)serialForm.contains("http://www.eclipse.org/ocl/1.1.0/OCL/Expressions#//OCLExpression"));
    }

    public void test_referenceToGenericOCLTypesPackage_214878() {
        EPackage epackage = EcoreFactory.eINSTANCE.createEPackage();
        epackage.setName("foo");
        EClass eclass = EcoreFactory.eINSTANCE.createEClass();
        eclass.setName("Foo");
        epackage.getEClassifiers().add((Object)eclass);
        EReference ref = EcoreFactory.eINSTANCE.createEReference();
        ref.setName("any");
        ref.setEType((EClassifier)TypesPackage.Literals.ANY_TYPE);
        eclass.getEStructuralFeatures().add((Object)ref);
        String serialForm = this.serialize((EObject)epackage);
        epackage = this.load(serialForm, EPackage.class);
        eclass = (EClass)epackage.getEClassifier("Foo");
        SerializationTest.assertNotNull((Object)eclass);
        SerializationTest.assertFalse((boolean)eclass.eIsProxy());
        ref = (EReference)eclass.getEStructuralFeature("any");
        SerializationTest.assertNotNull((Object)ref);
        SerializationTest.assertFalse((boolean)ref.eIsProxy());
        SerializationTest.assertSame((Object)TypesPackage.Literals.ANY_TYPE, (Object)ref.getEType());
        SerializationTest.assertFalse((boolean)serialForm.contains("http://www.eclipse.org/ocl/1.1.0/OCL#//types/AnyType"));
        SerializationTest.assertTrue((boolean)serialForm.contains("http://www.eclipse.org/ocl/1.1.0/OCL/Types#//AnyType"));
    }

    public void test_referenceToGenericOCLUtilitiesPackage_214878() {
        EPackage epackage = EcoreFactory.eINSTANCE.createEPackage();
        epackage.setName("foo");
        EClass eclass = EcoreFactory.eINSTANCE.createEClass();
        eclass.setName("Foo");
        epackage.getEClassifiers().add((Object)eclass);
        EReference ref = EcoreFactory.eINSTANCE.createEReference();
        ref.setName("ast");
        ref.setEType((EClassifier)UtilitiesPackage.Literals.AST_NODE);
        eclass.getEStructuralFeatures().add((Object)ref);
        String serialForm = this.serialize((EObject)epackage);
        epackage = this.load(serialForm, EPackage.class);
        eclass = (EClass)epackage.getEClassifier("Foo");
        SerializationTest.assertNotNull((Object)eclass);
        SerializationTest.assertFalse((boolean)eclass.eIsProxy());
        ref = (EReference)eclass.getEStructuralFeature("ast");
        SerializationTest.assertNotNull((Object)ref);
        SerializationTest.assertFalse((boolean)ref.eIsProxy());
        SerializationTest.assertSame((Object)UtilitiesPackage.Literals.AST_NODE, (Object)ref.getEType());
        SerializationTest.assertFalse((boolean)serialForm.contains("http://www.eclipse.org/ocl/1.1.0/OCL#//utilities/ASTNode"));
        SerializationTest.assertTrue((boolean)serialForm.contains("http://www.eclipse.org/ocl/1.1.0/OCL/Utilities#//ASTNode"));
    }

    public void test_referenceToOCLEcoreMetamodel_214878() {
        EPackage epackage = EcoreFactory.eINSTANCE.createEPackage();
        epackage.setName("foo");
        EClass eclass = EcoreFactory.eINSTANCE.createEClass();
        eclass.setName("Foo");
        epackage.getEClassifiers().add((Object)eclass);
        EReference ref = EcoreFactory.eINSTANCE.createEReference();
        ref.setName("expr");
        ref.setEType((EClassifier)EcorePackage.Literals.OCL_EXPRESSION);
        eclass.getEStructuralFeatures().add((Object)ref);
        String serialForm = this.serialize((EObject)epackage);
        epackage = this.load(serialForm, EPackage.class);
        eclass = (EClass)epackage.getEClassifier("Foo");
        SerializationTest.assertNotNull((Object)eclass);
        SerializationTest.assertFalse((boolean)eclass.eIsProxy());
        ref = (EReference)eclass.getEStructuralFeature("expr");
        SerializationTest.assertNotNull((Object)ref);
        SerializationTest.assertFalse((boolean)ref.eIsProxy());
        SerializationTest.assertSame((Object)EcorePackage.Literals.OCL_EXPRESSION, (Object)ref.getEType());
        SerializationTest.assertFalse((boolean)serialForm.contains("http://www.eclipse.org/ocl/1.1.0/OCL#//ecore/OCLExpression"));
        SerializationTest.assertTrue((boolean)serialForm.contains("http://www.eclipse.org/ocl/1.1.0/Ecore#//OCLExpression"));
    }

    protected void setUp() {
        this.res = new XMIResourceImpl(){

            protected boolean useIDs() {
                return true;
            }

            protected boolean useUUIDs() {
                return true;
            }
        };
        this.res.setURI(URI.createFileURI((String)"/tmp/ocltest.xmi"));
        ((XMLResource)this.res).setEncoding("UTF-8");
        super.setUp();
        resourceSet.getResources().add((Object)this.res);
    }

    protected OCL createOCL() {
        EcoreEnvironmentFactory factory = new EcoreEnvironmentFactory(resourceSet.getPackageRegistry());
        EcoreEnvironment environment = (EcoreEnvironment)factory.loadEnvironment(this.res);
        return OCL.newInstance((Environment)environment);
    }

    protected OCLExpression<EClassifier> parseExpression(EClassifier context, String expr) {
        this.helper.setContext((Object)context);
        EcoreEnvironment env = (EcoreEnvironment)this.ocl.getEnvironment();
        resourceSet.getResources().add((Object)env.getTypeResolver().getResource());
        OCLExpression result = null;
        try {
            result = this.helper.createQuery(expr);
        }
        catch (Exception e) {
            SerializationTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        SerializationTest.assertNotNull((Object)result);
        return result;
    }

    protected String serialize(EObject eobject) {
        String result = null;
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            this.res.getContents().add((Object)eobject);
            this.res.save((OutputStream)output, Collections.singletonMap("SAVE_TYPE_INFORMATION", Boolean.TRUE));
            result = output.toString("UTF-8");
        }
        catch (Exception e) {
            SerializationTest.fail((String)("Exception serializing AST: " + e.getLocalizedMessage()));
        }
        SerializationTest.assertNotNull(result);
        SerializationTest.assertFalse((boolean)result.contains("ocl://"));
        return result;
    }

    protected List<EObject> deserialize(String serial) {
        EList result;
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(serial.getBytes());
            this.res.unload();
            this.res.load((InputStream)input, Collections.EMPTY_MAP);
            this.ocl = this.createOCL();
            this.helper = this.createHelper();
            SerializationTest.assertFalse((String)"No contents in serial data", (boolean)this.res.getContents().isEmpty());
            this.assertNoProxies(this.res);
            result = this.res.getContents();
        }
        catch (Exception e) {
            SerializationTest.fail((String)("Exception deserializing AST: " + e.getLocalizedMessage()));
            result = Collections.emptyList();
        }
        SerializationTest.assertNotNull(result);
        return result;
    }

    protected OCLExpression<EClassifier> loadExpression(String serial) {
        return this.load(serial, OCLExpression.class);
    }

    protected Constraint loadConstraint(String serial) {
        return this.load(serial, Constraint.class);
    }

    protected <T extends EObject> T load(String serial, Class<T> expectedType) {
        EObject result = null;
        List<EObject> objects = this.deserialize(serial);
        for (EObject next : objects) {
            if (!expectedType.isInstance(next)) continue;
            result = next;
            break;
        }
        SerializationTest.assertNotNull((String)("Did not deserialize a " + expectedType.getSimpleName()), result);
        return (T)result;
    }

    protected void assertNoProxies(Resource res) {
        TreeIterator iter = res.getAllContents();
        while (iter.hasNext()) {
            for (EObject xref : ((EObject)iter.next()).eCrossReferences()) {
                SerializationTest.assertFalse((String)("Unresolved reference: " + xref), (boolean)xref.eIsProxy());
            }
        }
    }
}

