/*
 * Decompiled with CFR 0.152.
 */
package data.generics.util;

import data.classes.util.ClassesValidator;
import data.generics.ActualTypeParameter;
import data.generics.ClassParameterization;
import data.generics.FormalTypeParameter;
import data.generics.GenericsPackage;
import data.generics.ParameterizedClassInstantiation;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class GenericsValidator
extends EObjectValidator {
    public static final GenericsValidator INSTANCE = new GenericsValidator();
    public static final String DIAGNOSTIC_SOURCE = "data.generics";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected ClassesValidator classesValidator = ClassesValidator.INSTANCE;
    protected static final String FORMAL_TYPE_PARAMETER__USE_IN_SIGNATURES_OF_OWNING_PARAMERIZED_CLASS_ONLY__EEXPRESSION = "self.elementsOfType.getTypeUsage()->forAll(s | s.oclIsKindOf(data::classes::Parameter) implies \r\n   (s.oclAsType(data::classes::Parameter).ownerSignature.oclIsKindOf(data::classes::MethodSignature) and\r\n    s.oclAsType(data::classes::Parameter).ownerSignature.oclAsType(data::classes::MethodSignature).owner=self.parameterOf .owningClassDefinition)) and\r\n  self.elementsOfType.signaturesWithOutput->forAll(s| s.oclIsKindOf(data::classes::MethodSignature) and \r\n    s.oclAsType(data::classes::MethodSignature).owner->notEmpty() and\r\n    s.oclAsType(data::classes::MethodSignature).owner=self.parameterOf.owningClassDefinition) and\r\n  self.signaturesWithFault->forAll(s| s.oclIsKindOf(data::classes::MethodSignature)  and \r\n    s.oclAsType(data::classes::MethodSignature).owner->notEmpty() and\r\n    s.oclAsType(data::classes::MethodSignature).owner=self.parameterOf.owningClassDefinition)";
    protected static final String FORMAL_TYPE_PARAMETER__USE_IN_ASSOCIATIONS_OF_OWNING_PARAMETERIZED_CLASS_ONLY__EEXPRESSION = "self.elementsOfType.associationEnd->\r\n    forAll(ae | ae.otherEnd().type.clazz = self.parameterOf.owningClassDefinition)";
    protected static final String PARAMETERIZED_CLASS_INSTANTIATION__ACTUAL_TYPE_PARAMETERS_MATCH_SIGNATURE__EEXPRESSION = "self.actualTypeParametersForInstantiation->size() = self.parameterizedClass.parameterization.formalTypeParameters->size() and\r\n  Sequence{1..self.actualTypeParametersForInstantiation->size()}->forAll(i:Integer|\r\n    self.actualTypeParametersForInstantiation->at(i).formalTypeParameter =\r\n    self.parameterizedClass.parameterization.formalTypeParameters->at(i))";
    protected static final String PARAMETERIZED_CLASS_INSTANTIATION__CLASS_MUST_BE_PARAMETERIZED__EEXPRESSION = "self.parameterizedClass.parameterization->notEmpty()";
    protected static final String CLASS_PARAMETERIZATION__DISTINCT_FORMAL_TYPE_PARAMETER_NAMES__EEXPRESSION = "self.formalTypeParameters->forAll(i,j|i<>j implies i.name<>j.name)";
    protected static final String ACTUAL_TYPE_PARAMETER__TYPE_CONFORMS_WITH_FORMAL_PARAMETERS_TYPE_CONSTRAINT__EEXPRESSION = "self.formalTypeParameter.typeConstraint->notEmpty() implies\r\n    self.type.conformsTo(self.formalTypeParameter.typeConstraint)";

    protected EPackage getEPackage() {
        return GenericsPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateFormalTypeParameter((FormalTypeParameter)value, diagnostics, context);
            }
            case 1: {
                return this.validateParameterizedClassInstantiation((ParameterizedClassInstantiation)value, diagnostics, context);
            }
            case 2: {
                return this.validateClassParameterization((ClassParameterization)value, diagnostics, context);
            }
            case 3: {
                return this.validateActualTypeParameter((ActualTypeParameter)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateFormalTypeParameter(FormalTypeParameter formalTypeParameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(formalTypeParameter, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(formalTypeParameter, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(formalTypeParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(formalTypeParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(formalTypeParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(formalTypeParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(formalTypeParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(formalTypeParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(formalTypeParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.classesValidator.validateSapClass_OnlyValueClassesCanHaveObjectParameters(formalTypeParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.classesValidator.validateSapClass_OnlyObjectParameterizedClassesCanHaveConverter(formalTypeParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.classesValidator.validateSapClass_OnlyTrailingOptionalParameters(formalTypeParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.classesValidator.validateSapClass_NoRecursionForObjectParameters(formalTypeParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFormalTypeParameter_UseInSignaturesOfOwningParamerizedClassOnly(formalTypeParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFormalTypeParameter_UseInAssociationsOfOwningParameterizedClassOnly(formalTypeParameter, diagnostics, context);
        }
        return result;
    }

    public boolean validateFormalTypeParameter_UseInSignaturesOfOwningParamerizedClassOnly(FormalTypeParameter formalTypeParameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(GenericsPackage.Literals.FORMAL_TYPE_PARAMETER, formalTypeParameter, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "UseInSignaturesOfOwningParamerizedClassOnly", FORMAL_TYPE_PARAMETER__USE_IN_SIGNATURES_OF_OWNING_PARAMERIZED_CLASS_ONLY__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateFormalTypeParameter_UseInAssociationsOfOwningParameterizedClassOnly(FormalTypeParameter formalTypeParameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(GenericsPackage.Literals.FORMAL_TYPE_PARAMETER, formalTypeParameter, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "UseInAssociationsOfOwningParameterizedClassOnly", FORMAL_TYPE_PARAMETER__USE_IN_ASSOCIATIONS_OF_OWNING_PARAMETERIZED_CLASS_ONLY__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateParameterizedClassInstantiation(ParameterizedClassInstantiation parameterizedClassInstantiation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(parameterizedClassInstantiation, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(parameterizedClassInstantiation, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(parameterizedClassInstantiation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(parameterizedClassInstantiation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(parameterizedClassInstantiation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(parameterizedClassInstantiation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(parameterizedClassInstantiation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(parameterizedClassInstantiation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(parameterizedClassInstantiation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.classesValidator.validateSapClass_OnlyValueClassesCanHaveObjectParameters(parameterizedClassInstantiation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.classesValidator.validateSapClass_OnlyObjectParameterizedClassesCanHaveConverter(parameterizedClassInstantiation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.classesValidator.validateSapClass_OnlyTrailingOptionalParameters(parameterizedClassInstantiation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.classesValidator.validateSapClass_NoRecursionForObjectParameters(parameterizedClassInstantiation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateParameterizedClassInstantiation_ActualTypeParametersMatchSignature(parameterizedClassInstantiation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateParameterizedClassInstantiation_ClassMustBeParameterized(parameterizedClassInstantiation, diagnostics, context);
        }
        return result;
    }

    public boolean validateParameterizedClassInstantiation_ActualTypeParametersMatchSignature(ParameterizedClassInstantiation parameterizedClassInstantiation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(GenericsPackage.Literals.PARAMETERIZED_CLASS_INSTANTIATION, parameterizedClassInstantiation, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ActualTypeParametersMatchSignature", PARAMETERIZED_CLASS_INSTANTIATION__ACTUAL_TYPE_PARAMETERS_MATCH_SIGNATURE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateParameterizedClassInstantiation_ClassMustBeParameterized(ParameterizedClassInstantiation parameterizedClassInstantiation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(GenericsPackage.Literals.PARAMETERIZED_CLASS_INSTANTIATION, parameterizedClassInstantiation, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ClassMustBeParameterized", PARAMETERIZED_CLASS_INSTANTIATION__CLASS_MUST_BE_PARAMETERIZED__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateClassParameterization(ClassParameterization classParameterization, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(classParameterization, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(classParameterization, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(classParameterization, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(classParameterization, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(classParameterization, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(classParameterization, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(classParameterization, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(classParameterization, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(classParameterization, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateClassParameterization_DistinctFormalTypeParameterNames(classParameterization, diagnostics, context);
        }
        return result;
    }

    public boolean validateClassParameterization_DistinctFormalTypeParameterNames(ClassParameterization classParameterization, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(GenericsPackage.Literals.CLASS_PARAMETERIZATION, classParameterization, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "DistinctFormalTypeParameterNames", CLASS_PARAMETERIZATION__DISTINCT_FORMAL_TYPE_PARAMETER_NAMES__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateActualTypeParameter(ActualTypeParameter actualTypeParameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(actualTypeParameter, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(actualTypeParameter, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(actualTypeParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(actualTypeParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(actualTypeParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(actualTypeParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(actualTypeParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(actualTypeParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(actualTypeParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateActualTypeParameter_TypeConformsWithFormalParametersTypeConstraint(actualTypeParameter, diagnostics, context);
        }
        return result;
    }

    public boolean validateActualTypeParameter_TypeConformsWithFormalParametersTypeConstraint(ActualTypeParameter actualTypeParameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(GenericsPackage.Literals.ACTUAL_TYPE_PARAMETER, actualTypeParameter, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "TypeConformsWithFormalParametersTypeConstraint", ACTUAL_TYPE_PARAMETER__TYPE_CONFORMS_WITH_FORMAL_PARAMETERS_TYPE_CONSTRAINT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

