/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcoreEvaluationEnvironment;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.helper.OCLHelper;

public class OCLOperationCollisionTest
extends AbstractTestSuite {
    private static final String OPERATION_STRING_LAST = "last";
    private boolean enteredMyOperationBody;

    protected void setUp() {
        super.setUp();
        ((EcoreEnvironment)this.ocl.getEnvironment()).addHelperOperation((Object)((EClassifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString()), (Object)this.getLastOperation());
    }

    protected OCL createOCL() {
        return OCL.newInstance((EnvironmentFactory)new MyEnvironmentFactory());
    }

    public EOperation getLastOperation() {
        EOperation operation = EcoreFactory.eINSTANCE.createEOperation();
        operation.setName(OPERATION_STRING_LAST);
        operation.setEType((EClassifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString());
        return operation;
    }

    public EPackage getDummyModel() {
        EPackage packaje = EcoreFactory.eINSTANCE.createEPackage();
        packaje.setName("package");
        EClass clazz = EcoreFactory.eINSTANCE.createEClass();
        clazz.setName("Class");
        packaje.getEClassifiers().add((Object)clazz);
        return packaje;
    }

    public void testEvaluation() throws ParserException {
        OCLHelper helper = this.ocl.createOCLHelper();
        helper.setContext((Object)EcorePackage.eINSTANCE.getENamedElement());
        OCLExpression expression = helper.createQuery("self.name.last()");
        try {
            this.ocl.createQuery(expression).evaluate(this.getDummyModel().getEClassifiers().get(0));
            OCLOperationCollisionTest.assertTrue((String)"Evaluation should have gone through MyEvaluationEnvironment#callOperation()", (boolean)this.enteredMyOperationBody);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private class MyEnvironmentFactory
    extends EcoreEnvironmentFactory {
        private MyEnvironmentFactory() {
        }

        public EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> createEvaluationEnvironment() {
            return new MyEvaluationEnvironment(this);
        }

        public EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> createEvaluationEnvironment(EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent) {
            return new MyEvaluationEnvironment(parent);
        }
    }

    private class MyEvaluationEnvironment
    extends EcoreEvaluationEnvironment {
        public MyEvaluationEnvironment(MyEnvironmentFactory factory) {
            super((EcoreEnvironmentFactory)factory);
        }

        public MyEvaluationEnvironment(EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent) {
            super(parent);
        }

        public Object callOperation(EOperation operation, int opcode, Object source, Object[] args) {
            if (OCLOperationCollisionTest.OPERATION_STRING_LAST.equals(operation.getName())) {
                OCLOperationCollisionTest.this.enteredMyOperationBody = true;
            }
            return super.callOperation(operation, opcode, source, args);
        }
    }
}

