/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import modelmanagement.Package;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.model.ModelCloner;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.model.PackageDependencyGraph;

public class IncrementalResourceShrinker {
    public Collection<Resource> shrinkIncrementally(Resource fullSizeResource) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        int cloneId = 0;
        Resource nextResourceToShrink = ModelCloner.cloneResource(fullSizeResource, String.valueOf(cloneId));
        while (this.deletePackageWithFewestDependencies(nextResourceToShrink) >= 1) {
            result.add(nextResourceToShrink);
            nextResourceToShrink = ModelCloner.cloneResource(nextResourceToShrink, String.valueOf(++cloneId));
        }
        return result;
    }

    public void shrinkCombinational(Resource parent, ArrayList<Resource> result, ArrayList<Integer> visitedSizes) {
        PackageDependencyGraph dependencyGraph = new PackageDependencyGraph(parent);
        ArrayList<Package> packageToDeleteList = this.calculatePossiblePackagesToDelete(dependencyGraph);
        ArrayList<Resource> cloneList = new ArrayList<Resource>();
        ArrayList<PackageDependencyGraph> dependencyGraphList = new ArrayList<PackageDependencyGraph>();
        int i = 0;
        while (i < packageToDeleteList.size()) {
            Resource clone = ModelCloner.cloneResource(parent, String.valueOf(i));
            cloneList.add(clone);
            PackageDependencyGraph cloneDependencyGraph = new PackageDependencyGraph(clone);
            dependencyGraphList.add(cloneDependencyGraph);
            ArrayList<Package> clonePackageToDeleteList = this.calculatePossiblePackagesToDelete(cloneDependencyGraph);
            if (cloneDependencyGraph.getNumberOfPackages() > 1) {
                this.deletePackage((Package)clonePackageToDeleteList.get(i), cloneDependencyGraph);
                int numberOfElementsInChild = this.getNumberOfElements(clone);
                if (!visitedSizes.contains(numberOfElementsInChild)) {
                    result.add(clone);
                    visitedSizes.add(numberOfElementsInChild);
                }
                System.out.println(visitedSizes.size());
            }
            ++i;
        }
        i = 0;
        while (i < packageToDeleteList.size()) {
            if (((PackageDependencyGraph)dependencyGraphList.get(i)).getNumberOfPackages() > 1 && visitedSizes.size() < 108) {
                this.shrinkCombinational((Resource)cloneList.get(i), result, visitedSizes);
            }
            ++i;
        }
    }

    private int getNumberOfElements(Resource resource) {
        int resourceSize = 0;
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            iterator.next();
            ++resourceSize;
        }
        return resourceSize;
    }

    private int deletePackageWithFewestDependencies(Resource resourceToShrink) {
        PackageDependencyGraph dependencyGraph = new PackageDependencyGraph(resourceToShrink);
        ArrayList<Package> packagesToDeleteList = this.calculatePossiblePackagesToDelete(dependencyGraph);
        this.deletePackage(this.getPackageWithFewestDependencies(packagesToDeleteList, dependencyGraph), dependencyGraph);
        return dependencyGraph.getNumberOfPackages();
    }

    private ArrayList<Package> calculatePossiblePackagesToDelete(PackageDependencyGraph dependencyGraph) {
        int smallestAmountOfReferences = Integer.MAX_VALUE;
        for (Package pack : dependencyGraph.getAllPackages()) {
            if (this.getListWithoutDuplicates(dependencyGraph.getDependencies().get(pack)).size() >= smallestAmountOfReferences) continue;
            smallestAmountOfReferences = this.getListWithoutDuplicates(dependencyGraph.getDependencies().get(pack)).size();
        }
        ArrayList<Package> packagesToDeleteList = new ArrayList<Package>();
        for (Package pack : dependencyGraph.getAllPackages()) {
            if (this.getListWithoutDuplicates(dependencyGraph.getDependencies().get(pack)).size() != smallestAmountOfReferences) continue;
            packagesToDeleteList.add(pack);
        }
        return packagesToDeleteList;
    }

    private Package getPackageWithFewestDependencies(ArrayList<Package> packagesToDeleteList, PackageDependencyGraph dependencyGraph) {
        Package packageToDelete = null;
        if (packagesToDeleteList.size() == 1) {
            packageToDelete = packagesToDeleteList.get(0);
        } else if (packagesToDeleteList.size() > 1) {
            packageToDelete = this.chooseBestPackageToDelete(packagesToDeleteList, dependencyGraph);
        }
        return packageToDelete;
    }

    private Package chooseBestPackageToDelete(ArrayList<Package> packagesToDeleteList, PackageDependencyGraph dependencyGraph) {
        Package packageToDelete = packagesToDeleteList.get(0);
        for (Package deletionCandidate : packagesToDeleteList) {
            if (dependencyGraph.getDependencies().get(deletionCandidate).size() >= dependencyGraph.getDependencies().get(packageToDelete).size()) continue;
            packageToDelete = deletionCandidate;
        }
        return packageToDelete;
    }

    private Package deletePackage(Package packageToDelete, PackageDependencyGraph dependencyGraph) {
        Package deletedPackage = null;
        System.out.println("\t\t\tDelete package: " + packageToDelete);
        for (Package key : dependencyGraph.getAllPackages()) {
            if (key == null || !key.equals(packageToDelete)) continue;
            EcoreUtil.delete((EObject)key, (boolean)true);
            deletedPackage = key;
        }
        dependencyGraph.removePackage(packageToDelete);
        return deletedPackage;
    }

    private <T> ArrayList<T> getListWithoutDuplicates(List<T> arlList) {
        ArrayList<T> result = new ArrayList<T>(arlList.size());
        HashSet<T> h = new HashSet<T>(arlList);
        result.addAll(h);
        return result;
    }
}

