/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.ecore;

import org.apache.log4j.Appender;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.tests.PivotTestCaseWithAutoTearDown;
import org.eclipse.ocl.examples.xtext.tests.TestCaseAppender;
import org.eclipse.ocl.examples.xtext.tests.TestCaseLogger;
import org.eclipse.ocl.pivot.internal.resource.ProjectMap;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public abstract class AbstractProjectMapTest
extends PivotTestCaseWithAutoTearDown {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        TestCaseAppender.INSTANCE.install();
    }

    protected void doTestProjectMap_LoadBoth(EPackage ePackage, @NonNull String project, @NonNull String modelPath, @NonNull String fragment) {
        ProjectMap.getResourceFactoryRegistry(null).getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        @NonNull URI platformPluginURI = URI.createPlatformPluginURI((String)modelPath, (boolean)true);
        @NonNull URI platformResourceURI = URI.createPlatformResourceURI((String)modelPath, (boolean)true);
        @NonNull URI nsURI = URI.createURI((String)ePackage.getNsURI());
        @NonNull URI platformPluginEObjectURI = platformPluginURI.appendFragment(fragment);
        @NonNull URI platformResourceEObjectURI = platformResourceURI.appendFragment(fragment);
        ProjectManager.IProjectDescriptor projectDescriptor = AbstractProjectMapTest.getProjectMap().getProjectDescriptor(project);
        assert (projectDescriptor != null);
        ProjectManager.IPackageDescriptor packageDescriptor = projectDescriptor.getPackageDescriptor(nsURI);
        assert (packageDescriptor != null);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        AbstractProjectMapTest.getProjectMap().initializeResourceSet((ResourceSet)resourceSet);
        packageDescriptor.configure((ResourceSet)resourceSet, StandaloneProjectMap.LoadBothStrategy.INSTANCE, null);
        EPackage nsEPackage = resourceSet.getPackageRegistry().getEPackage(nsURI.toString());
        EObject platformPluginEObject = resourceSet.getEObject(platformPluginEObjectURI, true);
        EObject platformResourceEObject = resourceSet.getEObject(platformResourceEObjectURI, true);
        AbstractProjectMapTest.assertTrue((boolean)ClassUtil.isRegistered((Resource)nsEPackage.eResource()));
        AbstractProjectMapTest.assertFalse((boolean)ClassUtil.isRegistered((Resource)platformPluginEObject.eResource()));
        AbstractProjectMapTest.assertEquals((String)nsURI.toString(), (String)nsEPackage.getNsURI());
        AbstractProjectMapTest.assertEquals((Object)platformPluginURI, (Object)platformPluginEObject.eResource().getURI());
        AbstractProjectMapTest.assertFalse((nsEPackage == platformPluginEObject ? 1 : 0) != 0);
        AbstractProjectMapTest.assertEquals((Object)platformPluginEObject, (Object)platformResourceEObject);
        resourceSet = new ResourceSetImpl();
        AbstractProjectMapTest.getProjectMap().initializeResourceSet((ResourceSet)resourceSet);
        packageDescriptor.configure((ResourceSet)resourceSet, StandaloneProjectMap.LoadBothStrategy.INSTANCE, null);
        EObject platformPluginEObject2 = resourceSet.getEObject(platformPluginEObjectURI, true);
        EObject platformResourceEObject2 = resourceSet.getEObject(platformResourceEObjectURI, true);
        EPackage nsEPackage2 = resourceSet.getPackageRegistry().getEPackage(nsURI.toString());
        AbstractProjectMapTest.assertTrue((boolean)ClassUtil.isRegistered((Resource)nsEPackage2.eResource()));
        AbstractProjectMapTest.assertFalse((boolean)ClassUtil.isRegistered((Resource)platformPluginEObject2.eResource()));
        AbstractProjectMapTest.assertEquals((String)nsURI.toString(), (String)nsEPackage2.getNsURI());
        AbstractProjectMapTest.assertEquals((Object)platformPluginURI, (Object)platformPluginEObject2.eResource().getURI());
        AbstractProjectMapTest.assertFalse((nsEPackage2 == platformPluginEObject2 ? 1 : 0) != 0);
        AbstractProjectMapTest.assertEquals((Object)platformPluginEObject2, (Object)platformResourceEObject2);
        resourceSet = new ResourceSetImpl();
        AbstractProjectMapTest.getProjectMap().initializeResourceSet((ResourceSet)resourceSet);
        packageDescriptor.configure((ResourceSet)resourceSet, StandaloneProjectMap.LoadBothStrategy.INSTANCE, null);
        EObject platformResourceEObject3 = resourceSet.getEObject(platformResourceEObjectURI, true);
        platformPluginEObject = resourceSet.getEObject(platformPluginEObjectURI, true);
        nsEPackage2 = resourceSet.getPackageRegistry().getEPackage(nsURI.toString());
        AbstractProjectMapTest.assertTrue((boolean)ClassUtil.isRegistered((Resource)nsEPackage2.eResource()));
        AbstractProjectMapTest.assertFalse((boolean)ClassUtil.isRegistered((Resource)platformPluginEObject.eResource()));
        AbstractProjectMapTest.assertEquals((String)nsURI.toString(), (String)nsEPackage2.getNsURI());
        AbstractProjectMapTest.assertEquals((Object)platformResourceURI, (Object)platformPluginEObject.eResource().getURI());
        AbstractProjectMapTest.assertFalse((nsEPackage2 == platformPluginEObject ? 1 : 0) != 0);
        AbstractProjectMapTest.assertEquals((Object)platformPluginEObject, (Object)platformResourceEObject3);
    }

    protected void doTestProjectMap_LoadDefault(EPackage ePackage, @NonNull String project, @NonNull String modelPath, @NonNull String fragment, boolean selfReferential) {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            ProjectMap.getResourceFactoryRegistry(null).getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
            @NonNull URI platformPluginURI = URI.createPlatformPluginURI((String)modelPath, (boolean)true);
            @NonNull URI platformResourceURI = URI.createPlatformResourceURI((String)modelPath, (boolean)true);
            @NonNull URI nsURI = URI.createURI((String)ePackage.getNsURI());
            @NonNull URI platformPluginEObjectURI = platformPluginURI.appendFragment(fragment);
            @NonNull URI platformResourceEObjectURI = platformResourceURI.appendFragment(fragment);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            AbstractProjectMapTest.getProjectMap().initializeResourceSet((ResourceSet)resourceSet);
            EPackage nsEPackage = resourceSet.getPackageRegistry().getEPackage(nsURI.toString());
            EObject platformPluginEObject = resourceSet.getEObject(platformPluginEObjectURI, true);
            EObject platformResourceEObject = resourceSet.getEObject(platformResourceEObjectURI, true);
            AbstractProjectMapTest.assertTrue((boolean)ClassUtil.isRegistered((Resource)nsEPackage.eResource()));
            AbstractProjectMapTest.assertEquals((String)nsURI.toString(), (String)nsEPackage.getNsURI());
            AbstractProjectMapTest.assertEquals((Object)nsEPackage, (Object)platformPluginEObject);
            AbstractProjectMapTest.assertEquals((Object)nsEPackage, (Object)platformResourceEObject);
            AbstractProjectMapTest.assertEquals((String)("Conflicting access to '" + platformResourceURI + "' or '" + platformPluginURI + "' already accessed as '" + nsURI + "'"), (String)TestCaseLogger.INSTANCE.get());
            TestCaseLogger.INSTANCE.clear();
            resourceSet = new ResourceSetImpl();
            AbstractProjectMapTest.getProjectMap().initializeResourceSet((ResourceSet)resourceSet);
            EObject platformPluginEObject2 = resourceSet.getEObject(platformPluginEObjectURI, true);
            EObject platformResourceEObject2 = resourceSet.getEObject(platformResourceEObjectURI, true);
            EPackage nsEPackage2 = resourceSet.getPackageRegistry().getEPackage(nsURI.toString());
            AbstractProjectMapTest.assertEquals((boolean)selfReferential, (boolean)ClassUtil.isRegistered((Resource)nsEPackage2.eResource()));
            AbstractProjectMapTest.assertEquals((boolean)selfReferential, (!platformPluginURI.equals(nsEPackage2.eResource().getURI()) ? 1 : 0) != 0);
            AbstractProjectMapTest.assertEquals((boolean)selfReferential, (nsEPackage2 != platformPluginEObject2 ? 1 : 0) != 0);
            AbstractProjectMapTest.assertEquals((Object)platformPluginEObject2, (Object)platformResourceEObject2);
            if (!selfReferential) {
                AbstractProjectMapTest.assertEquals((String)(selfReferential ? "" : "Conflicting access to '" + nsURI + "' already accessed as '" + platformPluginURI + "'"), (String)TestCaseLogger.INSTANCE.get());
            }
            TestCaseLogger.INSTANCE.clear();
            resourceSet = new ResourceSetImpl();
            AbstractProjectMapTest.getProjectMap().initializeResourceSet((ResourceSet)resourceSet);
            EObject platformResourceEObject3 = resourceSet.getEObject(platformResourceEObjectURI, true);
            platformPluginEObject = resourceSet.getEObject(platformPluginEObjectURI, true);
            nsEPackage2 = resourceSet.getPackageRegistry().getEPackage(nsURI.toString());
            AbstractProjectMapTest.assertEquals((boolean)selfReferential, (boolean)ClassUtil.isRegistered((Resource)nsEPackage2.eResource()));
            AbstractProjectMapTest.assertEquals((boolean)selfReferential, (!platformResourceURI.equals(nsEPackage2.eResource().getURI()) ? 1 : 0) != 0);
            AbstractProjectMapTest.assertEquals((boolean)selfReferential, (nsEPackage2 != platformPluginEObject ? 1 : 0) != 0);
            AbstractProjectMapTest.assertEquals((Object)platformPluginEObject, (Object)platformResourceEObject3);
            if (!selfReferential) {
                AbstractProjectMapTest.assertEquals((String)(selfReferential ? "" : "Conflicting access to '" + nsURI + "' already accessed as '" + platformResourceURI + "'"), (String)TestCaseLogger.INSTANCE.get());
            }
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    protected void doTestProjectMap_LoadEPackage(EPackage ePackage, @NonNull String project, @NonNull String modelPath, @NonNull String fragment) {
        ProjectMap.getResourceFactoryRegistry(null).getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        @NonNull URI platformPluginURI = URI.createPlatformPluginURI((String)modelPath, (boolean)true);
        @NonNull URI platformResourceURI = URI.createPlatformResourceURI((String)modelPath, (boolean)true);
        @NonNull URI nsURI = URI.createURI((String)ePackage.getNsURI());
        @NonNull URI platformPluginEObjectURI = platformPluginURI.appendFragment(fragment);
        @NonNull URI platformResourceEObjectURI = platformResourceURI.appendFragment(fragment);
        ProjectManager.IProjectDescriptor projectDescriptor = AbstractProjectMapTest.getProjectMap().getProjectDescriptor(project);
        assert (projectDescriptor != null);
        ProjectManager.IPackageDescriptor packageDescriptor = projectDescriptor.getPackageDescriptor(nsURI);
        assert (packageDescriptor != null);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        AbstractProjectMapTest.getProjectMap().initializeResourceSet((ResourceSet)resourceSet);
        packageDescriptor.configure((ResourceSet)resourceSet, StandaloneProjectMap.LoadGeneratedPackageStrategy.INSTANCE, null);
        EPackage nsEPackage = resourceSet.getPackageRegistry().getEPackage(nsURI.toString());
        EObject platformPluginEObject = resourceSet.getEObject(platformPluginEObjectURI, true);
        EObject platformResourceEObject = resourceSet.getEObject(platformResourceEObjectURI, true);
        AbstractProjectMapTest.assertTrue((boolean)ClassUtil.isRegistered((Resource)nsEPackage.eResource()));
        AbstractProjectMapTest.assertEquals((String)nsURI.toString(), (String)nsEPackage.getNsURI());
        AbstractProjectMapTest.assertEquals((Object)nsEPackage, (Object)platformPluginEObject);
        AbstractProjectMapTest.assertEquals((Object)nsEPackage, (Object)platformResourceEObject);
        resourceSet = new ResourceSetImpl();
        AbstractProjectMapTest.getProjectMap().initializeResourceSet((ResourceSet)resourceSet);
        packageDescriptor.configure((ResourceSet)resourceSet, StandaloneProjectMap.LoadGeneratedPackageStrategy.INSTANCE, null);
        EObject platformPluginEObject2 = resourceSet.getEObject(platformPluginEObjectURI, true);
        EObject platformResourceEObject2 = resourceSet.getEObject(platformResourceEObjectURI, true);
        EPackage nsEPackage2 = resourceSet.getPackageRegistry().getEPackage(nsURI.toString());
        AbstractProjectMapTest.assertTrue((boolean)ClassUtil.isRegistered((Resource)nsEPackage2.eResource()));
        AbstractProjectMapTest.assertEquals((String)nsURI.toString(), (String)nsEPackage2.getNsURI());
        AbstractProjectMapTest.assertEquals((Object)nsEPackage2, (Object)platformPluginEObject2);
        AbstractProjectMapTest.assertEquals((Object)nsEPackage2, (Object)platformResourceEObject2);
        resourceSet = new ResourceSetImpl();
        AbstractProjectMapTest.getProjectMap().initializeResourceSet((ResourceSet)resourceSet);
        packageDescriptor.configure((ResourceSet)resourceSet, StandaloneProjectMap.LoadGeneratedPackageStrategy.INSTANCE, null);
        EObject platformResourceEObject3 = resourceSet.getEObject(platformResourceEObjectURI, true);
        platformPluginEObject = resourceSet.getEObject(platformPluginEObjectURI, true);
        nsEPackage2 = resourceSet.getPackageRegistry().getEPackage(nsURI.toString());
        AbstractProjectMapTest.assertTrue((boolean)ClassUtil.isRegistered((Resource)nsEPackage2.eResource()));
        AbstractProjectMapTest.assertEquals((String)nsURI.toString(), (String)nsEPackage2.getNsURI());
        AbstractProjectMapTest.assertEquals((Object)nsEPackage2, (Object)platformPluginEObject);
        AbstractProjectMapTest.assertEquals((Object)nsEPackage2, (Object)platformResourceEObject3);
    }

    protected void doTestProjectMap_LoadFirst(EPackage ePackage, @NonNull String project, @NonNull String modelPath, @NonNull String fragment, boolean selfReferential) {
        ProjectMap.getResourceFactoryRegistry(null).getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        @NonNull URI platformPluginURI = URI.createPlatformPluginURI((String)modelPath, (boolean)true);
        @NonNull URI platformResourceURI = URI.createPlatformResourceURI((String)modelPath, (boolean)true);
        @NonNull URI nsURI = URI.createURI((String)ePackage.getNsURI());
        @NonNull URI platformPluginEObjectURI = platformPluginURI.appendFragment(fragment);
        @NonNull URI platformResourceEObjectURI = platformResourceURI.appendFragment(fragment);
        ProjectManager.IProjectDescriptor projectDescriptor = AbstractProjectMapTest.getProjectMap().getProjectDescriptor(project);
        assert (projectDescriptor != null);
        ProjectManager.IPackageDescriptor packageDescriptor = projectDescriptor.getPackageDescriptor(nsURI);
        assert (packageDescriptor != null);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        AbstractProjectMapTest.getProjectMap().initializeResourceSet((ResourceSet)resourceSet);
        packageDescriptor.configure((ResourceSet)resourceSet, StandaloneProjectMap.LoadFirstStrategy.INSTANCE, StandaloneProjectMap.MapToFirstConflictHandler.INSTANCE);
        EPackage nsEPackage = resourceSet.getPackageRegistry().getEPackage(nsURI.toString());
        EObject platformPluginEObject = resourceSet.getEObject(platformPluginEObjectURI, true);
        EObject platformResourceEObject = resourceSet.getEObject(platformResourceEObjectURI, true);
        AbstractProjectMapTest.assertTrue((boolean)ClassUtil.isRegistered((Resource)nsEPackage.eResource()));
        AbstractProjectMapTest.assertEquals((String)nsURI.toString(), (String)nsEPackage.getNsURI());
        AbstractProjectMapTest.assertEquals((Object)nsEPackage, (Object)platformPluginEObject);
        AbstractProjectMapTest.assertEquals((Object)nsEPackage, (Object)platformResourceEObject);
        resourceSet.eAdapters().remove((Object)AbstractProjectMapTest.getProjectMap());
        resourceSet = new ResourceSetImpl();
        AbstractProjectMapTest.getProjectMap().initializeResourceSet((ResourceSet)resourceSet);
        packageDescriptor.configure((ResourceSet)resourceSet, StandaloneProjectMap.LoadFirstStrategy.INSTANCE, StandaloneProjectMap.MapToFirstConflictHandler.INSTANCE);
        EObject platformPluginEObject2 = resourceSet.getEObject(platformPluginEObjectURI, true);
        EObject platformResourceEObject2 = resourceSet.getEObject(platformResourceEObjectURI, true);
        EPackage nsEPackage2 = resourceSet.getPackageRegistry().getEPackage(nsURI.toString());
        AbstractProjectMapTest.assertEquals((boolean)selfReferential, (boolean)ClassUtil.isRegistered((Resource)nsEPackage2.eResource()));
        AbstractProjectMapTest.assertEquals((boolean)selfReferential, (!platformPluginURI.equals(nsEPackage2.eResource().getURI()) ? 1 : 0) != 0);
        AbstractProjectMapTest.assertEquals((boolean)selfReferential, (nsEPackage2 != platformPluginEObject2 ? 1 : 0) != 0);
        AbstractProjectMapTest.assertEquals((Object)platformPluginEObject2, (Object)platformResourceEObject2);
        resourceSet.eAdapters().remove((Object)AbstractProjectMapTest.getProjectMap());
        resourceSet = new ResourceSetImpl();
        AbstractProjectMapTest.getProjectMap().initializeResourceSet((ResourceSet)resourceSet);
        packageDescriptor.configure((ResourceSet)resourceSet, StandaloneProjectMap.LoadFirstStrategy.INSTANCE, StandaloneProjectMap.MapToFirstConflictHandler.INSTANCE);
        EObject platformResourceEObject3 = resourceSet.getEObject(platformResourceEObjectURI, true);
        platformPluginEObject = resourceSet.getEObject(platformPluginEObjectURI, true);
        nsEPackage2 = resourceSet.getPackageRegistry().getEPackage(nsURI.toString());
        AbstractProjectMapTest.assertEquals((boolean)selfReferential, (boolean)ClassUtil.isRegistered((Resource)nsEPackage2.eResource()));
        AbstractProjectMapTest.assertEquals((boolean)selfReferential, (!platformResourceURI.equals(nsEPackage2.eResource().getURI()) ? 1 : 0) != 0);
        AbstractProjectMapTest.assertEquals((boolean)selfReferential, (nsEPackage2 != platformPluginEObject ? 1 : 0) != 0);
        AbstractProjectMapTest.assertEquals((Object)platformPluginEObject, (Object)platformResourceEObject3);
        resourceSet.eAdapters().remove((Object)AbstractProjectMapTest.getProjectMap());
    }

    protected void doTestProjectMap_LoadModel(EPackage ePackage, @NonNull String project, @NonNull String modelPath, @NonNull String fragment, boolean selfReferential) {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            ProjectMap.getResourceFactoryRegistry(null).getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
            @NonNull URI platformPluginURI = URI.createPlatformPluginURI((String)modelPath, (boolean)true);
            @NonNull URI platformResourceURI = URI.createPlatformResourceURI((String)modelPath, (boolean)true);
            @NonNull URI nsURI = URI.createURI((String)ePackage.getNsURI());
            @NonNull URI platformPluginEObjectURI = platformPluginURI.appendFragment(fragment);
            @NonNull URI platformResourceEObjectURI = platformResourceURI.appendFragment(fragment);
            ProjectManager.IProjectDescriptor projectDescriptor = AbstractProjectMapTest.getProjectMap().getProjectDescriptor(project);
            assert (projectDescriptor != null);
            ProjectManager.IPackageDescriptor packageDescriptor = projectDescriptor.getPackageDescriptor(nsURI);
            assert (packageDescriptor != null);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            AbstractProjectMapTest.getProjectMap().initializeResourceSet((ResourceSet)resourceSet);
            packageDescriptor.configure((ResourceSet)resourceSet, StandaloneProjectMap.LoadDynamicResourceStrategy.INSTANCE, null);
            EPackage nsEPackage = resourceSet.getPackageRegistry().getEPackage(nsURI.toString());
            EObject platformPluginEObject = resourceSet.getEObject(platformPluginEObjectURI, true);
            EObject platformResourceEObject = resourceSet.getEObject(platformResourceEObjectURI, true);
            AbstractProjectMapTest.assertFalse((boolean)ClassUtil.isRegistered((Resource)nsEPackage.eResource()));
            AbstractProjectMapTest.assertEquals((Object)platformResourceURI, (Object)nsEPackage.eResource().getURI());
            AbstractProjectMapTest.assertEquals((Object)nsEPackage, (Object)platformPluginEObject);
            AbstractProjectMapTest.assertEquals((Object)nsEPackage, (Object)platformResourceEObject);
            AbstractProjectMapTest.assertEquals((String)(selfReferential ? "Attempt to load self-referential '" + nsURI + "' as model replaced by registered EPackage" : ""), (String)TestCaseLogger.INSTANCE.get());
            TestCaseLogger.INSTANCE.clear();
            resourceSet = new ResourceSetImpl();
            AbstractProjectMapTest.getProjectMap().initializeResourceSet((ResourceSet)resourceSet);
            packageDescriptor.configure((ResourceSet)resourceSet, StandaloneProjectMap.LoadDynamicResourceStrategy.INSTANCE, null);
            EObject platformPluginEObject2 = resourceSet.getEObject(platformPluginEObjectURI, true);
            EObject platformResourceEObject2 = resourceSet.getEObject(platformResourceEObjectURI, true);
            EPackage nsEPackage2 = resourceSet.getPackageRegistry().getEPackage(nsURI.toString());
            AbstractProjectMapTest.assertEquals((boolean)false, (boolean)ClassUtil.isRegistered((Resource)nsEPackage2.eResource()));
            AbstractProjectMapTest.assertEquals((boolean)false, (!platformPluginURI.equals(nsEPackage2.eResource().getURI()) ? 1 : 0) != 0);
            AbstractProjectMapTest.assertEquals((boolean)false, (nsEPackage2 != platformPluginEObject2 ? 1 : 0) != 0);
            AbstractProjectMapTest.assertEquals((Object)platformPluginEObject2, (Object)platformResourceEObject2);
            TestCaseLogger.INSTANCE.clear();
            resourceSet = new ResourceSetImpl();
            AbstractProjectMapTest.getProjectMap().initializeResourceSet((ResourceSet)resourceSet);
            packageDescriptor.configure((ResourceSet)resourceSet, StandaloneProjectMap.LoadDynamicResourceStrategy.INSTANCE, null);
            EObject platformResourceEObject3 = resourceSet.getEObject(platformResourceEObjectURI, true);
            platformPluginEObject = resourceSet.getEObject(platformPluginEObjectURI, true);
            nsEPackage2 = resourceSet.getPackageRegistry().getEPackage(nsURI.toString());
            AbstractProjectMapTest.assertEquals((boolean)false, (boolean)ClassUtil.isRegistered((Resource)nsEPackage2.eResource()));
            AbstractProjectMapTest.assertEquals((boolean)false, (!platformResourceURI.equals(nsEPackage2.eResource().getURI()) ? 1 : 0) != 0);
            AbstractProjectMapTest.assertEquals((boolean)false, (nsEPackage2 != platformPluginEObject ? 1 : 0) != 0);
            AbstractProjectMapTest.assertEquals((Object)platformPluginEObject, (Object)platformResourceEObject3);
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }
}

