/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.standalone;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.export.IValidityExporter;
import org.eclipse.ocl.examples.emf.validation.validity.export.ModelExporter;
import org.eclipse.ocl.examples.standalone.StandaloneApplication;
import org.eclipse.ocl.examples.standalone.StandaloneCommand;
import org.eclipse.ocl.examples.standalone.StandaloneResponse;
import org.eclipse.ocl.examples.standalone.messages.StandaloneMessages;
import org.eclipse.ocl.examples.test.standalone.StandaloneTestCase;
import org.eclipse.ocl.examples.validity.locator.AbstractPivotConstraintLocator;
import org.eclipse.ocl.examples.xtext.tests.TestCaseLogger;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.internal.validation.PivotEAnnotationValidator;
import org.junit.Test;

public class StandaloneExecutionTests
extends StandaloneTestCase {
    protected static int EXTRA_EAnnotationValidator_SUCCESSES = PivotEAnnotationValidator.getEAnnotationValidatorRegistry() != null ? 3 : 0;

    protected static void assertNoLogFile(@NonNull String logFileName) {
        File file = new File(logFileName);
        StandaloneExecutionTests.assertFalse((boolean)file.exists());
    }

    private void doFailingTest(@NonNull String @NonNull [] arguments) throws Exception {
        StandaloneApplication validityApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = validityApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.FAIL, (Object)applicationResponse);
        validityApplication.stop();
    }

    private void doOKTest(@NonNull String @NonNull [] arguments) throws Exception {
        StandaloneApplication validityApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = validityApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        validityApplication.stop();
    }

    private @NonNull List<String> checkLogFile(@NonNull String logFileName, int oks, int infos, int warnings, int errors, int fails) throws IOException {
        File file = new File(logFileName);
        StandaloneExecutionTests.assertTrue((boolean)file.exists());
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader r = new BufferedReader(new FileReader(file));
        int metricsLine = 0;
        String line = r.readLine();
        while (line != null) {
            if ("==== METRICS ====".equals(line)) {
                metricsLine = lines.size();
            }
            lines.add(line);
            line = r.readLine();
        }
        r.close();
        StandaloneExecutionTests.assertEquals((String)("- Number of Success: " + oks), (String)((String)lines.get(metricsLine + 2)));
        StandaloneExecutionTests.assertEquals((String)("- Number of Infos: " + infos), (String)((String)lines.get(metricsLine + 3)));
        StandaloneExecutionTests.assertEquals((String)("- Number of Warnings: " + warnings), (String)((String)lines.get(metricsLine + 4)));
        StandaloneExecutionTests.assertEquals((String)("- Number of Errors: " + errors), (String)((String)lines.get(metricsLine + 5)));
        StandaloneExecutionTests.assertEquals((String)("- Number of Failures: " + fails), (String)((String)lines.get(metricsLine + 6)));
        return lines;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        AbstractPivotConstraintLocator.initialize();
    }

    @Test
    public void test_help() throws Exception {
        StringWriter outputStream = new StringWriter();
        Appendable savedDefaultOutputStream = StandaloneCommand.setDefaultOutputStream((Appendable)outputStream);
        @NonNull String @NonNull [] arguments = new String[]{"help"};
        this.doOKTest(arguments);
        String s = outputStream.toString();
        assert (s.contains(StandaloneMessages.Standalone_Help));
        assert (s.contains(StandaloneMessages.HelpCommand_Help));
        assert (s.contains(StandaloneMessages.ValidateCommand_Help));
        StandaloneCommand.setDefaultOutputStream((Appendable)savedDefaultOutputStream);
    }

    @Test
    public void test_mandatoryArgumentsOnly() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI)};
        this.doOKTest(arguments);
        StandaloneExecutionTests.assertNoLogFile(this.getTextLogFileName());
    }

    @Test
    public void test_missingOutputArgument() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output"};
            this.doFailingTest(arguments);
            StandaloneExecutionTests.assertNoLogFile(this.getTextLogFileName());
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneExecutionTests.assertTrue((boolean)logMessage.contains("Missing argument for"));
            StandaloneExecutionTests.assertTrue((boolean)logMessage.contains("-output"));
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void test_missingExporterArgument() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-exporter"};
            this.doFailingTest(arguments);
            StandaloneExecutionTests.assertNoLogFile(this.getTextLogFileName());
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneExecutionTests.assertTrue((boolean)logMessage.contains("Missing argument for"));
            StandaloneExecutionTests.assertTrue((boolean)logMessage.contains("-exporter"));
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void test_missingUsingArgument() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-using"};
            this.doFailingTest(arguments);
            StandaloneExecutionTests.assertNoLogFile(this.getTextLogFileName());
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneExecutionTests.assertTrue((boolean)logMessage.contains("No argument for"));
            StandaloneExecutionTests.assertTrue((boolean)logMessage.contains("-using"));
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void test_textExportedFile() throws Exception {
        String textLogFileName = this.getTextLogFileName();
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", textLogFileName, "-exporter", "text"};
        this.doOKTest(arguments);
        this.checkLogFile(textLogFileName, 36 + EXTRA_EAnnotationValidator_SUCCESSES, 1, 1, 1, 0);
    }

    @Test
    public void test_modelExportedFile() throws Exception {
        String modelLogFileName = this.getLogFileName((IValidityExporter)ModelExporter.INSTANCE);
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", modelLogFileName, "-exporter", "model"};
        this.doOKTest(arguments);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URI newFileURI = URI.createFileURI((String)modelLogFileName);
        Resource newResource = resourceSet.getResource(newFileURI, true);
        EObject eObject = (EObject)newResource.getContents().get(0);
        StandaloneExecutionTests.assertTrue((boolean)(eObject instanceof RootNode));
        String referenceName = newFileURI.trimFileExtension().appendFileExtension(PivotEAnnotationValidator.getEAnnotationValidatorRegistry() != null ? "referenceWithEAnnotationValidators" : "reference").appendFileExtension("validity").lastSegment();
        Resource refResource = resourceSet.getResource(StandaloneExecutionTests.getTestModelURI("models/standalone/" + referenceName), true);
        refResource.setURI(newFileURI);
        TestUtil.assertSameModel(refResource, newResource);
    }

    @Test
    public void test_htmlExportedFile() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getHTMLLogFileName(), "-exporter", "html"};
        this.doOKTest(arguments);
        StandaloneExecutionTests.assertTrue((boolean)StandaloneCommand.getURIConverter().exists(URI.createFileURI((String)this.getHTMLLogFileName()), null));
    }

    @Test
    public void test_unknownExporter() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "anotherExporterAttribute"};
        this.doFailingTest(arguments);
        StandaloneExecutionTests.assertNoLogFile(this.getTextLogFileName());
    }

    @Test
    public void test_nonExistentModelFile() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            String textLogFileName = this.getTextLogFileName();
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(StandaloneExecutionTests.getTestModelURI("models/nonExistentModel.ecore")), "-rules", String.valueOf(this.inputOCLURI), "-output", textLogFileName, "-exporter", "text"};
            this.doFailingTest(arguments);
            StandaloneExecutionTests.assertNoLogFile(textLogFileName);
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneExecutionTests.assertTrue((boolean)logMessage.contains("does not exist"));
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void test_nonExistentOclFile() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            String textLogFileName = this.getTextLogFileName();
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(StandaloneExecutionTests.getTestModelURI("models/nonExistentFile.ocl")), "-output", textLogFileName, "-exporter", "text"};
            this.doOKTest(arguments);
            this.checkLogFile(textLogFileName, 30 + EXTRA_EAnnotationValidator_SUCCESSES, 0, 0, 0, 0);
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneExecutionTests.assertTrue((boolean)logMessage.contains("does not exist"));
            StandaloneExecutionTests.assertTrue((boolean)logMessage.contains("ignored"));
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void test_nonExistentOutputFolder() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            String nonExistentOutputFolderPath = "nonExistent/anotherName.txt";
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", nonExistentOutputFolderPath, "-exporter", "text"};
            this.doFailingTest(arguments);
            StandaloneExecutionTests.assertNoLogFile(nonExistentOutputFolderPath);
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneExecutionTests.assertTrue((boolean)logMessage.contains("does not exist"));
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void test_listOfOCLFiles() throws Exception {
        String textLogFileName = this.getTextLogFileName();
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.textInputOCLURI), "-output", textLogFileName, "-exporter", "text"};
        this.doOKTest(arguments);
        this.checkLogFile(textLogFileName, 42 + EXTRA_EAnnotationValidator_SUCCESSES, 2, 2, 2, 0);
    }

    @Test
    public void test_listOfOCLFilesToStdout() throws Exception {
        Appendable savedDefaultOutputStream = StandaloneCommand.setDefaultOutputStream((Appendable)NullAppendable.INSTANCE);
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.textInputOCLURI), "-exporter", "text"};
        this.doOKTest(arguments);
        StandaloneExecutionTests.assertNoLogFile(this.getTextLogFileName());
        StandaloneCommand.setDefaultOutputStream((Appendable)savedDefaultOutputStream);
    }

    private static final class NullAppendable
    implements Appendable {
        public static final @NonNull Appendable INSTANCE = new NullAppendable();

        private NullAppendable() {
        }

        @Override
        public Appendable append(CharSequence csq) throws IOException {
            return null;
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            return null;
        }

        @Override
        public Appendable append(char c) throws IOException {
            return null;
        }
    }
}

