/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcoreEvaluationEnvironment;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.helper.ChoiceKind;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.helper.OCLHelper;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;

public class EcoreEnvironmentTest
extends AbstractTestSuite {
    public void test_globalEPackageRegistry_lookup() {
        this.helper.setContext((Object)EcorePackage.eINSTANCE.getEClassifier());
        String EXPRESSION = "ocltest::Color::";
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "ocltest::Color::");
        EcoreEnvironmentTest.assertNotNull((Object)choices);
        EcoreEnvironmentTest.assertFalse((boolean)choices.isEmpty());
        this.assertChoice(choices, ChoiceKind.ENUMERATION_LITERAL, "green");
        resourceSet.getPackageRegistry().remove((Object)((EPackage)this.fruitPackage).getNsURI());
        choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "ocltest::Color::");
        EcoreEnvironmentTest.assertNotNull((Object)choices);
        EcoreEnvironmentTest.assertTrue((boolean)choices.isEmpty());
    }

    public void test_customEPackageRegistry_lookup() {
        EPackageRegistryImpl registry = new EPackageRegistryImpl();
        this.ocl.dispose();
        this.ocl = OCL.newInstance((EnvironmentFactory)new EcoreEnvironmentFactory((EPackage.Registry)registry));
        OCLHelper helper = this.ocl.createOCLHelper();
        helper.setContext((Object)EcorePackage.eINSTANCE.getEClassifier());
        String EXPRESSION = "ocltest::Color::";
        List choices = helper.getSyntaxHelp(ConstraintKind.INVARIANT, "ocltest::Color::");
        EcoreEnvironmentTest.assertNotNull((Object)choices);
        EcoreEnvironmentTest.assertTrue((boolean)choices.isEmpty());
        registry.put((Object)((EPackage)this.fruitPackage).getNsURI(), (Object)this.fruitPackage);
        choices = helper.getSyntaxHelp(ConstraintKind.INVARIANT, "ocltest::Color::");
        EcoreEnvironmentTest.assertNotNull((Object)choices);
        EcoreEnvironmentTest.assertFalse((boolean)choices.isEmpty());
        this.assertChoice(choices, ChoiceKind.ENUMERATION_LITERAL, "green");
    }

    public void test_evaluationEnvironment_getType_178901() {
        EvaluationEnvironment evalEnv = this.ocl.getEvaluationEnvironment();
        EcoreEnvironmentTest.assertSame((Object)EcorePackage.Literals.EPACKAGE, (Object)evalEnv.getType((Object)this.fruitPackage));
        EcoreEnvironmentTest.assertSame((Object)EcorePackage.Literals.ECLASS, (Object)evalEnv.getType((Object)this.fruit));
        EcoreEnvironmentTest.assertSame((Object)EcorePackage.Literals.ERESOURCE_SET, (Object)evalEnv.getType((Object)new ResourceSetImpl()));
        EcoreEnvironmentTest.assertSame((Object)this.getOCLStandardLibrary().getString(), (Object)evalEnv.getType((Object)"foo"));
        EcoreEnvironmentTest.assertSame((Object)this.getOCLStandardLibrary().getOclAny(), (Object)evalEnv.getType((Object)this));
    }

    public void test_extensibility_156360() {
        this.ocl.dispose();
        OCL ocl = OCL.newInstance((EnvironmentFactory)new MyEnvironmentFactory());
        OCL.Helper helper = ocl.createOCLHelper();
        helper.setContext((Object)EcorePackage.Literals.ESTRING);
        Constraint constraint = null;
        try {
            constraint = (Constraint)helper.createInvariant("self.regexMatch('\\\\d{3}-\\\\d{3}-\\\\d{3}') <> null");
        }
        catch (Exception e) {
            EcoreEnvironmentTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        EcoreEnvironmentTest.assertTrue((boolean)ocl.check((Object)"123-456-789", (Object)constraint));
        EcoreEnvironmentTest.assertFalse((boolean)ocl.check((Object)"123-4567-890", (Object)constraint));
        EcoreEnvironmentTest.assertFalse((boolean)ocl.check((Object)"123-abc-456", (Object)constraint));
    }

    public void test_extensibility_156360_with_backslash_escaping() {
        Constraint constraint;
        OCL ocl;
        block5: {
            ocl = OCL.newInstance((EnvironmentFactory)new MyEnvironmentFactory());
            OCL.Helper helper = ocl.createOCLHelper();
            helper.setContext((Object)EcorePackage.Literals.ESTRING);
            constraint = null;
            Boolean oldBackslashProcessingEnabled = (Boolean)ParsingOptions.getValue((Environment)ocl.getEnvironment(), (Option)ParsingOptions.USE_BACKSLASH_ESCAPE_PROCESSING);
            ParsingOptions.setOption((Environment)ocl.getEnvironment(), (Option)ParsingOptions.USE_BACKSLASH_ESCAPE_PROCESSING, (Object)true);
            try {
                try {
                    constraint = (Constraint)helper.createInvariant("self.regexMatch('\\\\d{3}-\\\\d{3}-\\\\d{3}') <> null");
                }
                catch (Exception e) {
                    EcoreEnvironmentTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
                    ParsingOptions.setOption((Environment)ocl.getEnvironment(), (Option)ParsingOptions.USE_BACKSLASH_ESCAPE_PROCESSING, (Object)oldBackslashProcessingEnabled);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                ParsingOptions.setOption((Environment)ocl.getEnvironment(), (Option)ParsingOptions.USE_BACKSLASH_ESCAPE_PROCESSING, (Object)oldBackslashProcessingEnabled);
                throw throwable;
            }
            ParsingOptions.setOption((Environment)ocl.getEnvironment(), (Option)ParsingOptions.USE_BACKSLASH_ESCAPE_PROCESSING, (Object)oldBackslashProcessingEnabled);
        }
        EcoreEnvironmentTest.assertTrue((boolean)ocl.check((Object)"123-456-789", (Object)constraint));
        EcoreEnvironmentTest.assertFalse((boolean)ocl.check((Object)"123-4567-890", (Object)constraint));
        EcoreEnvironmentTest.assertFalse((boolean)ocl.check((Object)"123-abc-456", (Object)constraint));
    }

    class MyEnvironment
    extends EcoreEnvironment {
        EOperation regexMatch;

        MyEnvironment(EcoreEnvironmentFactory factory) {
            super(factory, null);
            this.defineCustomOperations();
        }

        MyEnvironment(MyEnvironment parent) {
            super((Environment)parent);
            this.regexMatch = parent.regexMatch;
        }

        private void defineCustomOperations() {
            this.regexMatch = EcoreFactory.eINSTANCE.createEOperation();
            this.regexMatch.setName("regexMatch");
            this.regexMatch.setEType((EClassifier)this.getOCLStandardLibrary().getString());
            EParameter parm = EcoreFactory.eINSTANCE.createEParameter();
            parm.setName("pattern");
            parm.setEType((EClassifier)this.getOCLStandardLibrary().getString());
            this.regexMatch.getEParameters().add((Object)parm);
            EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource("MyEnvironment");
            this.regexMatch.getEAnnotations().add((Object)annotation);
            this.addHelperOperation((EClassifier)this.getOCLStandardLibrary().getString(), this.regexMatch);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyEnvironmentFactory
    extends EcoreEnvironmentFactory {
        MyEnvironmentFactory() {
        }

        public Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> createEnvironment() {
            MyEnvironment result = new MyEnvironment(this);
            return result;
        }

        public Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> createEnvironment(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent) {
            if (!(parent instanceof MyEnvironment)) {
                throw new IllegalArgumentException("Parent environment must be my environment: " + parent);
            }
            MyEnvironment result = new MyEnvironment((MyEnvironment)parent);
            return result;
        }

        public EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> createEvaluationEnvironment() {
            return new MyEvaluationEnvironment(this);
        }

        public EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> createEvaluationEnvironment(EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent) {
            return new MyEvaluationEnvironment(parent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyEvaluationEnvironment
    extends EcoreEvaluationEnvironment {
        MyEvaluationEnvironment(MyEnvironmentFactory factory) {
            super((EcoreEnvironmentFactory)factory);
        }

        MyEvaluationEnvironment(EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent) {
            super(parent);
        }

        public Object callOperation(EOperation operation, int opcode, Object source, Object[] args) {
            if (operation.getEAnnotation("MyEnvironment") == null) {
                return super.callOperation(operation, opcode, source, args);
            }
            if ("regexMatch".equals(operation.getName())) {
                Pattern pattern = Pattern.compile((String)args[0]);
                Matcher matcher = pattern.matcher((String)source);
                return matcher.matches() ? matcher.group() : null;
            }
            throw new UnsupportedOperationException();
        }
    }
}

