/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.hardware.sensor;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwLogical.HwDevice.HwDevicePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.papyrus.iotml.hardware.sensor.SensorFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/uml2/2.0.0/UML originalName='Sensor'"
 * @generated
 */
public interface SensorPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "sensor";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/papyrus/iotml/0.7/IoTML/Hardware/Sensor";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "Sensor";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	SensorPackage eINSTANCE = org.eclipse.papyrus.iotml.hardware.sensor.impl.SensorPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.iotml.hardware.sensor.impl.HwCommonSensorImpl <em>Hw Common Sensor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.impl.HwCommonSensorImpl
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.impl.SensorPackageImpl#getHwCommonSensor()
	 * @generated
	 */
	int HW_COMMON_SENSOR = 0;

	/**
	 * The feature id for the '<em><b>Res Mult</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_SENSOR__RES_MULT = HwDevicePackage.HW_SENSOR__RES_MULT;

	/**
	 * The feature id for the '<em><b>Is Protected</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_SENSOR__IS_PROTECTED = HwDevicePackage.HW_SENSOR__IS_PROTECTED;

	/**
	 * The feature id for the '<em><b>Is Active</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_SENSOR__IS_ACTIVE = HwDevicePackage.HW_SENSOR__IS_ACTIVE;

	/**
	 * The feature id for the '<em><b>Base Property</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_SENSOR__BASE_PROPERTY = HwDevicePackage.HW_SENSOR__BASE_PROPERTY;

	/**
	 * The feature id for the '<em><b>Base Instance Specification</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_SENSOR__BASE_INSTANCE_SPECIFICATION = HwDevicePackage.HW_SENSOR__BASE_INSTANCE_SPECIFICATION;

	/**
	 * The feature id for the '<em><b>Base Classifier</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_SENSOR__BASE_CLASSIFIER = HwDevicePackage.HW_SENSOR__BASE_CLASSIFIER;

	/**
	 * The feature id for the '<em><b>Base Lifeline</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_SENSOR__BASE_LIFELINE = HwDevicePackage.HW_SENSOR__BASE_LIFELINE;

	/**
	 * The feature id for the '<em><b>Base Connectable Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_SENSOR__BASE_CONNECTABLE_ELEMENT = HwDevicePackage.HW_SENSOR__BASE_CONNECTABLE_ELEMENT;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_SENSOR__DESCRIPTION = HwDevicePackage.HW_SENSOR__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Frequency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_SENSOR__FREQUENCY = HwDevicePackage.HW_SENSOR__FREQUENCY;

	/**
	 * The feature id for the '<em><b>End Points</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_SENSOR__END_POINTS = HwDevicePackage.HW_SENSOR__END_POINTS;

	/**
	 * The feature id for the '<em><b>PHW Services</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_SENSOR__PHW_SERVICES = HwDevicePackage.HW_SENSOR__PHW_SERVICES;

	/**
	 * The feature id for the '<em><b>RHW Services</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_SENSOR__RHW_SERVICES = HwDevicePackage.HW_SENSOR__RHW_SERVICES;

	/**
	 * The feature id for the '<em><b>Owned HW</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_SENSOR__OWNED_HW = HwDevicePackage.HW_SENSOR__OWNED_HW;

	/**
	 * The feature id for the '<em><b>Speed Factor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_SENSOR__SPEED_FACTOR = HwDevicePackage.HW_SENSOR__SPEED_FACTOR;

	/**
	 * The feature id for the '<em><b>Main Scheduler</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_SENSOR__MAIN_SCHEDULER = HwDevicePackage.HW_SENSOR__MAIN_SCHEDULER;

	/**
	 * The feature id for the '<em><b>Input Value Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_SENSOR__INPUT_VALUE_TYPE = HwDevicePackage.HW_SENSOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Output Value Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_SENSOR__OUTPUT_VALUE_TYPE = HwDevicePackage.HW_SENSOR_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Hwcommonsensor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_SENSOR__HWCOMMONSENSOR = HwDevicePackage.HW_SENSOR_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Transfer Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_SENSOR__TRANSFER_FUNCTION = HwDevicePackage.HW_SENSOR_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Hw Common Sensor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_SENSOR_FEATURE_COUNT = HwDevicePackage.HW_SENSOR_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.iotml.hardware.sensor.impl.HwRFIDReaderSensorImpl <em>Hw RFID Reader Sensor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.impl.HwRFIDReaderSensorImpl
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.impl.SensorPackageImpl#getHwRFIDReaderSensor()
	 * @generated
	 */
	int HW_RFID_READER_SENSOR = 1;

	/**
	 * The feature id for the '<em><b>Res Mult</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR__RES_MULT = HW_COMMON_SENSOR__RES_MULT;

	/**
	 * The feature id for the '<em><b>Is Protected</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR__IS_PROTECTED = HW_COMMON_SENSOR__IS_PROTECTED;

	/**
	 * The feature id for the '<em><b>Is Active</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR__IS_ACTIVE = HW_COMMON_SENSOR__IS_ACTIVE;

	/**
	 * The feature id for the '<em><b>Base Property</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR__BASE_PROPERTY = HW_COMMON_SENSOR__BASE_PROPERTY;

	/**
	 * The feature id for the '<em><b>Base Instance Specification</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR__BASE_INSTANCE_SPECIFICATION = HW_COMMON_SENSOR__BASE_INSTANCE_SPECIFICATION;

	/**
	 * The feature id for the '<em><b>Base Classifier</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR__BASE_CLASSIFIER = HW_COMMON_SENSOR__BASE_CLASSIFIER;

	/**
	 * The feature id for the '<em><b>Base Lifeline</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR__BASE_LIFELINE = HW_COMMON_SENSOR__BASE_LIFELINE;

	/**
	 * The feature id for the '<em><b>Base Connectable Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR__BASE_CONNECTABLE_ELEMENT = HW_COMMON_SENSOR__BASE_CONNECTABLE_ELEMENT;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR__DESCRIPTION = HW_COMMON_SENSOR__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Frequency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR__FREQUENCY = HW_COMMON_SENSOR__FREQUENCY;

	/**
	 * The feature id for the '<em><b>End Points</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR__END_POINTS = HW_COMMON_SENSOR__END_POINTS;

	/**
	 * The feature id for the '<em><b>PHW Services</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR__PHW_SERVICES = HW_COMMON_SENSOR__PHW_SERVICES;

	/**
	 * The feature id for the '<em><b>RHW Services</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR__RHW_SERVICES = HW_COMMON_SENSOR__RHW_SERVICES;

	/**
	 * The feature id for the '<em><b>Owned HW</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR__OWNED_HW = HW_COMMON_SENSOR__OWNED_HW;

	/**
	 * The feature id for the '<em><b>Speed Factor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR__SPEED_FACTOR = HW_COMMON_SENSOR__SPEED_FACTOR;

	/**
	 * The feature id for the '<em><b>Main Scheduler</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR__MAIN_SCHEDULER = HW_COMMON_SENSOR__MAIN_SCHEDULER;

	/**
	 * The feature id for the '<em><b>Input Value Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR__INPUT_VALUE_TYPE = HW_COMMON_SENSOR__INPUT_VALUE_TYPE;

	/**
	 * The feature id for the '<em><b>Output Value Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR__OUTPUT_VALUE_TYPE = HW_COMMON_SENSOR__OUTPUT_VALUE_TYPE;

	/**
	 * The feature id for the '<em><b>Hwcommonsensor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR__HWCOMMONSENSOR = HW_COMMON_SENSOR__HWCOMMONSENSOR;

	/**
	 * The feature id for the '<em><b>Transfer Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR__TRANSFER_FUNCTION = HW_COMMON_SENSOR__TRANSFER_FUNCTION;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR__TAG = HW_COMMON_SENSOR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Hw RFID Reader Sensor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_RFID_READER_SENSOR_FEATURE_COUNT = HW_COMMON_SENSOR_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.iotml.hardware.sensor.impl.HwTagImpl <em>Hw Tag</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.impl.HwTagImpl
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.impl.SensorPackageImpl#getHwTag()
	 * @generated
	 */
	int HW_TAG = 2;

	/**
	 * The feature id for the '<em><b>Res Mult</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_TAG__RES_MULT = HwDevicePackage.HW_IO__RES_MULT;

	/**
	 * The feature id for the '<em><b>Is Protected</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_TAG__IS_PROTECTED = HwDevicePackage.HW_IO__IS_PROTECTED;

	/**
	 * The feature id for the '<em><b>Is Active</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_TAG__IS_ACTIVE = HwDevicePackage.HW_IO__IS_ACTIVE;

	/**
	 * The feature id for the '<em><b>Base Property</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_TAG__BASE_PROPERTY = HwDevicePackage.HW_IO__BASE_PROPERTY;

	/**
	 * The feature id for the '<em><b>Base Instance Specification</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_TAG__BASE_INSTANCE_SPECIFICATION = HwDevicePackage.HW_IO__BASE_INSTANCE_SPECIFICATION;

	/**
	 * The feature id for the '<em><b>Base Classifier</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_TAG__BASE_CLASSIFIER = HwDevicePackage.HW_IO__BASE_CLASSIFIER;

	/**
	 * The feature id for the '<em><b>Base Lifeline</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_TAG__BASE_LIFELINE = HwDevicePackage.HW_IO__BASE_LIFELINE;

	/**
	 * The feature id for the '<em><b>Base Connectable Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_TAG__BASE_CONNECTABLE_ELEMENT = HwDevicePackage.HW_IO__BASE_CONNECTABLE_ELEMENT;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_TAG__DESCRIPTION = HwDevicePackage.HW_IO__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Frequency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_TAG__FREQUENCY = HwDevicePackage.HW_IO__FREQUENCY;

	/**
	 * The feature id for the '<em><b>End Points</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_TAG__END_POINTS = HwDevicePackage.HW_IO__END_POINTS;

	/**
	 * The feature id for the '<em><b>PHW Services</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_TAG__PHW_SERVICES = HwDevicePackage.HW_IO__PHW_SERVICES;

	/**
	 * The feature id for the '<em><b>RHW Services</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_TAG__RHW_SERVICES = HwDevicePackage.HW_IO__RHW_SERVICES;

	/**
	 * The feature id for the '<em><b>Owned HW</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_TAG__OWNED_HW = HwDevicePackage.HW_IO__OWNED_HW;

	/**
	 * The feature id for the '<em><b>Speed Factor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_TAG__SPEED_FACTOR = HwDevicePackage.HW_IO__SPEED_FACTOR;

	/**
	 * The feature id for the '<em><b>Main Scheduler</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_TAG__MAIN_SCHEDULER = HwDevicePackage.HW_IO__MAIN_SCHEDULER;

	/**
	 * The feature id for the '<em><b>Tage Frequency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_TAG__TAGE_FREQUENCY = HwDevicePackage.HW_IO_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Hw Tag</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_TAG_FEATURE_COUNT = HwDevicePackage.HW_IO_FEATURE_COUNT + 1;


	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.iotml.hardware.sensor.HwCommonSensor <em>Hw Common Sensor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Hw Common Sensor</em>'.
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.HwCommonSensor
	 * @generated
	 */
	EClass getHwCommonSensor();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.iotml.hardware.sensor.HwCommonSensor#getInputValueType <em>Input Value Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Input Value Type</em>'.
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.HwCommonSensor#getInputValueType()
	 * @see #getHwCommonSensor()
	 * @generated
	 */
	EReference getHwCommonSensor_InputValueType();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.iotml.hardware.sensor.HwCommonSensor#getOutputValueType <em>Output Value Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Output Value Type</em>'.
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.HwCommonSensor#getOutputValueType()
	 * @see #getHwCommonSensor()
	 * @generated
	 */
	EReference getHwCommonSensor_OutputValueType();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.iotml.hardware.sensor.HwCommonSensor#getHwcommonsensor <em>Hwcommonsensor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Hwcommonsensor</em>'.
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.HwCommonSensor#getHwcommonsensor()
	 * @see #getHwCommonSensor()
	 * @generated
	 */
	EReference getHwCommonSensor_Hwcommonsensor();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.iotml.hardware.sensor.HwCommonSensor#getTransferFunction <em>Transfer Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Transfer Function</em>'.
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.HwCommonSensor#getTransferFunction()
	 * @see #getHwCommonSensor()
	 * @generated
	 */
	EReference getHwCommonSensor_TransferFunction();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.iotml.hardware.sensor.HwRFIDReaderSensor <em>Hw RFID Reader Sensor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Hw RFID Reader Sensor</em>'.
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.HwRFIDReaderSensor
	 * @generated
	 */
	EClass getHwRFIDReaderSensor();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.papyrus.iotml.hardware.sensor.HwRFIDReaderSensor#getTag <em>Tag</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Tag</em>'.
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.HwRFIDReaderSensor#getTag()
	 * @see #getHwRFIDReaderSensor()
	 * @generated
	 */
	EReference getHwRFIDReaderSensor_Tag();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.iotml.hardware.sensor.HwTag <em>Hw Tag</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Hw Tag</em>'.
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.HwTag
	 * @generated
	 */
	EClass getHwTag();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.iotml.hardware.sensor.HwTag#getTageFrequency <em>Tage Frequency</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Tage Frequency</em>'.
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.HwTag#getTageFrequency()
	 * @see #getHwTag()
	 * @generated
	 */
	EAttribute getHwTag_TageFrequency();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	SensorFactory getSensorFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.iotml.hardware.sensor.impl.HwCommonSensorImpl <em>Hw Common Sensor</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.iotml.hardware.sensor.impl.HwCommonSensorImpl
		 * @see org.eclipse.papyrus.iotml.hardware.sensor.impl.SensorPackageImpl#getHwCommonSensor()
		 * @generated
		 */
		EClass HW_COMMON_SENSOR = eINSTANCE.getHwCommonSensor();

		/**
		 * The meta object literal for the '<em><b>Input Value Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HW_COMMON_SENSOR__INPUT_VALUE_TYPE = eINSTANCE.getHwCommonSensor_InputValueType();

		/**
		 * The meta object literal for the '<em><b>Output Value Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HW_COMMON_SENSOR__OUTPUT_VALUE_TYPE = eINSTANCE.getHwCommonSensor_OutputValueType();

		/**
		 * The meta object literal for the '<em><b>Hwcommonsensor</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HW_COMMON_SENSOR__HWCOMMONSENSOR = eINSTANCE.getHwCommonSensor_Hwcommonsensor();

		/**
		 * The meta object literal for the '<em><b>Transfer Function</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HW_COMMON_SENSOR__TRANSFER_FUNCTION = eINSTANCE.getHwCommonSensor_TransferFunction();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.iotml.hardware.sensor.impl.HwRFIDReaderSensorImpl <em>Hw RFID Reader Sensor</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.iotml.hardware.sensor.impl.HwRFIDReaderSensorImpl
		 * @see org.eclipse.papyrus.iotml.hardware.sensor.impl.SensorPackageImpl#getHwRFIDReaderSensor()
		 * @generated
		 */
		EClass HW_RFID_READER_SENSOR = eINSTANCE.getHwRFIDReaderSensor();

		/**
		 * The meta object literal for the '<em><b>Tag</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HW_RFID_READER_SENSOR__TAG = eINSTANCE.getHwRFIDReaderSensor_Tag();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.iotml.hardware.sensor.impl.HwTagImpl <em>Hw Tag</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.iotml.hardware.sensor.impl.HwTagImpl
		 * @see org.eclipse.papyrus.iotml.hardware.sensor.impl.SensorPackageImpl#getHwTag()
		 * @generated
		 */
		EClass HW_TAG = eINSTANCE.getHwTag();

		/**
		 * The meta object literal for the '<em><b>Tage Frequency</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HW_TAG__TAGE_FREQUENCY = eINSTANCE.getHwTag_TageFrequency();

	}

} //SensorPackage
