/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.GQAM;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LaxityKind implements Enumerator
{
    HARD(0, "hard", "hard"),
    SOFT(1, "soft", "soft"),
    OTHER(2, "other", "other");

    public static final int HARD_VALUE = 0;
    public static final int SOFT_VALUE = 1;
    public static final int OTHER_VALUE = 2;
    private static final LaxityKind[] VALUES_ARRAY;
    public static final List<LaxityKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LaxityKind[]{HARD, SOFT, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LaxityKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LaxityKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LaxityKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LaxityKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LaxityKind get(int value) {
        switch (value) {
            case 0: {
                return HARD;
            }
            case 1: {
                return SOFT;
            }
            case 2: {
                return OTHER;
            }
        }
        return null;
    }

    private LaxityKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

