/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_DesignModel.SRM.SW_Interaction;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum QueuePolicyKind implements Enumerator
{
    FIFO(0, "FIFO", "FIFO"),
    LIFO(1, "LIFO", "LIFO"),
    PRIORITY(2, "Priority", "Priority"),
    UNDEF(3, "Undef", "Undef"),
    OTHER(4, "Other", "Other");

    public static final int FIFO_VALUE = 0;
    public static final int LIFO_VALUE = 1;
    public static final int PRIORITY_VALUE = 2;
    public static final int UNDEF_VALUE = 3;
    public static final int OTHER_VALUE = 4;
    private static final QueuePolicyKind[] VALUES_ARRAY;
    public static final List<QueuePolicyKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new QueuePolicyKind[]{FIFO, LIFO, PRIORITY, UNDEF, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static QueuePolicyKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            QueuePolicyKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static QueuePolicyKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            QueuePolicyKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static QueuePolicyKind get(int value) {
        switch (value) {
            case 0: {
                return FIFO;
            }
            case 1: {
                return LIFO;
            }
            case 2: {
                return PRIORITY;
            }
            case 3: {
                return UNDEF;
            }
            case 4: {
                return OTHER;
            }
        }
        return null;
    }

    private QueuePolicyKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

