/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE_Library.MeasurementUnits;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum WeightUnitKind implements Enumerator
{
    G(0, "g", "g"),
    MG(1, "mg", "mg"),
    KG(2, "kg", "kg");

    public static final int G_VALUE = 0;
    public static final int MG_VALUE = 1;
    public static final int KG_VALUE = 2;
    private static final WeightUnitKind[] VALUES_ARRAY;
    public static final List<WeightUnitKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new WeightUnitKind[]{G, MG, KG};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static WeightUnitKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            WeightUnitKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static WeightUnitKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            WeightUnitKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static WeightUnitKind get(int value) {
        switch (value) {
            case 0: {
                return G;
            }
            case 1: {
                return MG;
            }
            case 2: {
                return KG;
            }
        }
        return null;
    }

    private WeightUnitKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

