/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.marte.vsl.extensions;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.marte.vsl.validation.VSLJavaValidator;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class VSLContextUtil {
    public static final VSLContextUtil eInstance = new VSLContextUtil();

    public static Type getExpectedType(EObject rule) {
        Method m;
        try {
            Class[] params = new Class[]{};
            m = rule.eContainer().getClass().getMethod("getExpectedType", params);
        }
        catch (Exception exception) {
            return VSLJavaValidator.getExpectedType();
        }
        try {
            Object[] args = new Object[]{};
            return (Type)m.invoke((Object)rule.eContainer(), args);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Namespace getModel(EObject rule) {
        Method m;
        try {
            Class[] params = new Class[]{};
            m = rule.eContainer().getClass().getMethod("getModel", params);
        }
        catch (Exception exception) {
            return VSLJavaValidator.getModel();
        }
        try {
            Object[] args = new Object[]{};
            return (Namespace)m.invoke((Object)rule.eContainer(), args);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Element getContextElement(EObject rule) {
        Method m;
        try {
            Class[] params = new Class[]{};
            m = rule.eContainer().getClass().getDeclaredMethod("getContextElement", params);
        }
        catch (Exception exception) {
            return VSLJavaValidator.getContextElement();
        }
        try {
            Object[] args = new Object[]{};
            return (Element)m.invoke((Object)rule.eContainer(), args);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static EObject getFilteredParentRule(EObject rule, Object metaclassFilter) {
        MetaclassFilter filter = null;
        if (metaclassFilter instanceof EClass) {
            VSLContextUtil vSLContextUtil = eInstance;
            vSLContextUtil.getClass();
            filter = vSLContextUtil.new MetaclassFilter((EClass)metaclassFilter);
        } else if (metaclassFilter instanceof EClass[]) {
            VSLContextUtil vSLContextUtil = eInstance;
            vSLContextUtil.getClass();
            filter = vSLContextUtil.new MetaclassFilter((EClass[])metaclassFilter);
        }
        if (filter == null) {
            return null;
        }
        if (rule != null) {
            EObject container = rule.eContainer();
            while (container != null && !filter.isInstance(container)) {
                container = container.eContainer();
            }
            if (container != null) {
                return container;
            }
        }
        return null;
    }

    public static boolean isAChoiceType(Classifier visited) {
        return visited.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::ChoiceType") != null;
    }

    public static List<NamedElement> getChoiceAttribs(Classifier visited) {
        EStructuralFeature choiceAttrib;
        EObject stereotypeApplication;
        List attribCollection;
        ArrayList<NamedElement> choiceAttribs = new ArrayList<NamedElement>();
        Stereotype tupleStereotype = visited.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::ChoiceType");
        if (tupleStereotype != null && (attribCollection = (List)(stereotypeApplication = visited.getStereotypeApplication(tupleStereotype)).eGet(choiceAttrib = stereotypeApplication.eClass().getEStructuralFeature("choiceAttrib"))).isEmpty()) {
            choiceAttribs.addAll((Collection<NamedElement>)visited.getAttributes());
        }
        return choiceAttribs;
    }

    public static boolean isATupleType(Classifier visited) {
        if (visited.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::TupleType") != null) {
            return true;
        }
        return visited.getAppliedStereotype("MARTE::MARTE_Foundations::NFPs::NfpType") != null;
    }

    public static List<NamedElement> getTupleAttribs(Classifier visited) {
        ArrayList<NamedElement> tupleAttribs = new ArrayList<NamedElement>();
        Stereotype tupleStereotype = visited.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::TupleType");
        if (tupleStereotype != null) {
            EStructuralFeature tupleAttribute;
            EObject stereotypeApplication = visited.getStereotypeApplication(tupleStereotype);
            List attribCollection = (List)stereotypeApplication.eGet(tupleAttribute = stereotypeApplication.eClass().getEStructuralFeature("tupleAttrib"));
            if (attribCollection.isEmpty()) {
                tupleAttribs.addAll((Collection<NamedElement>)visited.getAttributes());
            } else {
                tupleAttribs.addAll(attribCollection);
            }
        } else {
            Stereotype nfpStereotype = visited.getAppliedStereotype("MARTE::MARTE_Foundations::NFPs::NfpType");
            if (nfpStereotype != null) {
                tupleAttribs.addAll((Collection<NamedElement>)visited.getAttributes());
            }
        }
        for (Classifier general : visited.getGenerals()) {
            if (!VSLContextUtil.isATupleType(general)) continue;
            tupleAttribs.addAll(VSLContextUtil.getTupleAttribs(general));
        }
        return tupleAttribs;
    }

    public static boolean isACollectionType(Classifier visited) {
        return visited.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::CollectionType") != null;
    }

    public static NamedElement getCollectionAttrib(Classifier visited) {
        Property collectionAttrib = null;
        Stereotype collectionStereotype = visited.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::CollectionType");
        if (collectionStereotype != null) {
            EObject stereotypeApplication = visited.getStereotypeApplication(collectionStereotype);
            EStructuralFeature collectionAttribFeature = stereotypeApplication.eClass().getEStructuralFeature("collectionAttrib");
            collectionAttrib = (Property)stereotypeApplication.eGet(collectionAttribFeature);
        }
        return collectionAttrib;
    }

    public static boolean isAnIntervalType(Classifier visited) {
        return visited.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::IntervalType") != null;
    }

    public static NamedElement getIntervalAttrib(Classifier visited) {
        Property intervalAttrib = null;
        Stereotype intervalStereotype = visited.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::IntervalType");
        if (intervalStereotype != null) {
            EObject stereotypeApplication = visited.getStereotypeApplication(intervalStereotype);
            EStructuralFeature intervalAttribFeature = stereotypeApplication.eClass().getEStructuralFeature("intervalAttrib");
            intervalAttrib = (Property)stereotypeApplication.eGet(intervalAttribFeature);
        }
        return intervalAttrib;
    }

    public class MetaclassFilter {
        private EClass[] filters;

        public MetaclassFilter(EClass[] filters) {
            this.filters = filters;
        }

        public MetaclassFilter(EClass filter) {
            this(new EClass[]{filter});
        }

        public boolean isInstance(EObject eObject) {
            EClass[] eClassArray = this.filters;
            int n = this.filters.length;
            int n2 = 0;
            while (n2 < n) {
                EClass eClass = eClassArray[n2];
                if (eClass.isInstance((Object)eObject)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

